/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.netgeneric.BuildEngine;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.BuildNodeMerger;
import com.ibm.dltj.netgeneric.InPlaceMerger;
import com.ibm.dltj.netgeneric.Initializer;
import com.ibm.dltj.netgeneric.LoopReferenceCounter;
import com.ibm.dltj.netgeneric.Merger;
import com.ibm.dltj.netgeneric.MergerNodeAdapter;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.NetGenericImpl;
import com.ibm.dltj.netgeneric.NetGenericReadOnly;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import com.ibm.dltj.netgeneric.RegExBuilder;
import com.ibm.dltj.netgeneric.StageRebuilder;
import com.ibm.dltj.netgeneric.Statistics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;

final class NetGenericStaged
implements NetGenericFullAccess {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    public static final int DEFAULT_SIGNATURE = -2018189263;
    final int STAGING_THRESHOLD;
    final int STAGE_SHIFT;
    final int STAGE_MASK;
    final int first_link_index;
    int max_index;
    int stage_count;
    final NetGenericImpl net;
    static final int REFERRER_NONE = -1;

    NetGenericStaged(int n, int n2, int n3, Initializer initializer) {
        this.net = new NetGenericImpl(n, initializer);
        this.STAGING_THRESHOLD = n2;
        this.STAGE_SHIFT = n3;
        this.STAGE_MASK = (1 << this.STAGE_SHIFT) - 1;
        this.first_link_index = n;
        this.max_index = n;
        this.stage_count = 0;
    }

    NetGenericStaged(int n, Initializer initializer) {
        this(n, 256 - n, 7, initializer);
    }

    NetGenericStaged(PayloadManipulator[] payloadManipulatorArray, Initializer initializer) {
        this(payloadManipulatorArray.length, initializer);
        for (int i = 0; i < payloadManipulatorArray.length; ++i) {
            if (payloadManipulatorArray[i] == null) continue;
            this.net.setPayloadManipulator(i, payloadManipulatorArray[i]);
        }
    }

    @Override
    public void reset() {
        this.stage_count = 0;
        this.net.reset();
    }

    @Override
    public int first_base() {
        return this.net.first_base();
    }

    @Override
    public final boolean transitionPresent(int n, int n2) {
        if (n2 < this.net.getFirstLinkIndex() || this.stage_count == 0) {
            return this.net.transitionPresent(n, n2);
        }
        int n3 = n;
        int n4 = this.stage_count * this.STAGE_SHIFT;
        int n5 = (n2 - this.first_link_index >> n4) + this.first_link_index;
        if (!this.net.transitionPresent(n3, n5)) {
            return false;
        }
        n3 = this.net.transitionValue(n3, n5);
        n4 -= this.STAGE_SHIFT;
        while (n4 > 0) {
            n5 = (n2 - this.first_link_index >> n4 & this.STAGE_MASK) + this.first_link_index;
            if (!this.net.transitionPresent(n3, n5)) {
                return false;
            }
            n3 = this.net.transitionValue(n3, n5);
            n4 -= this.STAGE_SHIFT;
        }
        n5 = (n2 - this.first_link_index >> n4 & this.STAGE_MASK) + this.first_link_index;
        return this.net.transitionPresent(n3, n5);
    }

    @Override
    public final int transitionValue(int n, int n2) {
        if (n2 >= this.net.getFirstLinkIndex() && this.stage_count != 0) {
            int n3 = n;
            int n4 = this.stage_count * this.STAGE_SHIFT;
            int n5 = (n2 - this.first_link_index >> n4) + this.first_link_index;
            n3 = this.net.transitionValue(n3, n5);
            n4 -= this.STAGE_SHIFT;
            while (n4 > 0) {
                n5 = (n2 - this.first_link_index >> n4 & this.STAGE_MASK) + this.first_link_index;
                n3 = this.net.transitionValue(n3, n5);
                n4 -= this.STAGE_SHIFT;
            }
            n5 = (n2 - this.first_link_index >> n4 & this.STAGE_MASK) + this.first_link_index;
            n = n3;
            n2 = n5;
        }
        return this.net.transitionValue(n, n2);
    }

    @Override
    public final int takeTransition(int n, int n2, int n3) {
        if (n2 >= this.net.getFirstLinkIndex() && this.stage_count != 0) {
            int n4 = n;
            int n5 = this.stage_count * this.STAGE_SHIFT;
            int n6 = (n2 - this.first_link_index >> n5) + this.first_link_index;
            if (!this.net.transitionPresent(n4, n6)) {
                return n3;
            }
            n4 = this.net.transitionValue(n4, n6);
            n5 -= this.STAGE_SHIFT;
            while (n5 > 0) {
                n6 = (n2 - this.first_link_index >> n5 & this.STAGE_MASK) + this.first_link_index;
                n4 = this.net.transitionValue(n4, n6);
                n5 -= this.STAGE_SHIFT;
            }
            n6 = (n2 - this.first_link_index >> n5 & this.STAGE_MASK) + this.first_link_index;
            n = n4;
            n2 = n6;
        }
        return this.net.takeTransition(n, n2, n3);
    }

    @Override
    public final Object getPayload(int n, int n2, Object object) throws DLTException {
        if (!this.transitionPresent(n, n2)) {
            return object;
        }
        return this.net.manipulators[n2].getObject(this.transitionValue(n, n2));
    }

    @Override
    public int getEntry(NetGeneric.IndexIterator indexIterator) {
        if (this.stage_count == 0) {
            return this.net.getEntry(indexIterator);
        }
        return this.net.getEntry(new StagingIterator(indexIterator));
    }

    private final int gatherSubNodeTransitions(int n, int n2, int[] nArray, int n3, int n4) {
        int n5 = this.net.getMaxIndex();
        if (n == 0) {
            int n6 = 0;
            if (nArray != null) {
                for (int i = this.first_link_index; i < n5; ++i) {
                    if (!this.net.transitionPresent(n2, i)) continue;
                    nArray[n3 + n6++] = i + n4;
                }
            } else {
                for (int i = this.first_link_index; i < n5; ++i) {
                    if (!this.net.transitionPresent(n2, i)) continue;
                    ++n6;
                }
            }
            return n6;
        }
        int n7 = 1 << n * this.STAGE_SHIFT;
        --n;
        int n8 = 0;
        for (int i = this.first_link_index; i < n5; ++i) {
            if (this.net.transitionPresent(n2, i)) {
                n8 += this.gatherSubNodeTransitions(n, this.net.transitionValue(n2, i), nArray, n3 + n8, n4);
            }
            n4 += n7;
        }
        return n8;
    }

    @Override
    public final int gatherNodeLinks(int n, int[] nArray, int n2) {
        return this.gatherSubNodeTransitions(this.stage_count, n, nArray, n2, 0);
    }

    @Override
    public final int gatherNodeLinksCount(int n) {
        return this.gatherSubNodeTransitions(this.stage_count, n, null, 0, 0);
    }

    @Override
    public final int[] gatherNodeLinks(int n) {
        int n2 = this.gatherNodeLinksCount(n);
        int[] nArray = new int[n2];
        this.gatherNodeLinks(n, nArray, 0);
        return nArray;
    }

    @Override
    public int getFirstLinkIndex() {
        return this.first_link_index;
    }

    @Override
    public int getMaxIndex() {
        return this.max_index;
    }

    @Override
    public boolean isEmpty() {
        return this.net.isEmpty();
    }

    @Override
    public void setMaxIndex(int n) throws DLTException {
        while (n - this.first_link_index >> this.stage_count * this.STAGE_SHIFT >= this.STAGING_THRESHOLD) {
            if (this.stage_count == 0) {
                this.net.setMaxIndex(this.STAGING_THRESHOLD + this.first_link_index);
            }
            if (!this.isEmpty()) {
                StageRebuilder stageRebuilder = new StageRebuilder(this.net, this.stage_count + 1, this.STAGE_SHIFT);
                int n2 = this.net.first_base();
                this.net.getReferences().addReference(-1, n2);
                this.net.modifyEntry(NetGeneric.IndexIterator.Root, new NetGeneric.ChangeEncapsulator.Setter(-1));
                this.net.modifyEntry(NetGeneric.IndexIterator.Root, new Merger(this.net, stageRebuilder.getMergerNode(n2, 0)));
                this.net.getReferences().removeReference(-1, n2);
                ++this.stage_count;
                continue;
            }
            ++this.stage_count;
        }
        if (n < this.STAGING_THRESHOLD + this.first_link_index) {
            this.net.setMaxIndex(n);
        }
        this.max_index = n;
    }

    @Override
    public void startModify() {
        this.net.startModify();
    }

    @Override
    public void endModify() {
        this.net.endModify();
    }

    @Override
    public void modifyEntry(NetGeneric.IndexIterator indexIterator, NetGeneric.ChangeEncapsulator changeEncapsulator) throws DLTException {
        if (this.stage_count == 0) {
            this.net.modifyEntry(indexIterator, changeEncapsulator);
        } else {
            this.net.modifyEntry(new StagingIterator(indexIterator), changeEncapsulator);
        }
    }

    @Override
    public NetGenericReadOnly getReader() {
        return this;
    }

    @Override
    public int getSignature() {
        return this.net.getSignature() & 0xFFFFFF | 0x87000000;
    }

    @Override
    public int getSize() {
        return this.net.getSize();
    }

    @Override
    public void readNet(DataInput dataInput, int n, int n2, int n3) throws DLTException, IOException {
        this.stage_count = dataInput.readInt();
        assert (this.stage_count >= 0 && this.stage_count * this.STAGE_SHIFT < 32);
        this.net.readNet(dataInput, n, n2, n3);
    }

    @Override
    public long writeNet(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.stage_count);
        return this.net.writeNet(dataOutput) + 4L;
    }

    @Override
    public final void attachFSA(NetGeneric.IndexIterator indexIterator, Merger.MergerNode mergerNode) throws DLTException {
        if (this.stage_count == 0) {
            this.net.attachFSA(indexIterator, mergerNode);
        } else {
            BuildNode buildNode = new MergerNodeAdapter(mergerNode, this);
            buildNode = this.adaptBuildNode(buildNode);
            this.modifyEntry(indexIterator, new BuildNodeMerger(this.net, buildNode));
        }
    }

    @Override
    public final void attachFSA(NetGeneric.IndexIterator indexIterator, BuildNode buildNode) throws DLTException {
        if (this.stage_count == 0) {
            this.net.attachFSA(indexIterator, buildNode);
        } else {
            BuildNode buildNode2 = this.adaptBuildNode(buildNode);
            this.modifyEntry(indexIterator, new BuildNodeMerger(this.net, buildNode2));
        }
    }

    @Override
    public final void transformBranch(NetGeneric.IndexIterator indexIterator, Merger.MergerNode mergerNode) throws DLTException {
        if (this.stage_count == 0) {
            this.net.transformBranch(indexIterator, mergerNode);
        } else {
            this.ensureModifyStarted();
            BuildNode buildNode = new MergerNodeAdapter(mergerNode, this);
            buildNode = this.adaptBuildNode(buildNode);
            BuildEngine buildEngine = new BuildEngine(this.net);
            int n = buildEngine.buildAndIntegrate(buildNode);
            this.modifyEntry(indexIterator, new NetGeneric.ChangeEncapsulator.Setter(n));
        }
    }

    @Override
    public final void transformBranch(NetGeneric.IndexIterator indexIterator, BuildNode buildNode) throws DLTException {
        if (this.stage_count == 0) {
            this.net.transformBranch(indexIterator, buildNode);
        } else {
            this.ensureModifyStarted();
            BuildNode buildNode2 = this.adaptBuildNode(buildNode);
            InPlaceMerger inPlaceMerger = this.getInPlaceMerger();
            int n = inPlaceMerger.buildAndIntegrate(buildNode2);
            this.modifyEntry(indexIterator, new NetGeneric.ChangeEncapsulator.Setter(n));
        }
    }

    @Override
    public RegExBuilder getRegExBuilder() {
        return new RegExBuilder(this, this.net);
    }

    @Override
    public void forAllInstances(int n, NetGeneric.ChangeEncapsulator changeEncapsulator) throws DLTException {
        this.net.forAllInstances(n, changeEncapsulator);
    }

    @Override
    public PayloadManipulator getPayloadManipulator(int n) {
        return this.net.getPayloadManipulator(n);
    }

    @Override
    public PayloadManipulator setPayloadManipulator(int n, PayloadManipulator payloadManipulator) {
        return this.net.setPayloadManipulator(n, payloadManipulator);
    }

    private final int recursiveModifyNode(int n, int n2, int n3, int n4) throws DLTException {
        if (n == 0) {
            return this.net.modifyNode(n2, n3 + this.first_link_index, n4);
        }
        int n5 = n - this.STAGE_SHIFT;
        int n6 = (n3 >> n) + this.first_link_index;
        int n7 = -1;
        if (this.net.transitionPresent(n2, n6)) {
            n7 = this.net.transitionValue(n2, n6);
        }
        n4 = this.recursiveModifyNode(n5, n7, n3 & (1 << n) - 1, n4);
        return this.net.modifyNode(n2, n6, n4);
    }

    @Override
    public int modifyNode(int n, int n2, int n3) throws DLTException {
        if (this.stage_count == 0 || n2 < this.first_link_index) {
            return this.net.modifyNode(n, n2, n3);
        }
        return this.recursiveModifyNode(this.stage_count * this.STAGE_SHIFT, n, n2 - this.first_link_index, n3);
    }

    @Override
    public int addNode(final int[] nArray, final int[] nArray2, final int n) throws DLTException {
        if (this.stage_count == 0) {
            return this.net.addNode(nArray, nArray2, n);
        }
        class AddBuildNode
        extends BuildNodeBase {
            AddBuildNode() {
            }

            @Override
            public BuildNode getChild() throws DLTException {
                return AddBuildNode.makeAssignedNode(nArray2[this.depth]);
            }

            @Override
            public int getIndex() {
                return nArray[this.depth];
            }

            @Override
            public boolean nextTransition() {
                return ++this.depth < n;
            }
        }
        return this.net.merger.buildAndIntegrate(this.adaptBuildNode(new AddBuildNode()));
    }

    @Override
    public int addNode(final int[] nArray, final int n, final int n2) throws DLTException {
        if (this.stage_count == 0) {
            return this.net.addNode(nArray, n, n2);
        }
        class AddBuildNode
        extends BuildNodeBase {
            BuildNode link_node;

            AddBuildNode() {
                this.link_node = AddBuildNode.makeAssignedNode(n);
            }

            @Override
            public BuildNode getChild() throws DLTException {
                return this.link_node;
            }

            @Override
            public int getIndex() {
                return nArray[this.depth];
            }

            @Override
            public boolean nextTransition() {
                return ++this.depth < n2;
            }
        }
        return this.net.merger.buildAndIntegrate(this.adaptBuildNode(new AddBuildNode()));
    }

    @Override
    public LoopReferenceCounter getReferences() {
        return this.net.references;
    }

    @Override
    public void printStatistics(PrintStream printStream) {
        printStream.println("Staging FSA, max_index " + this.max_index + " stages " + (this.stage_count + 1) + " stage shift " + this.STAGE_SHIFT);
        this.net.printStatistics(printStream);
    }

    @Override
    public boolean verifyConsistency() {
        return this.net.verifyConsistency();
    }

    public void dumpBranch(PrintStream printStream, int n, HashSet<Integer> hashSet) {
        Integer n2 = n;
        if (hashSet.contains(n2)) {
            return;
        }
        hashSet.add(n2);
        this.dumpBase(printStream, n);
        for (int n3 : this.gatherNodeLinks(n)) {
            this.dumpBranch(printStream, this.transitionValue(n, n3), hashSet);
        }
    }

    @Override
    public void dumpNet(PrintStream printStream, int n) {
        this.dumpBranch(printStream, n, new HashSet<Integer>());
        printStream.println();
    }

    public void dumpBase(PrintStream printStream, int n) {
        int[] nArray = this.gatherNodeLinks(n);
        printStream.print("Base " + n + ": ");
        for (int i = 1; i < this.first_link_index; ++i) {
            if (!this.transitionPresent(n, i)) continue;
            int n2 = this.transitionValue(n, i);
            printStream.print(this.net.transToString.transitionToString(i, n2));
            printStream.print(' ');
        }
        for (int n3 : nArray) {
            int n4 = this.transitionValue(n, n3);
            printStream.print(this.net.transToString.transitionToString(n3, n4));
            printStream.print(' ');
        }
        printStream.println();
    }

    @Override
    public boolean dumpNet(PrintStream printStream) {
        printStream.println("First base: " + this.first_base());
        this.dumpNet(printStream, this.first_base());
        return true;
    }

    @Override
    public void setTransitionToStringMapper(Statistics statistics) {
        this.net.setTransitionToStringMapper(statistics);
    }

    @Override
    public String transitionToString(int n, int n2) {
        return this.net.transitionToString(n, n2);
    }

    @Override
    public void ensureModifyStarted() throws DLTException {
        this.net.ensureModifyStarted();
    }

    @Override
    public int getBiggestValue() {
        return this.net.getBiggestValue();
    }

    @Override
    public int forEachNode(final NetGeneric.ChangeEncapsulator changeEncapsulator) throws DLTException {
        if (this.stage_count == 0) {
            return this.net.forEachNode(changeEncapsulator);
        }
        class ForEachNode {
            Set<Integer> visited = new HashSet<Integer>();

            ForEachNode() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            int recurse(int n, int n2) throws DLTException {
                int n3 = 0;
                if (n2 == 0) {
                    if (this.visited.contains(n)) return 0;
                    n3 |= changeEncapsulator.Apply(n);
                    this.visited.add(n);
                } else if (++n2 == NetGenericStaged.this.stage_count + 1) {
                    n2 = 0;
                }
                for (int i = NetGenericStaged.this.net.getFirstLinkIndex(); i < NetGenericStaged.this.net.getMaxIndex(); ++i) {
                    if (!NetGenericStaged.this.net.transitionPresent(n, i)) continue;
                    n3 |= this.recurse(NetGenericStaged.this.net.transitionValue(n, i), n2);
                }
                return n3;
            }
        }
        return new ForEachNode().recurse(this.net.first_base(), 0);
    }

    @Override
    public BuildNode adaptBuildNode(BuildNode buildNode) {
        if (buildNode.getAssignedNode() != Integer.MIN_VALUE) {
            return buildNode;
        }
        return new StagedBuildNode(buildNode, this.stage_count, -1, Integer.MAX_VALUE);
    }

    @Override
    public InPlaceMerger getInPlaceMerger() {
        return this.net.merger;
    }

    final int indexToStageIndex(int n, int n2) {
        return (n - this.first_link_index >> n2 * this.STAGE_SHIFT & this.STAGE_MASK) + this.first_link_index;
    }

    final int stageSpanEnd(int n, int n2) {
        int n3 = (n2 + 1) * this.STAGE_SHIFT;
        return ((n - this.first_link_index >> n3) + 1 << n3) + this.first_link_index;
    }

    @Override
    public boolean isCyclic() {
        return this.net.isCyclic();
    }

    @Override
    public boolean isEquivalent(BuildNode buildNode) throws DLTException {
        return this.net.isEquivalent(this.adaptBuildNode(buildNode));
    }

    class StagedBuildLast
    extends BuildNodeBase {
        BuildNode originalNode;
        int mark;
        int span_end;

        public StagedBuildLast(BuildNode buildNode, int n, int n2) {
            this.originalNode = buildNode;
            this.mark = n;
            this.span_end = n2;
        }

        @Override
        public void endEnumeration() {
            this.originalNode.endEnumeration();
        }

        @Override
        public BuildNode getChild() throws DLTException {
            BuildNode buildNode = this.originalNode.getChild();
            return NetGenericStaged.this.adaptBuildNode(buildNode);
        }

        @Override
        public int getIndex() {
            return this.depth;
        }

        @Override
        public boolean nextTransition() {
            if (this.mark != -1 && this.depth == -1) {
                this.originalNode.resumeEnumeration(this.mark);
            } else if (!this.originalNode.nextTransition()) {
                return false;
            }
            int n = this.originalNode.getIndex();
            if (n >= this.span_end) {
                return false;
            }
            this.depth = NetGenericStaged.this.indexToStageIndex(n, 0);
            return true;
        }

        @Override
        public void startEnumeration() throws DLTException {
            if (this.mark == -1) {
                this.originalNode.startEnumeration();
            }
            this.depth = -1;
        }

        @Override
        public int markEnumeration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resumeEnumeration(int n) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.originalNode == null ? 0 : this.originalNode.hashCode());
            n = 31 * n + this.span_end;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StagedBuildLast stagedBuildLast = (StagedBuildLast)object;
            if (this.span_end != stagedBuildLast.span_end) {
                return false;
            }
            return !(this.originalNode == null ? stagedBuildLast.originalNode != null : !this.originalNode.equals(stagedBuildLast.originalNode));
        }

        @Override
        public String toString() {
            return this.originalNode.toString() + 'S' + '0';
        }

        @Override
        public void updateMaxIndex() throws DLTException {
            if (this.mark == -1) {
                int n = NetGenericStaged.this.stage_count;
                this.originalNode.updateMaxIndex();
                if (NetGenericStaged.this.stage_count != n) {
                    throw new DLTException(Messages.getString("NetGenericStaged.error.growth.unsupported"));
                }
            }
        }
    }

    class StagedBuildNode
    extends StagedBuildLast {
        StagedBuildLast currentChild;
        int stage;

        public StagedBuildNode(BuildNode buildNode, int n, int n2, int n3) {
            super(buildNode, n2, n3);
            this.stage = n;
        }

        @Override
        public BuildNode expandNode() throws DLTException {
            BuildNode buildNode = this.originalNode.expandNode();
            if (buildNode != this.originalNode) {
                return new StagedBuildNode(buildNode, this.stage, this.mark, this.span_end);
            }
            return this;
        }

        @Override
        public int getIndex() {
            if (this.depth < NetGenericStaged.this.first_link_index) {
                return this.depth;
            }
            return NetGenericStaged.this.indexToStageIndex(this.depth, this.stage);
        }

        @Override
        public BuildNode getChild() throws DLTException {
            if (this.depth < NetGenericStaged.this.first_link_index) {
                return this.originalNode.getChild();
            }
            int n = NetGenericStaged.this.stageSpanEnd(this.depth, this.stage - 1);
            this.currentChild = this.stage == 1 ? new StagedBuildLast(this.originalNode, this.originalNode.markEnumeration(), n) : new StagedBuildNode(this.originalNode, this.stage - 1, this.originalNode.markEnumeration(), n);
            return this.currentChild;
        }

        @Override
        public boolean nextTransition() {
            int n;
            if (this.mark != -1 && this.depth == -1) {
                this.originalNode.resumeEnumeration(this.mark);
            } else if (!this.originalNode.nextTransition()) {
                return false;
            }
            int n2 = this.originalNode.getIndex();
            if (n2 < NetGenericStaged.this.first_link_index) {
                this.depth = n2;
                return true;
            }
            if (n2 >= this.span_end) {
                return false;
            }
            int n3 = n = this.currentChild == null ? NetGenericStaged.this.first_link_index : this.currentChild.span_end;
            while (n2 < n) {
                if (!this.originalNode.nextTransition()) {
                    return false;
                }
                n2 = this.originalNode.getIndex();
            }
            if (n2 >= this.span_end) {
                return false;
            }
            this.depth = n2;
            return true;
        }

        @Override
        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.originalNode == null ? 0 : this.originalNode.hashCode());
            n = 31 * n + this.span_end;
            n = 31 * n + this.stage;
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StagedBuildNode stagedBuildNode = (StagedBuildNode)object;
            if (this.span_end != stagedBuildNode.span_end) {
                return false;
            }
            if (this.stage != stagedBuildNode.stage) {
                return false;
            }
            return !(this.originalNode == null ? stagedBuildNode.originalNode != null : !this.originalNode.equals(stagedBuildNode.originalNode));
        }

        @Override
        public String toString() {
            return this.originalNode.toString() + 'S' + this.stage;
        }
    }

    class StagingIterator
    implements NetGeneric.IndexIterator {
        final NetGeneric.IndexIterator it;
        int v;
        int shift;

        StagingIterator(NetGeneric.IndexIterator indexIterator) {
            this.it = indexIterator;
            this.shift = 0;
        }

        @Override
        public int first() {
            this.v = this.it.first() - NetGenericStaged.this.first_link_index;
            if (this.v < 0) {
                this.shift = 0;
                return this.v + NetGenericStaged.this.first_link_index;
            }
            this.shift = NetGenericStaged.this.stage_count * NetGenericStaged.this.STAGE_SHIFT;
            return (this.v >> this.shift) + NetGenericStaged.this.first_link_index;
        }

        @Override
        public int next() {
            if (this.shift == 0) {
                this.shift = NetGenericStaged.this.stage_count * NetGenericStaged.this.STAGE_SHIFT;
                this.v = this.it.next() - NetGenericStaged.this.first_link_index;
                if (this.v < 0) {
                    this.shift = 0;
                    return this.v + NetGenericStaged.this.first_link_index;
                }
                return (this.v >> this.shift) + NetGenericStaged.this.first_link_index;
            }
            this.shift -= NetGenericStaged.this.STAGE_SHIFT;
            return (this.v >> this.shift & NetGenericStaged.this.STAGE_MASK) + NetGenericStaged.this.first_link_index;
        }
    }
}

