/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NonDeterministicBuildNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NonDeterministicNodeAdapter {
    NetGeneric net;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    Set<NonDeterministicBuildNode> makeSet(int n) {
        return new HashSet<NonDeterministicBuildNode>(n);
    }

    public NonDeterministicNodeAdapter(NetGeneric netGeneric) {
        this.net = netGeneric;
    }

    public static AdapterBase createAdapter(NonDeterministicBuildNode nonDeterministicBuildNode, NetGeneric netGeneric) {
        NonDeterministicNodeAdapter nonDeterministicNodeAdapter = new NonDeterministicNodeAdapter(netGeneric);
        if (netGeneric.getMaxIndex() <= 128) {
            NonDeterministicNodeAdapter nonDeterministicNodeAdapter2 = nonDeterministicNodeAdapter;
            nonDeterministicNodeAdapter2.getClass();
            return nonDeterministicNodeAdapter2.new Direct(nonDeterministicBuildNode);
        }
        NonDeterministicNodeAdapter nonDeterministicNodeAdapter3 = nonDeterministicNodeAdapter;
        nonDeterministicNodeAdapter3.getClass();
        return nonDeterministicNodeAdapter3.new Mapped(nonDeterministicBuildNode);
    }

    Integer getInteger(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof BuildNode) {
            if (!((BuildNode)object).isFinalized()) {
                return null;
            }
            return ((BuildNode)object).getAssignedNode();
        }
        return null;
    }

    static NonDeterministicBuildNode nonDeterministicNode(NetGeneric netGeneric, Object object) throws DLTException {
        if (object instanceof NonDeterministicBuildNode) {
            return (NonDeterministicBuildNode)object;
        }
        if (object instanceof Integer) {
            return new AssignedNodeWrapper(netGeneric, (Integer)object);
        }
        BuildNode buildNode = (BuildNode)object;
        if (buildNode.isFinalized()) {
            return new AssignedNodeWrapper(netGeneric, buildNode.getAssignedNode());
        }
        buildNode = buildNode.expandNode();
        return new NDWrapper(buildNode);
    }

    class Direct
    extends AdapterBase {
        Object[] transitions;

        public Direct(NonDeterministicBuildNode nonDeterministicBuildNode) {
            super(nonDeterministicBuildNode);
        }

        public Direct(Set<NonDeterministicBuildNode> set) {
            super(set);
        }

        @Override
        public void startEnumeration() throws DLTException {
            assert (this.expanded);
            this.transitions = new Object[NonDeterministicNodeAdapter.this.net.getMaxIndex()];
            for (NonDeterministicBuildNode nonDeterministicBuildNode : this.nodes) {
                nonDeterministicBuildNode.startEnumeration();
                while (nonDeterministicBuildNode.nextTransition()) {
                    Object object = nonDeterministicBuildNode.getChild();
                    if (object == null) continue;
                    int n = nonDeterministicBuildNode.getIndex();
                    Object object2 = this.transitions[n];
                    if (object2 != null) {
                        Object object3;
                        if (n < NonDeterministicNodeAdapter.this.net.getFirstLinkIndex()) {
                            object3 = NonDeterministicNodeAdapter.this.getInteger(object);
                            Integer n2 = (Integer)object2;
                            this.transitions[n] = object = Integer.valueOf(NonDeterministicNodeAdapter.this.net.getPayloadManipulator(n).mergeInternal((Integer)object3, n2));
                            continue;
                        }
                        if (object2 instanceof AdapterBase) {
                            object3 = (AdapterBase)object2;
                        } else {
                            this.transitions[n] = object3 = new Direct(NonDeterministicNodeAdapter.nonDeterministicNode(NonDeterministicNodeAdapter.this.net, object2));
                        }
                        ((AdapterBase)object3).nodes.add(NonDeterministicNodeAdapter.nonDeterministicNode(NonDeterministicNodeAdapter.this.net, object));
                        continue;
                    }
                    if (object instanceof NonDeterministicBuildNode) {
                        this.transitions[n] = new Direct((NonDeterministicBuildNode)object);
                        continue;
                    }
                    assert (object instanceof Integer || object instanceof BuildNode);
                    if (n < NonDeterministicNodeAdapter.this.net.getFirstLinkIndex()) {
                        object = NonDeterministicNodeAdapter.this.getInteger(object);
                    }
                    this.transitions[n] = object;
                }
                nonDeterministicBuildNode.endEnumeration();
            }
            this.depth = 0;
        }

        @Override
        public BuildNode getChild() throws DLTException {
            Object object = this.transitions[this.depth];
            if (object instanceof Integer) {
                return Direct.makeAssignedNode((Integer)object);
            }
            return (BuildNode)object;
        }

        @Override
        public int getIndex() {
            return this.depth;
        }

        @Override
        public boolean nextTransition() {
            int n = this.depth;
            int n2 = NonDeterministicNodeAdapter.this.net.getMaxIndex();
            do {
                if (++n != n2) continue;
                return false;
            } while (this.transitions[n] == null);
            this.depth = n;
            return true;
        }

        @Override
        public void endEnumeration() {
            super.endEnumeration();
            if (!this.marked) {
                this.transitions = null;
            }
        }

        @Override
        AdapterBase newNode(Set<NonDeterministicBuildNode> set) {
            return new Direct(set);
        }
    }

    class Mapped
    extends AdapterBase {
        List<Map.Entry<Integer, Object>> transition_list;

        public Mapped(NonDeterministicBuildNode nonDeterministicBuildNode) {
            super(nonDeterministicBuildNode);
        }

        public Mapped(Set<NonDeterministicBuildNode> set) {
            super(set);
        }

        @Override
        public void startEnumeration() throws DLTException {
            assert (this.expanded);
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            for (NonDeterministicBuildNode nonDeterministicBuildNode : this.nodes) {
                nonDeterministicBuildNode.startEnumeration();
                while (nonDeterministicBuildNode.nextTransition()) {
                    Object object = nonDeterministicBuildNode.getChild();
                    if (object == null) continue;
                    int n = nonDeterministicBuildNode.getIndex();
                    Object v = hashMap.get(n);
                    if (v != null) {
                        Object object2;
                        if (n < NonDeterministicNodeAdapter.this.net.getFirstLinkIndex()) {
                            object2 = NonDeterministicNodeAdapter.this.getInteger(object);
                            Integer n2 = (Integer)v;
                            object = NonDeterministicNodeAdapter.this.net.getPayloadManipulator(n).mergeInternal((Integer)object2, n2);
                            hashMap.put(n, object);
                            continue;
                        }
                        if (v instanceof AdapterBase) {
                            object2 = (AdapterBase)v;
                        } else {
                            object2 = new Mapped(NonDeterministicNodeAdapter.nonDeterministicNode(NonDeterministicNodeAdapter.this.net, v));
                            hashMap.put(n, object2);
                        }
                        ((AdapterBase)object2).nodes.add(NonDeterministicNodeAdapter.nonDeterministicNode(NonDeterministicNodeAdapter.this.net, object));
                        continue;
                    }
                    if (object instanceof NonDeterministicBuildNode) {
                        hashMap.put(n, new Mapped((NonDeterministicBuildNode)object));
                        continue;
                    }
                    assert (object instanceof Integer || object instanceof BuildNode);
                    if (n < NonDeterministicNodeAdapter.this.net.getFirstLinkIndex()) {
                        object = NonDeterministicNodeAdapter.this.getInteger(object);
                    }
                    hashMap.put(n, object);
                }
                nonDeterministicBuildNode.endEnumeration();
            }
            this.transition_list = new ArrayList<Map.Entry<Integer, Object>>(hashMap.size());
            this.transition_list.addAll(hashMap.entrySet());
            Collections.sort(this.transition_list, new Comparator<Map.Entry<Integer, Object>>(){

                @Override
                public int compare(Map.Entry<Integer, Object> entry, Map.Entry<Integer, Object> entry2) {
                    return entry.getKey() - entry2.getKey();
                }
            });
            this.depth = -1;
        }

        @Override
        public void endEnumeration() {
            super.endEnumeration();
            if (!this.marked) {
                this.transition_list = null;
            }
        }

        @Override
        public BuildNode getChild() throws DLTException {
            Object object = this.transition_list.get(this.depth).getValue();
            if (object instanceof Integer) {
                return Mapped.makeAssignedNode((Integer)object);
            }
            return (BuildNode)object;
        }

        @Override
        public int getIndex() {
            return this.transition_list.get(this.depth).getKey();
        }

        @Override
        public boolean nextTransition() {
            ++this.depth;
            return this.depth < this.transition_list.size();
        }

        @Override
        AdapterBase newNode(Set<NonDeterministicBuildNode> set) {
            return new Mapped(set);
        }
    }

    abstract class AdapterBase
    extends BuildNodeBase {
        Set<NonDeterministicBuildNode> nodes;
        boolean marked = false;
        boolean expanded = false;

        public AdapterBase(NonDeterministicBuildNode nonDeterministicBuildNode) {
            this.nodes = NonDeterministicNodeAdapter.this.makeSet(9);
            this.nodes.add(nonDeterministicBuildNode);
        }

        public AdapterBase(Set<NonDeterministicBuildNode> set) {
            this.nodes = set;
        }

        abstract AdapterBase newNode(Set<NonDeterministicBuildNode> var1);

        @Override
        public BuildNode expandNode() throws DLTException {
            Set<NonDeterministicBuildNode> set = null;
            ArrayList<Object> arrayList = null;
            for (NonDeterministicBuildNode nonDeterministicBuildNode : this.nodes) {
                Object object;
                if (!nonDeterministicBuildNode.startEpsilonEnumeration()) continue;
                if (set == null) {
                    set = NonDeterministicNodeAdapter.this.makeSet(this.nodes.size() + 8);
                    set.addAll(this.nodes);
                }
                while ((object = nonDeterministicBuildNode.nextEpsilonTransition()) != null) {
                    if (!set.add((NonDeterministicBuildNode)object)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    arrayList.add(object);
                }
            }
            if (arrayList == null) {
                return this.setExpanded();
            }
            ArrayList<Object> arrayList2 = new ArrayList();
            do {
                NonDeterministicBuildNode nonDeterministicBuildNode;
                nonDeterministicBuildNode = arrayList;
                arrayList = arrayList2;
                arrayList2 = nonDeterministicBuildNode;
                arrayList.clear();
                for (NonDeterministicBuildNode nonDeterministicBuildNode2 : arrayList2) {
                    NonDeterministicBuildNode nonDeterministicBuildNode3;
                    if (!nonDeterministicBuildNode2.startEpsilonEnumeration()) continue;
                    while ((nonDeterministicBuildNode3 = nonDeterministicBuildNode2.nextEpsilonTransition()) != null) {
                        if (!set.add(nonDeterministicBuildNode3)) continue;
                        arrayList.add(nonDeterministicBuildNode3);
                    }
                }
            } while (!arrayList.isEmpty());
            return this.newNode(set).setExpanded();
        }

        private AdapterBase setExpanded() {
            this.expanded = true;
            return this;
        }

        @Override
        public void updateMaxIndex() throws DLTException {
            for (NonDeterministicBuildNode nonDeterministicBuildNode : this.nodes) {
                nonDeterministicBuildNode.updateMaxIndex();
            }
        }

        @Override
        public int markEnumeration() {
            this.marked = true;
            return super.markEnumeration();
        }

        @Override
        public String toString() {
            return this.nodes.toString() + (this.assigned_node != Integer.MIN_VALUE ? "A" + this.assigned_node : "");
        }

        public int hashCode() {
            return ((Object)this.nodes).hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            AdapterBase adapterBase = (AdapterBase)object;
            return ((Object)this.nodes).equals(adapterBase.nodes);
        }
    }

    static class AssignedNodeWrapper
    implements NonDeterministicBuildNode {
        NetGeneric net;
        int node;
        int pos;

        public AssignedNodeWrapper(NetGeneric netGeneric, int n) {
            this.net = netGeneric;
            this.node = n;
        }

        @Override
        public boolean startEpsilonEnumeration() throws DLTException {
            return false;
        }

        @Override
        public NonDeterministicBuildNode nextEpsilonTransition() {
            assert (false);
            return null;
        }

        @Override
        public void startEnumeration() throws DLTException {
            this.pos = 0;
        }

        @Override
        public Object getChild() throws DLTException {
            return this.net.transitionValue(this.node, this.pos);
        }

        @Override
        public int getIndex() {
            return this.pos;
        }

        @Override
        public boolean nextTransition() {
            int n = this.net.getMaxIndex();
            while (++this.pos < n) {
                if (!this.net.transitionPresent(this.node, this.pos)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endEnumeration() {
        }

        public boolean equals(Object object) {
            if (object instanceof AssignedNodeWrapper) {
                return this.node == ((AssignedNodeWrapper)object).node;
            }
            if (object instanceof Integer) {
                return this.node == (Integer)object;
            }
            if (object instanceof BuildNode) {
                BuildNode buildNode = (BuildNode)object;
                if (!buildNode.isFinalized()) {
                    return false;
                }
                return this.node == buildNode.getAssignedNode();
            }
            return false;
        }

        public int hashCode() {
            return this.node;
        }

        @Override
        public void updateMaxIndex() throws DLTException {
        }
    }

    static class NDWrapper
    implements NonDeterministicBuildNode {
        BuildNode bn;

        public NDWrapper(BuildNode buildNode) {
            this.bn = buildNode;
        }

        @Override
        public boolean startEpsilonEnumeration() throws DLTException {
            return false;
        }

        @Override
        public NonDeterministicBuildNode nextEpsilonTransition() {
            assert (false);
            return null;
        }

        @Override
        public void startEnumeration() throws DLTException {
            this.bn.startEnumeration();
        }

        @Override
        public Object getChild() throws DLTException {
            return this.bn.getChild();
        }

        @Override
        public int getIndex() {
            return this.bn.getIndex();
        }

        @Override
        public boolean nextTransition() {
            return this.bn.nextTransition();
        }

        @Override
        public void endEnumeration() {
            this.bn.endEnumeration();
        }

        public boolean equals(Object object) {
            if (object instanceof NDWrapper) {
                return this.bn.equals(((NDWrapper)object).bn);
            }
            if (object instanceof BuildNode) {
                return this.bn.equals(object);
            }
            return false;
        }

        public int hashCode() {
            return this.bn.hashCode();
        }

        @Override
        public void updateMaxIndex() throws DLTException {
            this.bn.updateMaxIndex();
        }
    }
}

