/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;

public interface PayloadManipulator {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    public static final PayloadManipulator Undefined = new UndefinedManipulator();
    public static final PayloadManipulator SimpleInteger = new SimpleIntegerManipulator();

    public void dereference(int var1);

    public int reference(int var1);

    public int mergeInternal(int var1, int var2) throws DLTException;

    public int intersectInternal(int var1, int var2) throws DLTException;

    public int subtractInternal(int var1, int var2) throws DLTException;

    public int merge(int var1, Object var2) throws DLTException;

    public int intersect(int var1, Object var2) throws DLTException;

    public int subtract(int var1, Object var2) throws DLTException;

    public Object getObject(int var1) throws DLTException;

    public static class SimpleIntegerManipulator
    implements PayloadManipulator {
        @Override
        public void dereference(int n) {
        }

        @Override
        public Object getObject(int n) throws DLTException {
            return n;
        }

        @Override
        public int merge(int n, Object object) throws DLTException {
            if (n == -1 || n == (Integer)object) {
                return (Integer)object;
            }
            throw new DLTException(Messages.getString("payload.conflict"));
        }

        @Override
        public int mergeInternal(int n, int n2) throws DLTException {
            if (n == -1 || n == n2) {
                return n2;
            }
            if (n2 == -1) {
                return n;
            }
            throw new DLTException(Messages.getString("payload.conflict"));
        }

        @Override
        public int reference(int n) {
            return n;
        }

        @Override
        public int intersect(int n, Object object) throws DLTException {
            if (object == null) {
                return -1;
            }
            int n2 = (Integer)object;
            if (n == n2) {
                return n2;
            }
            if (n == -1 || n2 == -1) {
                return -1;
            }
            throw new DLTException(Messages.getString("payload.conflict"));
        }

        @Override
        public int intersectInternal(int n, int n2) throws DLTException {
            if (n == n2) {
                return n2;
            }
            if (n == -1 || n2 == -1) {
                return -1;
            }
            throw new DLTException(Messages.getString("payload.conflict"));
        }

        @Override
        public int subtract(int n, Object object) throws DLTException {
            if (object == null) {
                return n;
            }
            int n2 = (Integer)object;
            if (n == n2 || n == -1) {
                return -1;
            }
            throw new DLTException(Messages.getString("payload.conflict"));
        }

        @Override
        public int subtractInternal(int n, int n2) throws DLTException {
            if (n == n2 || n == -1) {
                return -1;
            }
            if (n2 == -1) {
                return n;
            }
            throw new DLTException(Messages.getString("payload.conflict"));
        }
    }

    public static class UndefinedManipulator
    implements PayloadManipulator {
        @Override
        public void dereference(int n) {
            assert (false);
        }

        @Override
        public Object getObject(int n) throws DLTException {
            throw new DLTException(Messages.getString("payload.undefined"));
        }

        @Override
        public int merge(int n, Object object) throws DLTException {
            throw new DLTException(Messages.getString("payload.undefined"));
        }

        @Override
        public int mergeInternal(int n, int n2) throws DLTException {
            throw new DLTException(Messages.getString("payload.undefined"));
        }

        @Override
        public int reference(int n) {
            assert (false);
            return n;
        }

        @Override
        public int intersect(int n, Object object) throws DLTException {
            throw new DLTException(Messages.getString("payload.undefined"));
        }

        @Override
        public int intersectInternal(int n, int n2) throws DLTException {
            throw new DLTException(Messages.getString("payload.undefined"));
        }

        @Override
        public int subtract(int n, Object object) throws DLTException {
            throw new DLTException(Messages.getString("payload.undefined"));
        }

        @Override
        public int subtractInternal(int n, int n2) throws DLTException {
            throw new DLTException(Messages.getString("payload.undefined"));
        }
    }
}

