/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.Merger;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.util.IntArray;
import com.ibm.dltj.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class Permutations {
    final Map<Integer, TransData> trans_map;
    final Merger.MergerNode end_node;
    final Merger.MergerNode start_node;
    final int[] group_counts;
    final int[] optional_states;
    final TransGroupPair[] sorted_trans;
    static final int[] empty_array = new int[0];

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private Permutations(Map<Integer, TransData> map, int[] nArray, Merger.MergerNode mergerNode, int[] nArray2, int[] nArray3, TransGroupPair[] transGroupPairArray) {
        this.trans_map = map;
        this.end_node = mergerNode;
        this.group_counts = nArray2;
        this.optional_states = nArray3;
        this.sorted_trans = transGroupPairArray;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] - nArray3[i];
        }
        this.start_node = new PermNode(nArray, n);
    }

    Merger.MergerNode getPermutations() {
        return this.start_node;
    }

    static Permutations createPermutations(int[][] nArray, boolean[] blArray, Merger.MergerNode mergerNode) throws DLTException {
        int[] nArray22;
        int n = 0;
        HashMap<Integer, TransData> hashMap = new HashMap<Integer, TransData>(nArray.length);
        ArrayList<TransGroupPair> arrayList = new ArrayList<TransGroupPair>(nArray.length);
        IntArray intArray = new IntArray(nArray.length);
        int n2 = 0;
        for (int[] nArray22 : nArray) {
            Object object = (TransData)hashMap.get(nArray22[0]);
            if (object != null) {
                ++((TransData)object).count;
                if (blArray != null && blArray[n2]) {
                    ++((TransData)object).optional_count;
                }
                if (!Arrays.equals(((TransData)object).group, nArray22)) {
                    return null;
                }
            } else {
                object = new TransData(n++, nArray22);
                if (blArray != null && blArray[n2]) {
                    ++((TransData)object).optional_count;
                }
                for (int i = 0; i < nArray22.length; ++i) {
                    TransData transData = hashMap.put(nArray22[i], (TransData)object);
                    if (transData != null) {
                        return null;
                    }
                    arrayList.add(new TransGroupPair(nArray22[i], ((TransData)object).group_idx));
                }
                intArray.add(nArray22.length);
            }
            ++n2;
        }
        Object[] objectArray = arrayList.toArray(new TransGroupPair[0]);
        Arrays.sort(objectArray);
        int[] nArray3 = intArray.getData();
        int[] nArray4 = new int[nArray3.length];
        nArray22 = new int[nArray3.length];
        for (Map.Entry entry : hashMap.entrySet()) {
            nArray4[((TransData)entry.getValue()).group_idx] = ((TransData)entry.getValue()).count;
            nArray22[((TransData)entry.getValue()).group_idx] = ((TransData)entry.getValue()).optional_count;
        }
        return new Permutations(hashMap, nArray4, mergerNode, nArray3, nArray22, (TransGroupPair[])objectArray);
    }

    static void addPermutations(NetGeneric netGeneric, NetGeneric.IndexIterator indexIterator, int[][] nArray, boolean[] blArray, Merger.MergerNode mergerNode) throws DLTException {
        Permutations permutations = Permutations.createPermutations(nArray, blArray, mergerNode);
        if (permutations != null) {
            netGeneric.attachFSA(indexIterator, permutations.getPermutations());
            return;
        }
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = i + 1; j < n; ++j) {
                int[] nArray3 = nArray[j];
                if (!Utils.setsIntersect(nArray2, nArray3) || Arrays.equals(nArray2, nArray3)) continue;
                int[] nArray4 = Utils.intersection(nArray2, nArray3);
                if (Arrays.equals(nArray4, nArray3)) {
                    nArray[i] = nArray4;
                    Permutations.addPermutations(netGeneric, indexIterator, nArray, blArray, mergerNode);
                    nArray[i] = Utils.removeExisting(nArray2, nArray4);
                    Permutations.addPermutations(netGeneric, indexIterator, nArray, blArray, mergerNode);
                    nArray[i] = nArray2;
                } else {
                    nArray[j] = nArray4;
                    Permutations.addPermutations(netGeneric, indexIterator, nArray, blArray, mergerNode);
                    nArray[j] = Utils.removeExisting(nArray3, nArray4);
                    Permutations.addPermutations(netGeneric, indexIterator, nArray, blArray, mergerNode);
                    nArray[j] = nArray3;
                }
                return;
            }
        }
    }

    public static void addPermutations(NetGeneric netGeneric, NetGeneric.IndexIterator indexIterator, int[][] nArray, boolean[] blArray, int n, Object object) throws DLTException {
        Permutations.addPermutations(netGeneric, indexIterator, nArray, blArray, new EndNode(n, object));
    }

    static final class EndNode
    implements Merger.MergerNode {
        final int end_index;
        final Object end_value;

        EndNode(int n, Object object) {
            this.end_index = n;
            this.end_value = object;
        }

        @Override
        public int[] gatherLinks() {
            return empty_array;
        }

        @Override
        public Merger.MergerNode getTransition(int n) throws DLTException {
            assert (false);
            return null;
        }

        @Override
        public boolean startCopy() throws DLTException {
            return true;
        }

        @Override
        public boolean transitionPresent(int n) {
            return n == this.end_index;
        }

        @Override
        public Object transitionValue(int n) throws DLTException {
            assert (n == this.end_index);
            return this.end_value;
        }

        @Override
        public void finalizeCopy() {
        }
    }

    final class PermNode
    implements Merger.MergerNode {
        int[] state;
        int state_count;

        PermNode(int[] nArray, int n) {
            this.state = nArray;
            assert (n >= 0);
            this.state_count = n;
        }

        @Override
        public boolean startCopy() throws DLTException {
            return true;
        }

        @Override
        public int[] gatherLinks() {
            int n = 0;
            for (int i = 0; i < this.state.length; ++i) {
                if (this.state[i] <= 0) continue;
                n += Permutations.this.group_counts[i];
            }
            int[] nArray = new int[n];
            n = 0;
            for (TransGroupPair transGroupPair : Permutations.this.sorted_trans) {
                if (this.state[transGroupPair.group_idx] <= 0) continue;
                nArray[n++] = transGroupPair.trans;
            }
            return nArray;
        }

        @Override
        public boolean transitionPresent(int n) {
            if (this.state_count == 0 && Permutations.this.end_node.transitionPresent(n)) {
                return true;
            }
            TransData transData = Permutations.this.trans_map.get(n);
            return transData != null && this.state[transData.group_idx] > 0;
        }

        @Override
        public Object transitionValue(int n) throws DLTException {
            if (this.state_count == 0) {
                return Permutations.this.end_node.transitionValue(n);
            }
            return null;
        }

        @Override
        public Merger.MergerNode getTransition(int n) throws DLTException {
            TransData transData = Permutations.this.trans_map.get(n);
            int[] nArray = (int[])this.state.clone();
            int n2 = transData.group_idx;
            nArray[n2] = nArray[n2] - 1;
            assert (nArray[transData.group_idx] >= 0);
            int n3 = this.state_count;
            if (this.state[transData.group_idx] > Permutations.this.optional_states[transData.group_idx]) {
                --n3;
            }
            return new PermNode(nArray, n3);
        }

        @Override
        public void finalizeCopy() {
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.state);
        }

        @Override
        public boolean equals(Object object) {
            PermNode permNode = (PermNode)object;
            return Arrays.equals(this.state, permNode.state);
        }
    }

    private static final class TransGroupPair
    implements Comparable<TransGroupPair> {
        int trans;
        int group_idx;

        TransGroupPair(int n, int n2) {
            this.trans = n;
            this.group_idx = n2;
        }

        @Override
        public int compareTo(TransGroupPair transGroupPair) {
            return this.trans - transGroupPair.trans;
        }
    }

    private static final class TransData {
        int group_idx;
        int count;
        int optional_count;
        int[] group;

        TransData(int n, int[] nArray) {
            this.group_idx = n;
            this.count = 1;
            this.optional_count = 0;
            this.group = nArray;
        }
    }
}

