/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.BuildNodeIntersector;
import com.ibm.dltj.netgeneric.BuildNodeSubtractor;
import com.ibm.dltj.netgeneric.InPlaceIntersector;
import com.ibm.dltj.netgeneric.InPlaceMerger;
import com.ibm.dltj.netgeneric.InPlaceSubtractor;
import com.ibm.dltj.netgeneric.LoopMaker;
import com.ibm.dltj.netgeneric.LoopReferenceCounter;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.NetGenericImpl;
import com.ibm.dltj.netgeneric.NonDeterministicBuildNode;
import com.ibm.dltj.netgeneric.NonDeterministicNodeAdapter;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class RegExBuilder {
    final NetGenericFullAccess net;
    final LoopMaker loopMaker;
    final InPlaceMerger merger;
    int loopnest;
    static final int REFERRER_NONE = -1;
    static final int BASE_EMPTY = -1;
    static final int VALUE_NOT_PRESENT = -1;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public RegExBuilder(NetGenericFullAccess netGenericFullAccess, NetGenericImpl netGenericImpl) {
        this.net = netGenericFullAccess;
        if (netGenericFullAccess != null) {
            this.loopMaker = new LoopMaker(netGenericImpl);
            this.merger = new InPlaceMerger(netGenericImpl, -1);
        } else {
            this.loopMaker = null;
            this.merger = null;
        }
        this.loopnest = 0;
    }

    public RegExElement createTransition(int n) {
        return new RegExTransition(n);
    }

    public RegExElement createIntValue(int n, Object object) throws DLTException {
        return new RegExIntValue(n, this.net.getPayloadManipulator(n).merge(-1, object));
    }

    private RegExElement[] toArray(List<RegExElement> list) {
        RegExElement[] regExElementArray = new RegExElement[list.size()];
        int n = 0;
        Iterator<RegExElement> iterator = list.iterator();
        while (iterator.hasNext()) {
            regExElementArray[n++] = iterator.next();
        }
        return regExElementArray;
    }

    public RegExElement createEmpty() {
        RegExElement[] regExElementArray = new RegExElement[]{};
        return new RegExConcatenation(regExElementArray);
    }

    public RegExElement createConcatenation(RegExElement regExElement, RegExElement regExElement2) {
        RegExElement[] regExElementArray = new RegExElement[]{regExElement, regExElement2};
        return new RegExConcatenation(regExElementArray);
    }

    public RegExElement createConcatenation(RegExElement[] regExElementArray) {
        return new RegExConcatenation(regExElementArray);
    }

    public RegExElement createConcatenation(List<RegExElement> list) {
        return new RegExConcatenation(this.toArray(list));
    }

    public RegExElement createAlternation(RegExElement[] regExElementArray) {
        return new RegExAlternation(regExElementArray);
    }

    public RegExElement createAlternation(RegExElement regExElement, RegExElement regExElement2) {
        RegExElement[] regExElementArray = new RegExElement[]{regExElement, regExElement2};
        return new RegExAlternation(regExElementArray);
    }

    public RegExElement createAlternation(List<RegExElement> list) {
        return new RegExAlternation(this.toArray(list));
    }

    public RegExElement createIntersection(RegExElement[] regExElementArray) {
        return new RegExIntersection(regExElementArray);
    }

    public RegExElement createIntersection(RegExElement regExElement, RegExElement regExElement2) {
        RegExElement[] regExElementArray = new RegExElement[]{regExElement, regExElement2};
        return new RegExIntersection(regExElementArray);
    }

    public RegExElement createIntersection(List<RegExElement> list) {
        return new RegExIntersection(this.toArray(list));
    }

    public RegExElement createSubtraction(RegExElement[] regExElementArray) {
        return new RegExSubtraction(regExElementArray);
    }

    public RegExElement createSubtraction(RegExElement regExElement, RegExElement regExElement2) {
        RegExElement[] regExElementArray = new RegExElement[]{regExElement, regExElement2};
        return new RegExSubtraction(regExElementArray);
    }

    public RegExElement createSubtraction(List<RegExElement> list) {
        return new RegExSubtraction(this.toArray(list));
    }

    public RegExElement createLoop(RegExElement regExElement) {
        return new RegExLoop(regExElement);
    }

    public RegExElement createTest(RegExElement regExElement) {
        return this.createAlternation(regExElement, this.createEmpty());
    }

    public RegExElement createInstanceAndLoop(RegExElement regExElement) {
        return this.createConcatenation(this.createLoop(regExElement), regExElement);
    }

    public RegExElement createSubexpression(RegExElement regExElement) {
        return regExElement;
    }

    public RegExElement createRepetition(RegExElement regExElement, int n, int n2) {
        ArrayList<RegExElement> arrayList = new ArrayList<RegExElement>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(regExElement);
        }
        if (n2 == -1) {
            arrayList.add(this.createLoop(regExElement));
        } else if (n2 > n) {
            RegExElement regExElement2 = this.createTest(regExElement);
            n2 -= n;
            for (int i = 1; i < n2; ++i) {
                regExElement2 = this.createAlternation(this.createConcatenation(regExElement, regExElement2), this.createEmpty());
            }
            arrayList.add(regExElement2);
        }
        return this.createConcatenation(arrayList);
    }

    int buildRegEx(RegExElement regExElement, int n, Object object) throws DLTException {
        this.net.ensureModifyStarted();
        PayloadManipulator payloadManipulator = this.net.setPayloadManipulator(1, this.loopMaker.getPayloadManipulator());
        int n2 = this.net.modifyNode(-1, n, this.net.getPayloadManipulator(n).merge(-1, object));
        n2 = regExElement.build(n2);
        this.net.setPayloadManipulator(1, payloadManipulator);
        return n2;
    }

    public void addRegEx(RegExElement regExElement, NetGeneric.IndexIterator indexIterator, int n, Object object) throws DLTException {
        int n2 = this.buildRegEx(regExElement, n, object);
        if (n2 == -1) {
            return;
        }
        LoopReferenceCounter loopReferenceCounter = this.net.getReferences();
        loopReferenceCounter.addReference(-1, n2);
        this.merger.reset(n2);
        this.net.modifyEntry(indexIterator, this.merger);
        loopReferenceCounter.removeReference(-1, n2);
    }

    public void addRegExByBuildNode(RegExElement regExElement, NetGeneric.IndexIterator indexIterator, int n, Object object) throws DLTException {
        this.net.attachFSA(indexIterator, this.makeBuildNode(regExElement, n, object));
    }

    BuildNode toBuildNode(Object object) {
        if (object instanceof BuildNode) {
            return (BuildNode)object;
        }
        if (object instanceof Integer) {
            return BuildNodeBase.makeAssignedNode((Integer)object);
        }
        return NonDeterministicNodeAdapter.createAdapter((NonDeterministicBuildNode)object, this.net);
    }

    public BuildNode makeBuildNode(RegExElement regExElement, int n, Object object) throws DLTException {
        RegExNode regExNode = new RegExNode(n, this.net.getPayloadManipulator(n).merge(-1, object));
        return this.toBuildNode(regExElement.getNode(regExNode));
    }

    private class RegExLoop
    implements RegExElement {
        RegExElement loop;

        RegExLoop(RegExElement regExElement) {
            this.loop = regExElement;
        }

        @Override
        public int build(int n) throws DLTException {
            int n2 = RegExBuilder.this.net.modifyNode(-1, 1, RegExBuilder.this.loopMaker.allocateLoopNest(RegExBuilder.this.loopnest++));
            int n3 = this.loop.build(n2);
            --RegExBuilder.this.loopnest;
            LoopReferenceCounter loopReferenceCounter = RegExBuilder.this.net.getReferences();
            loopReferenceCounter.addReference(-1, n3);
            loopReferenceCounter.addReference(-1, n);
            int n4 = RegExBuilder.this.merger.mergeBranches(n, n3);
            loopReferenceCounter.addReference(-1, n4);
            loopReferenceCounter.removeReference(-1, n3);
            loopReferenceCounter.removeReferenceKeeping(-1, n, n4);
            int n5 = RegExBuilder.this.loopMaker.attachLoopEnds(n4, RegExBuilder.this.loopnest);
            loopReferenceCounter.addReference(-1, n5);
            loopReferenceCounter.removeReference(-1, n4);
            loopReferenceCounter.removeReferenceKeeping(-1, n5, n5);
            return n5;
        }

        public String toString() {
            return "(" + this.loop + ")*";
        }

        @Override
        public RegExNode getNode(Object object) throws DLTException {
            NonDeterministicBuildNode nonDeterministicBuildNode;
            NonDeterministicBuildNode[] nonDeterministicBuildNodeArray = new NonDeterministicBuildNode[2];
            nonDeterministicBuildNodeArray[0] = NonDeterministicNodeAdapter.nonDeterministicNode(RegExBuilder.this.net, object);
            RegExNode regExNode = new RegExNode(nonDeterministicBuildNodeArray);
            nonDeterministicBuildNodeArray[1] = nonDeterministicBuildNode = NonDeterministicNodeAdapter.nonDeterministicNode(RegExBuilder.this.net, this.loop.getNode(regExNode));
            regExNode.regex = this.toString();
            return regExNode;
        }
    }

    private class RegExSubtraction
    implements RegExElement {
        RegExElement[] args;

        RegExSubtraction(RegExElement[] regExElementArray) {
            assert (regExElementArray.length > 0);
            this.args = regExElementArray;
        }

        @Override
        public int build(int n) throws DLTException {
            LoopReferenceCounter loopReferenceCounter = RegExBuilder.this.net.getReferences();
            loopReferenceCounter.addReference(-1, n);
            int n2 = 0;
            int n3 = this.args[n2].build(n);
            if (n3 == -1) {
                loopReferenceCounter.removeReference(-1, n);
                return -1;
            }
            loopReferenceCounter.addReference(-1, n3);
            InPlaceSubtractor inPlaceSubtractor = new InPlaceSubtractor(RegExBuilder.this.merger.net, -1);
            ++n2;
            while (n2 < this.args.length) {
                int n4 = this.args[n2].build(n);
                if (n4 != -1) {
                    loopReferenceCounter.addReference(-1, n4);
                    int n5 = inPlaceSubtractor.subtractBranches(n3, n4);
                    if (n5 == -1) {
                        loopReferenceCounter.removeReference(-1, n3);
                        loopReferenceCounter.removeReference(-1, n4);
                        loopReferenceCounter.removeReference(-1, n);
                        return -1;
                    }
                    loopReferenceCounter.addReference(-1, n5);
                    loopReferenceCounter.removeReference(-1, n3);
                    loopReferenceCounter.removeReference(-1, n4);
                    n3 = n5;
                }
                ++n2;
            }
            loopReferenceCounter.removeReference(-1, n);
            loopReferenceCounter.removeReferenceKeeping(-1, n3, n3);
            return n3;
        }

        public String toString() {
            String string = "(" + this.args[0].toString();
            for (int i = 1; i < this.args.length; ++i) {
                string = string + " ~ " + this.args[i].toString();
            }
            return string + ")";
        }

        @Override
        public Object getNode(Object object) throws DLTException {
            BuildNode buildNode = RegExBuilder.this.toBuildNode(this.args[0].getNode(object));
            for (int i = 1; i < this.args.length; ++i) {
                BuildNode buildNode2 = RegExBuilder.this.toBuildNode(this.args[i].getNode(object));
                buildNode = BuildNodeSubtractor.makeNodeSubtractor(buildNode, buildNode2, (NetGeneric)RegExBuilder.this.net);
            }
            return buildNode;
        }
    }

    private class RegExIntersection
    implements RegExElement {
        RegExElement[] args;

        RegExIntersection(RegExElement[] regExElementArray) {
            assert (regExElementArray.length > 0);
            this.args = regExElementArray;
        }

        @Override
        public int build(int n) throws DLTException {
            LoopReferenceCounter loopReferenceCounter = RegExBuilder.this.net.getReferences();
            loopReferenceCounter.addReference(-1, n);
            int n2 = this.args.length - 1;
            int n3 = this.args[n2].build(n);
            if (n3 == -1) {
                loopReferenceCounter.removeReferenceKeeping(-1, n, n);
                return -1;
            }
            loopReferenceCounter.addReference(-1, n3);
            InPlaceIntersector inPlaceIntersector = new InPlaceIntersector(RegExBuilder.this.merger.net, -1);
            --n2;
            while (n2 >= 0) {
                int n4 = this.args[n2].build(n);
                if (n4 == -1) {
                    loopReferenceCounter.removeReference(-1, n3);
                    loopReferenceCounter.removeReference(-1, n);
                    return -1;
                }
                loopReferenceCounter.addReference(-1, n4);
                int n5 = inPlaceIntersector.intersectBranches(n3, n4);
                if (n5 == -1) {
                    loopReferenceCounter.removeReference(-1, n3);
                    loopReferenceCounter.removeReference(-1, n4);
                    loopReferenceCounter.removeReference(-1, n);
                    return -1;
                }
                loopReferenceCounter.addReference(-1, n5);
                loopReferenceCounter.removeReference(-1, n3);
                loopReferenceCounter.removeReference(-1, n4);
                n3 = n5;
                --n2;
            }
            loopReferenceCounter.removeReference(-1, n);
            loopReferenceCounter.removeReferenceKeeping(-1, n3, n3);
            return n3;
        }

        public String toString() {
            String string = "(" + this.args[0].toString();
            for (int i = 1; i < this.args.length; ++i) {
                string = string + " & " + this.args[i].toString();
            }
            return string + ")";
        }

        @Override
        public Object getNode(Object object) throws DLTException {
            BuildNode buildNode = RegExBuilder.this.toBuildNode(this.args[0].getNode(object));
            for (int i = 1; i < this.args.length; ++i) {
                BuildNode buildNode2 = RegExBuilder.this.toBuildNode(this.args[i].getNode(object));
                buildNode = BuildNodeIntersector.makeNodeIntersector(buildNode, buildNode2, (NetGeneric)RegExBuilder.this.net);
            }
            return buildNode;
        }
    }

    private class RegExAlternation
    implements RegExElement {
        RegExElement[] args;

        RegExAlternation(RegExElement[] regExElementArray) {
            assert (regExElementArray.length > 0);
            this.args = regExElementArray;
        }

        @Override
        public int build(int n) throws DLTException {
            LoopReferenceCounter loopReferenceCounter = RegExBuilder.this.net.getReferences();
            loopReferenceCounter.addReference(-1, n);
            int n2 = this.args.length - 1;
            int n3 = this.args[n2].build(n);
            while (n3 == -1) {
                if (n2 == 0) {
                    loopReferenceCounter.removeReference(-1, n);
                    return -1;
                }
                n3 = this.args[--n2].build(n);
            }
            loopReferenceCounter.addReference(-1, n3);
            --n2;
            while (n2 >= 0) {
                int n4 = this.args[n2].build(n);
                if (n4 != -1) {
                    loopReferenceCounter.addReference(-1, n4);
                    int n5 = RegExBuilder.this.merger.mergeBranches(n3, n4);
                    loopReferenceCounter.addReference(-1, n5);
                    loopReferenceCounter.removeReference(-1, n3);
                    loopReferenceCounter.removeReference(-1, n4);
                    n3 = n5;
                }
                --n2;
            }
            loopReferenceCounter.removeReference(-1, n);
            loopReferenceCounter.removeReferenceKeeping(-1, n3, n3);
            return n3;
        }

        public String toString() {
            String string = "(" + this.args[0].toString();
            for (int i = 1; i < this.args.length; ++i) {
                string = string + " | " + this.args[i].toString();
            }
            return string + ")";
        }

        @Override
        public RegExNode getNode(Object object) throws DLTException {
            NonDeterministicBuildNode[] nonDeterministicBuildNodeArray = new NonDeterministicBuildNode[this.args.length];
            int n = 0;
            for (RegExElement regExElement : this.args) {
                nonDeterministicBuildNodeArray[n++] = NonDeterministicNodeAdapter.nonDeterministicNode(RegExBuilder.this.net, regExElement.getNode(object));
            }
            RegExNode regExNode = new RegExNode(nonDeterministicBuildNodeArray);
            regExNode.regex = this.toString();
            return regExNode;
        }
    }

    private class RegExConcatenation
    implements RegExElement {
        RegExElement[] args;

        RegExConcatenation(RegExElement[] regExElementArray) {
            this.args = regExElementArray;
        }

        @Override
        public int build(int n) throws DLTException {
            for (int i = this.args.length - 1; i >= 0; --i) {
                if (n == -1) {
                    return -1;
                }
                n = this.args[i].build(n);
            }
            return n;
        }

        public String toString() {
            String string = "";
            if (this.args.length > 0) {
                string = string + this.args[0];
            }
            for (int i = 1; i < this.args.length; ++i) {
                string = string + " " + this.args[i];
            }
            return string;
        }

        @Override
        public Object getNode(Object object) throws DLTException {
            for (int i = this.args.length - 1; i >= 0; --i) {
                object = this.args[i].getNode(object);
            }
            return object;
        }
    }

    private class RegExIntValue
    implements RegExElement {
        final int idx;
        final int val;

        RegExIntValue(int n, int n2) {
            this.idx = n;
            this.val = n2;
        }

        @Override
        public int build(int n) throws DLTException {
            return RegExBuilder.this.net.modifyNode(n, this.idx, this.val);
        }

        public String toString() {
            return "" + this.idx + "->" + this.val;
        }

        @Override
        public RegExNode getNode(Object object) {
            return new RegExNode(this.idx, this.val);
        }
    }

    private class RegExTransition
    implements RegExElement {
        final int trans;

        RegExTransition(int n) {
            this.trans = n;
        }

        @Override
        public int build(int n) throws DLTException {
            return RegExBuilder.this.net.modifyNode(-1, this.trans, n);
        }

        public String toString() {
            return "" + this.trans;
        }

        @Override
        public RegExNode getNode(Object object) {
            return new RegExNode(this.trans, object);
        }
    }

    static class RegExNode
    implements NonDeterministicBuildNode {
        NonDeterministicBuildNode[] epsilons;
        Object[] transitions;
        int[] indices;
        int pos;
        String regex;

        RegExNode(int n, Object object) {
            this.epsilons = null;
            this.transitions = new Object[1];
            this.indices = new int[1];
            this.transitions[0] = object;
            this.indices[0] = n;
        }

        RegExNode(NonDeterministicBuildNode[] nonDeterministicBuildNodeArray) {
            this.epsilons = nonDeterministicBuildNodeArray;
            this.transitions = new Object[0];
            this.indices = new int[0];
        }

        RegExNode(int[] nArray, Object[] objectArray) {
            this.epsilons = null;
            this.transitions = objectArray;
            this.indices = nArray;
        }

        @Override
        public void endEnumeration() {
        }

        @Override
        public Object getChild() throws DLTException {
            return this.transitions[this.pos];
        }

        @Override
        public int getIndex() {
            return this.indices[this.pos];
        }

        @Override
        public NonDeterministicBuildNode nextEpsilonTransition() {
            if (this.pos == this.epsilons.length) {
                return null;
            }
            return this.epsilons[this.pos++];
        }

        @Override
        public boolean nextTransition() {
            return ++this.pos < this.transitions.length;
        }

        @Override
        public void startEnumeration() throws DLTException {
            this.pos = -1;
        }

        @Override
        public boolean startEpsilonEnumeration() throws DLTException {
            this.pos = 0;
            return this.epsilons != null;
        }

        public String toString() {
            if (this.regex != null) {
                return this.regex;
            }
            String string = "";
            if (this.epsilons != null) {
                string = string + ':' + Arrays.toString(this.epsilons);
            }
            for (int i = 0; i < this.transitions.length; ++i) {
                string = string + this.indices[i];
                string = string + ':';
                string = string + this.transitions[i];
            }
            return string;
        }

        @Override
        public void updateMaxIndex() throws DLTException {
        }
    }

    public static interface RegExElement {
        public int build(int var1) throws DLTException;

        public Object getNode(Object var1) throws DLTException;
    }
}

