/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.DecompositionTerm;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.NonDeterministicBuildNode;
import com.ibm.dltj.netgeneric.NonDeterministicNodeAdapter;
import com.ibm.dltj.netgeneric.RegExBuilder;
import java.util.List;

public class RuleConjunction
implements RegExBuilder.RegExElement {
    final RegExBuilder.RegExElement left;
    final RegExBuilder.RegExElement right;
    final NetGenericFullAccess net;
    final List<DecompositionTerm> terms;
    final RegExBuilder dbuilder;
    int initial_atom_count;
    NonDeterministicBuildNode trailNode;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public RuleConjunction(RegExBuilder regExBuilder, NetGeneric netGeneric, List<DecompositionTerm> list, RegExBuilder.RegExElement regExElement, RegExBuilder.RegExElement regExElement2) {
        this.left = regExElement;
        this.right = regExElement2;
        this.dbuilder = regExBuilder;
        this.terms = list;
        this.net = (NetGenericFullAccess)netGeneric;
    }

    @Override
    public int build(int n) throws DLTException {
        int n2 = this.net.modifyNode(-1, 3, 0);
        this.net.getReferences().addReference(-1, n2);
        int n3 = this.left.build(n2);
        this.net.getReferences().addReference(-1, n3);
        int n4 = this.right.build(n2);
        this.net.getReferences().addReference(-1, n4);
        this.initial_atom_count = this.terms.size();
        ConjunctionNode conjunctionNode = new ConjunctionNode(n3, n4);
        this.trailNode = NonDeterministicNodeAdapter.nonDeterministicNode(this.net, n);
        int n5 = this.dbuilder.merger.buildAndIntegrate(NonDeterministicNodeAdapter.createAdapter(conjunctionNode, this.net));
        this.net.getReferences().removeReferenceKeeping(-1, n3, n5);
        this.net.getReferences().removeReferenceKeeping(-1, n4, n5);
        this.net.getReferences().removeReferenceKeeping(-1, n2, n5);
        return n5;
    }

    @Override
    public Object getNode(Object object) throws DLTException {
        return null;
    }

    public String toString() {
        return String.format("(%s & %s)", this.left, this.right);
    }

    class ConjunctionNode
    implements NonDeterministicBuildNode {
        final int lnode;
        final int rnode;
        int lpos;
        int rpos;
        int cur_index;

        public ConjunctionNode(int n, int n2) {
            this.lnode = n;
            this.rnode = n2;
        }

        @Override
        public void updateMaxIndex() throws DLTException {
            this.lpos = -1;
            this.rpos = -1;
            while (this.nextTransition()) {
            }
            RuleConjunction.this.net.setMaxIndex(RuleConjunction.this.terms.size() + 4);
        }

        @Override
        public void startEnumeration() throws DLTException {
            this.lpos = -1;
            this.rpos = -1;
            this.cur_index = -1;
        }

        @Override
        public boolean startEpsilonEnumeration() throws DLTException {
            this.lpos = -2;
            return RuleConjunction.this.net.transitionPresent(this.lnode, 3) && RuleConjunction.this.net.transitionPresent(this.rnode, 3);
        }

        @Override
        public NonDeterministicBuildNode nextEpsilonTransition() {
            if (this.lpos++ == -2) {
                return RuleConjunction.this.trailNode;
            }
            return null;
        }

        @Override
        public boolean nextTransition() {
            if (this.lpos == -1) {
                while (++this.lpos < RuleConjunction.this.initial_atom_count && !RuleConjunction.this.net.transitionPresent(this.lnode, this.lpos + 4)) {
                }
                this.rpos = -1;
            }
            while (this.lpos < RuleConjunction.this.initial_atom_count) {
                while (++this.rpos < RuleConjunction.this.initial_atom_count) {
                    DecompositionTerm decompositionTerm;
                    if (!RuleConjunction.this.net.transitionPresent(this.rnode, this.rpos + 4) || (decompositionTerm = DecompositionTerm.createConjunction(RuleConjunction.this.terms.get(this.lpos), RuleConjunction.this.terms.get(this.rpos))) == null) continue;
                    int n = RuleConjunction.this.terms.indexOf(decompositionTerm);
                    if (n == -1) {
                        n = RuleConjunction.this.terms.size();
                        RuleConjunction.this.terms.add(decompositionTerm);
                    }
                    this.cur_index = n + 4;
                    return true;
                }
                while (++this.lpos < RuleConjunction.this.initial_atom_count && !RuleConjunction.this.net.transitionPresent(this.lnode, this.lpos + 4)) {
                }
                this.rpos = -1;
            }
            return false;
        }

        @Override
        public Object getChild() throws DLTException {
            return new ConjunctionNode(RuleConjunction.this.net.transitionValue(this.lnode, this.lpos + 4), RuleConjunction.this.net.transitionValue(this.rnode, this.rpos + 4));
        }

        @Override
        public int getIndex() {
            return this.cur_index;
        }

        @Override
        public void endEnumeration() {
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.lnode;
            n = 31 * n + this.rnode;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ConjunctionNode conjunctionNode = (ConjunctionNode)object;
            if (!this.getOuterType().equals(conjunctionNode.getOuterType())) {
                return false;
            }
            if (this.lnode != conjunctionNode.lnode) {
                return false;
            }
            return this.rnode == conjunctionNode.rnode;
        }

        private RuleConjunction getOuterType() {
            return RuleConjunction.this;
        }
    }
}

