/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.Merger;
import com.ibm.dltj.netgeneric.NetGeneric;
import java.util.ArrayList;
import java.util.List;

class StageRebuilder {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    final NetGeneric fsa;
    final int stage_size;
    final int first_link;
    final int max_index_mfli;
    final int stages;

    StageRebuilder(NetGeneric netGeneric, int n, int n2) {
        this.fsa = netGeneric;
        this.stages = n;
        this.stage_size = 1 << n2;
        this.first_link = this.fsa.getFirstLinkIndex();
        this.max_index_mfli = this.fsa.getMaxIndex() - this.first_link;
    }

    Merger.MergerNode getMergerNode(int n, int n2) {
        if (n2 % this.stages != 0) {
            return new NoChangeMergerNode(n, n2);
        }
        return new SBMergerHeadNode(n, n2);
    }

    class SBMergerHeadNode
    implements Merger.MergerNode {
        final int base;
        final int depth;
        List<Merger.MergerNode> children;

        public SBMergerHeadNode(int n, int n2) {
            this.base = n;
            this.depth = n2;
            assert (n2 % StageRebuilder.this.stages == 0);
            this.children = null;
        }

        @Override
        public boolean startCopy() throws DLTException {
            this.children = new ArrayList<Merger.MergerNode>();
            for (int i = 0; i < StageRebuilder.this.max_index_mfli; i += StageRebuilder.this.stage_size) {
                int n = Math.min(StageRebuilder.this.stage_size, StageRebuilder.this.max_index_mfli - i);
                int n2 = 0;
                for (int j = 0; j < n; ++j) {
                    if (!StageRebuilder.this.fsa.transitionPresent(this.base, i + j + StageRebuilder.this.first_link)) continue;
                    ++n2;
                }
                SBMergerChildNode sBMergerChildNode = null;
                if (n2 > 0) {
                    sBMergerChildNode = new SBMergerChildNode(this.base, this.depth, i, n);
                }
                this.children.add(sBMergerChildNode);
            }
            return true;
        }

        @Override
        public int[] gatherLinks() {
            int n = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.children.get(i) == null) continue;
                ++n;
            }
            int[] nArray = new int[n];
            n = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.children.get(i) == null) continue;
                nArray[n++] = StageRebuilder.this.first_link + i;
            }
            return nArray;
        }

        @Override
        public boolean transitionPresent(int n) {
            if (n < StageRebuilder.this.first_link) {
                return StageRebuilder.this.fsa.transitionPresent(this.base, n);
            }
            if (n >= this.children.size() + StageRebuilder.this.first_link) {
                return false;
            }
            return this.children.get(n - StageRebuilder.this.first_link) != null;
        }

        @Override
        public Object transitionValue(int n) throws DLTException {
            return StageRebuilder.this.fsa.getPayload(this.base, n, null);
        }

        @Override
        public Merger.MergerNode getTransition(int n) {
            return this.children.get(n - StageRebuilder.this.first_link);
        }

        @Override
        public void finalizeCopy() {
            this.children = null;
        }
    }

    private class SBMergerChildNode
    implements Merger.MergerNode {
        final int base;
        final int depth;
        final int offset;
        final int range;

        public SBMergerChildNode(int n, int n2, int n3, int n4) {
            this.depth = n2;
            this.base = n;
            this.offset = n3;
            this.range = n4;
        }

        @Override
        public boolean startCopy() throws DLTException {
            return true;
        }

        @Override
        public int[] gatherLinks() {
            int n = 0;
            for (int i = 0; i < this.range; ++i) {
                if (!StageRebuilder.this.fsa.transitionPresent(this.base, this.offset + i + StageRebuilder.this.first_link)) continue;
                ++n;
            }
            int[] nArray = new int[n];
            n = 0;
            for (int i = 0; i < this.range; ++i) {
                if (!StageRebuilder.this.fsa.transitionPresent(this.base, this.offset + i + StageRebuilder.this.first_link)) continue;
                nArray[n++] = i + StageRebuilder.this.first_link;
            }
            return nArray;
        }

        @Override
        public boolean transitionPresent(int n) {
            if (n < StageRebuilder.this.first_link || n >= this.range + StageRebuilder.this.first_link) {
                return false;
            }
            return StageRebuilder.this.fsa.transitionPresent(this.base, n + this.offset);
        }

        @Override
        public Object transitionValue(int n) throws DLTException {
            assert (false);
            return null;
        }

        @Override
        public Merger.MergerNode getTransition(int n) {
            return StageRebuilder.this.getMergerNode(StageRebuilder.this.fsa.transitionValue(this.base, n + this.offset), this.depth + 1);
        }

        @Override
        public void finalizeCopy() {
        }
    }

    private class NoChangeMergerNode
    implements Merger.MergerNode {
        final int base;
        final int depth;

        public NoChangeMergerNode(int n, int n2) {
            this.base = n;
            this.depth = n2;
        }

        @Override
        public boolean startCopy() throws DLTException {
            return true;
        }

        @Override
        public int[] gatherLinks() {
            return StageRebuilder.this.fsa.gatherNodeLinks(this.base);
        }

        @Override
        public boolean transitionPresent(int n) {
            return StageRebuilder.this.fsa.transitionPresent(this.base, n);
        }

        @Override
        public Object transitionValue(int n) throws DLTException {
            return StageRebuilder.this.fsa.getPayload(this.base, n, null);
        }

        @Override
        public Merger.MergerNode getTransition(int n) {
            return StageRebuilder.this.getMergerNode(StageRebuilder.this.fsa.transitionValue(this.base, n), this.depth + 1);
        }

        @Override
        public void finalizeCopy() {
        }
    }
}

