/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.netgeneric.TransitionTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class TransitionBuffer_ByteChars
extends TransitionTable {
    static final int SIGNATURE = 448061489;
    private ByteBuffer table;
    private static final int CHAR_SHIFT = 24;
    private static final int CHAR_MASK_SHIFTED = 255;
    private static final int CHAR_MASK = -16777216;
    private static final int LINK_MASK = 0xFFFFFF;
    private static final int INDEXMUL = 4;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    static boolean acceptable(int n, int n2) {
        return n <= 256 && n2 < 0x1000000;
    }

    public TransitionBuffer_ByteChars(int n) {
        this.table = ByteBuffer.allocate(n * 4);
        this.table.order(ByteOrder.BIG_ENDIAN);
    }

    public TransitionBuffer_ByteChars(TransitionTable transitionTable, int n) {
        this(n);
        if (transitionTable == null) {
            return;
        }
        int n2 = Math.min(n, transitionTable.getSize());
        for (int i = 0; i < n2; ++i) {
            this.setCell(i, transitionTable.getChar(i), transitionTable.getLink(i));
        }
    }

    @Override
    public final int getByteSize() {
        return this.table.capacity();
    }

    @Override
    public final int getSize() {
        return this.table.capacity() / 4;
    }

    @Override
    public final int getMaxChar() {
        return 255;
    }

    @Override
    public final int getLink(int n) {
        return this.table.getInt(n * 4) & 0xFFFFFF;
    }

    @Override
    public final int getChar(int n) {
        return this.table.get(n * 4);
    }

    @Override
    public final void setCell(int n, int n2, int n3) {
        this.table.putInt(n * 4, n2 << 24 & 0xFF000000 | n3 & 0xFFFFFF);
    }

    @Override
    public void unassign(int n) {
        this.table.putInt(n * 4, 0);
    }

    @Override
    public int getTypeSignature() {
        return 448061489;
    }

    @Override
    public void Load(DataInput dataInput) throws IOException {
        if (this.table.hasArray()) {
            dataInput.readFully(this.table.array());
        } else {
            for (int i = 0; i < this.getSize(); ++i) {
                this.table.putInt(i * 4, dataInput.readInt());
            }
        }
    }

    @Override
    public void Save(DataOutput dataOutput) throws IOException {
        if (this.table.hasArray()) {
            dataOutput.write(this.table.array());
        } else {
            for (int i = 0; i < this.getSize(); ++i) {
                dataOutput.writeInt(this.table.getInt(i * 4));
            }
        }
    }

    @Override
    public boolean accepts(int n, int n2) {
        return TransitionBuffer_ByteChars.acceptable(n, Math.max(this.getSize(), n2));
    }
}

