/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.netgeneric.TransitionTable_ByteChars;
import com.ibm.dltj.netgeneric.TransitionTable_Division;
import com.ibm.dltj.netgeneric.TransitionTable_Generic;
import com.ibm.dltj.netgeneric.TransitionTable_Integer;
import com.ibm.dltj.netgeneric.TransitionTable_nBitChars;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

abstract class TransitionTable {
    TransitionTable() {
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public abstract int getByteSize();

    public abstract int getSize();

    public abstract int getMaxChar();

    public abstract int getLink(int var1);

    public abstract int getChar(int var1);

    public static final TransitionTable CreateTable(int n, int n2, int n3) {
        n3 = Math.max(n2, n3);
        TransitionTable transitionTable = null;
        switch (n) {
            case 448061489: {
                transitionTable = new TransitionTable_ByteChars(n2);
                break;
            }
            case 448061730: {
                transitionTable = new TransitionTable_nBitChars(n2, n3);
                break;
            }
            case 448062020: {
                transitionTable = new TransitionTable_Division(n2, n3);
                break;
            }
            case 448061506: {
                transitionTable = new TransitionTable_Generic(n2);
                break;
            }
            case 448061508: {
                transitionTable = new TransitionTable_Integer(n2);
            }
        }
        return transitionTable;
    }

    public abstract int getTypeSignature();

    public abstract void Load(DataInput var1) throws IOException;

    public abstract void Save(DataOutput var1) throws IOException;

    public abstract void setCell(int var1, int var2, int var3);

    public boolean isAssigned(int n) {
        return this.getChar(n) != 0;
    }

    public abstract boolean accepts(int var1, int var2);

    public void unassign(int n) {
        this.setCell(n, 0, 0);
    }

    public static final TransitionTable createTableCopy(TransitionTable transitionTable, int n, int n2, int n3) {
        if (TransitionTable_ByteChars.acceptable(n, n3 = Math.max(n2, n3))) {
            return new TransitionTable_ByteChars(transitionTable, n2);
        }
        if (TransitionTable_nBitChars.acceptable(n, n3)) {
            return new TransitionTable_nBitChars(transitionTable, n2, n3);
        }
        if (TransitionTable_Division.acceptable(n, n3)) {
            return new TransitionTable_Division(transitionTable, n2, n3);
        }
        if (TransitionTable_Generic.acceptable(n, n3)) {
            return new TransitionTable_Generic(transitionTable, n2);
        }
        return new TransitionTable_Integer(transitionTable, n2);
    }
}

