/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.netgeneric.TransitionTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class TransitionTable_ByteChars
extends TransitionTable {
    static final int SIGNATURE = 448061489;
    private final int[] table;
    private static final int CHAR_SHIFT = 24;
    private static final int CHAR_MASK_SHIFTED = 255;
    private static final int CHAR_MASK = -16777216;
    private static final int LINK_MASK = 0xFFFFFF;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    static boolean acceptable(int n, int n2) {
        return n <= 256 && n2 < 0x1000000;
    }

    public TransitionTable_ByteChars(int n) {
        this.table = new int[n];
    }

    public TransitionTable_ByteChars(TransitionTable transitionTable, int n) {
        this(n);
        if (transitionTable == null) {
            return;
        }
        if (transitionTable instanceof TransitionTable_ByteChars) {
            TransitionTable_ByteChars transitionTable_ByteChars = (TransitionTable_ByteChars)transitionTable;
            int n2 = Math.min(transitionTable_ByteChars.table.length, this.table.length);
            System.arraycopy(transitionTable_ByteChars.table, 0, this.table, 0, n2);
        } else {
            int n3 = Math.min(n, transitionTable.getSize());
            for (int i = 0; i < n3; ++i) {
                this.setCell(i, transitionTable.getChar(i), transitionTable.getLink(i));
            }
        }
    }

    @Override
    public final int getByteSize() {
        return this.table.length * 4;
    }

    @Override
    public final int getSize() {
        return this.table.length;
    }

    @Override
    public final int getMaxChar() {
        return 255;
    }

    @Override
    public final int getLink(int n) {
        return this.table[n] & 0xFFFFFF;
    }

    @Override
    public final int getChar(int n) {
        return this.table[n] >>> 24;
    }

    @Override
    public final void setCell(int n, int n2, int n3) {
        this.table[n] = n2 << 24 & 0xFF000000 | n3 & 0xFFFFFF;
    }

    @Override
    public void unassign(int n) {
        this.table[n] = 0;
    }

    @Override
    public int getTypeSignature() {
        return 448061489;
    }

    @Override
    public void Load(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = dataInput.readInt();
        }
    }

    @Override
    public void Save(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.table.length; ++i) {
            dataOutput.writeInt(this.table[i]);
        }
    }

    @Override
    public boolean accepts(int n, int n2) {
        return TransitionTable_ByteChars.acceptable(n, Math.max(this.getSize(), n2));
    }
}

