/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.netgeneric.TransitionTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class TransitionTable_Division
extends TransitionTable {
    static final int SIGNATURE = 448062020;
    private int[] table;
    private final int MULTIPLIER;
    private final int MAX_CHAR;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    static final int safemod(int n, int n2) {
        return (int)(((long)n & 0xFFFFFFFFL) % (long)n2);
    }

    static final int safediv(int n, int n2) {
        return (int)(((long)n & 0xFFFFFFFFL) / (long)n2);
    }

    static boolean acceptable(int n, int n2) {
        return (long)n * (long)(n2 + 1) <= 0x100000000L;
    }

    public TransitionTable_Division(int n, int n2) {
        this.table = new int[n];
        this.MULTIPLIER = n2 + 1;
        this.MAX_CHAR = n != 0 ? (int)(0x100000000L / (long)this.MULTIPLIER) - 1 : -1;
    }

    public TransitionTable_Division(TransitionTable transitionTable, int n, int n2) {
        this(n, n2);
        if (transitionTable == null) {
            return;
        }
        int n3 = Math.min(n, transitionTable.getSize());
        for (int i = 0; i < n3; ++i) {
            this.setCell(i, transitionTable.getChar(i), transitionTable.getLink(i));
        }
    }

    @Override
    public final int getByteSize() {
        return this.table.length * 4;
    }

    @Override
    public final int getSize() {
        return this.table.length;
    }

    @Override
    public final int getMaxChar() {
        return this.MAX_CHAR;
    }

    @Override
    public final int getLink(int n) {
        return TransitionTable_Division.safemod(this.table[n], this.MULTIPLIER);
    }

    @Override
    public final int getChar(int n) {
        return TransitionTable_Division.safediv(this.table[n], this.MULTIPLIER);
    }

    @Override
    public final void setCell(int n, int n2, int n3) {
        assert (n2 >= 0);
        assert (n2 <= this.MAX_CHAR);
        assert (n3 >= 0);
        assert (n3 < this.MULTIPLIER);
        this.table[n] = n2 * this.MULTIPLIER + n3;
    }

    @Override
    public void unassign(int n) {
        this.table[n] = 0;
    }

    @Override
    public int getTypeSignature() {
        return 448062020;
    }

    @Override
    public void Load(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = dataInput.readInt();
        }
    }

    @Override
    public void Save(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.table.length; ++i) {
            dataOutput.writeInt(this.table[i]);
        }
    }

    @Override
    public boolean accepts(int n, int n2) {
        if (n2 >= this.MULTIPLIER) {
            return false;
        }
        if (n >= this.MAX_CHAR) {
            return false;
        }
        return TransitionTable_Division.acceptable(n, Math.max(this.getSize(), n2));
    }
}

