/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.netgeneric.TransitionTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class TransitionTable_Generic
extends TransitionTable {
    static final int SIGNATURE = 448061506;
    private char[] table;
    private static final int NODE_SIZE = 3;
    private final int size;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    static boolean acceptable(int n, int n2) {
        return n >= 0 && n <= 65536 && n2 >= 0;
    }

    public TransitionTable_Generic(int n) {
        this.table = new char[n * 3];
        this.size = n;
    }

    public TransitionTable_Generic(TransitionTable transitionTable, int n) {
        this(n);
        if (transitionTable == null) {
            return;
        }
        if (transitionTable instanceof TransitionTable_Generic) {
            TransitionTable_Generic transitionTable_Generic = (TransitionTable_Generic)transitionTable;
            int n2 = Math.min(transitionTable_Generic.table.length, this.table.length);
            System.arraycopy(transitionTable_Generic.table, 0, this.table, 0, n2);
        } else {
            int n3 = Math.min(n, transitionTable.getSize());
            for (int i = 0; i < n3; ++i) {
                this.setCell(i, transitionTable.getChar(i), transitionTable.getLink(i));
            }
        }
    }

    @Override
    public final int getByteSize() {
        return this.size * 3 * 2;
    }

    @Override
    public final int getSize() {
        return this.size;
    }

    @Override
    public final int getMaxChar() {
        return 65535;
    }

    @Override
    public final int getLink(int n) {
        return this.table[n * 3] | this.table[n * 3 + 1] << 16;
    }

    @Override
    public final int getChar(int n) {
        return this.table[n * 3 + 2];
    }

    public final void setLink(int n, int n2) {
        this.table[n * 3] = (char)n2;
        this.table[n * 3 + 1] = (char)(n2 >> 16);
    }

    public final void clearLink(int n) {
        this.setLink(n, 0);
    }

    public final int getDeadLink() {
        return 0;
    }

    public final void setChar(int n, int n2) {
        this.table[n * 3 + 2] = (char)n2;
    }

    @Override
    public int getTypeSignature() {
        return 448061506;
    }

    @Override
    public void Load(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = dataInput.readChar();
        }
    }

    @Override
    public void Save(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.table.length; ++i) {
            dataOutput.writeChar(this.table[i]);
        }
    }

    @Override
    public void setCell(int n, int n2, int n3) {
        this.setChar(n, n2);
        this.setLink(n, n3);
    }

    @Override
    public boolean accepts(int n, int n2) {
        return TransitionTable_Generic.acceptable(n, Math.max(this.getSize(), n2));
    }
}

