/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.netgeneric.TransitionTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class TransitionTable_Integer
extends TransitionTable {
    static final int SIGNATURE = 448061508;
    private int[] table;
    private static final int NODE_SIZE = 2;
    private final int size;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    static boolean acceptable(int n, int n2) {
        return n >= 0 && n2 >= 0;
    }

    public TransitionTable_Integer(int n) {
        this.table = new int[n * 2];
        this.size = n;
    }

    public TransitionTable_Integer(TransitionTable transitionTable, int n) {
        this(n);
        if (transitionTable == null) {
            return;
        }
        if (transitionTable instanceof TransitionTable_Integer) {
            TransitionTable_Integer transitionTable_Integer = (TransitionTable_Integer)transitionTable;
            int n2 = Math.min(transitionTable_Integer.table.length, this.table.length);
            System.arraycopy(transitionTable_Integer.table, 0, this.table, 0, n2);
        } else {
            int n3 = Math.min(n, transitionTable.getSize());
            for (int i = 0; i < n3; ++i) {
                this.setCell(i, transitionTable.getChar(i), transitionTable.getLink(i));
            }
        }
    }

    @Override
    public final int getByteSize() {
        return this.size * 2 * 4;
    }

    @Override
    public final int getSize() {
        return this.size;
    }

    @Override
    public final int getMaxChar() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final int getLink(int n) {
        return this.table[n * 2];
    }

    @Override
    public final int getChar(int n) {
        return this.table[n * 2 + 1];
    }

    @Override
    public int getTypeSignature() {
        return 448061508;
    }

    @Override
    public void Load(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = dataInput.readInt();
        }
    }

    @Override
    public void Save(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.table.length; ++i) {
            dataOutput.writeInt(this.table[i]);
        }
    }

    @Override
    public void setCell(int n, int n2, int n3) {
        this.table[n * 2 + 1] = n2;
        this.table[n * 2] = n3;
    }

    @Override
    public boolean accepts(int n, int n2) {
        return TransitionTable_Integer.acceptable(n, Math.max(this.getSize(), n2));
    }
}

