/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.netgeneric.TransitionTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class TransitionTable_nBitChars
extends TransitionTable {
    static final int SIGNATURE = 448061730;
    private int[] table;
    private final int CHAR_SHIFT;
    private final int CHAR_MASK_SHIFTED;
    private final int CHAR_MASK;
    private final int LINK_MASK;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    static boolean acceptable(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (1L << n3 < (long)n) {
            ++n3;
        }
        while (1L << n4 <= (long)n2) {
            ++n4;
        }
        return n4 + n3 <= 32;
    }

    public TransitionTable_nBitChars(int n, int n2) {
        this.table = new int[n];
        int n3 = 0;
        while (1L << n3 < (long)n2) {
            ++n3;
        }
        this.CHAR_SHIFT = n3;
        this.CHAR_MASK_SHIFTED = (1 << 32 - this.CHAR_SHIFT) - 1;
        this.CHAR_MASK = this.CHAR_MASK_SHIFTED << this.CHAR_SHIFT;
        this.LINK_MASK = (1 << this.CHAR_SHIFT) - 1;
    }

    public TransitionTable_nBitChars(TransitionTable transitionTable, int n, int n2) {
        this(n, n2);
        if (transitionTable == null) {
            return;
        }
        int n3 = Math.min(n, transitionTable.getSize());
        for (int i = 0; i < n3; ++i) {
            this.setCell(i, transitionTable.getChar(i), transitionTable.getLink(i));
        }
    }

    @Override
    public final int getByteSize() {
        return this.table.length * 4;
    }

    @Override
    public final int getSize() {
        return this.table.length;
    }

    @Override
    public final int getMaxChar() {
        return this.CHAR_MASK_SHIFTED;
    }

    @Override
    public final int getLink(int n) {
        return this.table[n] & this.LINK_MASK;
    }

    @Override
    public final int getChar(int n) {
        return this.table[n] >>> this.CHAR_SHIFT;
    }

    @Override
    public final void setCell(int n, int n2, int n3) {
        this.table[n] = n2 << this.CHAR_SHIFT & this.CHAR_MASK | n3 & this.LINK_MASK;
    }

    @Override
    public void unassign(int n) {
        this.table[n] = 0;
    }

    @Override
    public int getTypeSignature() {
        return 448061730;
    }

    @Override
    public void Load(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = dataInput.readInt();
        }
    }

    @Override
    public void Save(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.table.length; ++i) {
            dataOutput.writeInt(this.table[i]);
        }
    }

    @Override
    public boolean accepts(int n, int n2) {
        if (n2 > this.LINK_MASK) {
            return false;
        }
        if (n > this.CHAR_MASK_SHIFTED) {
            return false;
        }
        return TransitionTable_nBitChars.acceptable(n, Math.max(this.getSize(), n2));
    }
}

