/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.netgeneric;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFullAccess;
import com.ibm.dltj.netgeneric.RegExBuilder;
import com.ibm.icu.text.UnicodeSet;
import java.util.Arrays;
import java.util.BitSet;

public class UnicodeSetTransition
implements RegExBuilder.RegExElement {
    public final UnicodeSet set;
    int[] mapping;
    final NetGenericFullAccess net;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public UnicodeSetTransition(NetGeneric netGeneric, UnicodeSet unicodeSet) {
        this.net = (NetGenericFullAccess)netGeneric;
        unicodeSet.compact();
        unicodeSet.freeze();
        assert (!unicodeSet.isEmpty());
        this.set = unicodeSet;
    }

    @Override
    public int build(int n) throws DLTException {
        return this.net.addNode(this.mapping, n, this.mapping.length);
    }

    public void assignMappings(SetToCode setToCode) {
        BitSet bitSet = setToCode.getCodes(this.set);
        int[] nArray = new int[bitSet.cardinality()];
        int n = 0;
        int n2 = bitSet.nextSetBit(0);
        while (n2 != -1) {
            nArray[n++] = n2;
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        this.mapping = nArray;
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public boolean equals(Object object) {
        UnicodeSetTransition unicodeSetTransition = (UnicodeSetTransition)object;
        return this.set.equals((Object)unicodeSetTransition.set);
    }

    @Override
    public RegExBuilder.RegExNode getNode(Object object) throws DLTException {
        Object[] objectArray = new Object[this.mapping.length];
        Arrays.fill(objectArray, object);
        return new RegExBuilder.RegExNode(this.mapping, objectArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mapping == null) {
            return "null";
        }
        if (this.mapping.length > 1) {
            stringBuilder.append('(');
        }
        stringBuilder.append(this.mapping[0]);
        for (int i = 1; i < this.mapping.length; ++i) {
            stringBuilder.append('|');
            stringBuilder.append(this.mapping[i]);
        }
        if (this.mapping.length > 1) {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static interface SetToCode {
        public BitSet getCodes(UnicodeSet var1);
    }
}

