/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.CharacterBuffer;
import com.ibm.dltj.CharacterBufferPool;
import com.ibm.dltj.DLT;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.nondeterm.AggregateMatcher;
import com.ibm.dltj.nondeterm.AppmWalkerOptions;
import com.ibm.dltj.nondeterm.ApproximateMatcher;
import com.ibm.dltj.nondeterm.FuzzyMatcher;
import com.ibm.dltj.nondeterm.NondeterministicWalker;
import com.ibm.dltj.nondeterm.Pool;
import com.ibm.dltj.nondeterm.QGramMatcher;
import com.ibm.dltj.nondeterm.QueryExpander;
import com.ibm.dltj.nondeterm.RuleBasedNormalizer;
import com.ibm.dltj.nondeterm.SpellAider;
import java.io.File;

public class AdvancedLookupDriver {
    @Deprecated
    public static final int fuzzyMatch = 1;
    @Deprecated
    public static final int approximateMatchSpellAid = 2;
    @Deprecated
    public static final int approximateMatchQuery = 3;
    @Deprecated
    public static final int MATCTH_FUZZY = 1;
    public static final int MATCH_FUZZY = 1;
    public static final int MATCH_SPELLAID = 2;
    public static final int MATCH_QUERY = 3;
    public static final int MATCH_NORMALIZATION = 4;
    public static final int MATCH_AGGREGATE = 5;
    public static final int MATCH_QGRAM = 6;
    public Dictionary[] masters = null;
    public Dictionary rules = null;
    public boolean obeyRules = true;
    public boolean extraRanking = true;
    public boolean whiteSpaceTokenization = false;
    public boolean allowExactMatch = false;
    public boolean doWhiteSpaces = true;
    public boolean strictMWU = false;
    public boolean firstWordOfSentence = false;
    public boolean doKatakanaMiddleDot;
    @Deprecated
    public boolean supportCrazyCase = false;
    private OperationsConfigurator operationsConfig = new OperationsConfigurator();
    private CharacterBufferPool cPool = null;
    private Pool optionsPool;
    private Pool matchBufferPool;
    private static final int NORMAL_CASE = 0;
    private static final int TO_LOWER = 1;
    private static final int TO_UPPER = 2;
    private static final int TO_TITLE = 3;
    public static final String INFO_REQUEST_STRING = "spellinfo";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private void init() {
        this.cPool = new CharacterBufferPool();
        this.cPool.init(CharacterBuffer.class, 32);
        this.optionsPool = new Pool();
        this.optionsPool.init(AppmWalkerOptions.class, 32);
        this.matchBufferPool = new Pool();
        this.matchBufferPool.init(ApproximateMatcher.PoolableMatchBuffer.class, 32);
    }

    public AdvancedLookupDriver(Dictionary[] dictionaryArray) {
        this.masters = dictionaryArray;
        this.init();
    }

    public void setRules(Dictionary dictionary) {
        this.rules = dictionary;
    }

    public void setRules(String string) throws Exception {
        File[] fileArray = DLT.getCapMatrix().getAvailableFiles(string, 15);
        this.rules = new Dictionary(fileArray[0]);
    }

    public OperationsConfigurator getOperationsConfigurator() {
        return this.operationsConfig;
    }

    @Deprecated
    private int verifyCrazyCase(String string) {
        if (string == null) {
            return 0;
        }
        int n = string.length();
        if (n < 2) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl = Character.isUpperCase(string.charAt(0));
        for (int i = 0; i < n; ++i) {
            if (Character.isUpperCase(string.charAt(i))) {
                ++n2;
                continue;
            }
            ++n3;
        }
        if (n2 == 0 || n3 == 0) {
            return 0;
        }
        if (bl && n2 == 1) {
            return 0;
        }
        if (n2 > n3) {
            return 2;
        }
        if (bl) {
            return 3;
        }
        return 1;
    }

    public synchronized String[] match(String string, int n, int n2) throws DLTException {
        switch (n) {
            case 3: {
                QueryExpander queryExpander = new QueryExpander(this.cPool, this.optionsPool, this.matchBufferPool);
                queryExpander.extraRanking = this.extraRanking;
                queryExpander.whiteSpaceTokenization = this.whiteSpaceTokenization;
                queryExpander.allowExactMatch = this.allowExactMatch;
                queryExpander.doWhiteSpaces = this.doWhiteSpaces;
                queryExpander.doExtraSuffix = true;
                queryExpander.strictMWU = this.strictMWU;
                queryExpander.skipFirstNPositions = this.operationsConfig.skipFirstNPositions;
                queryExpander.firstWordOfSentence = this.firstWordOfSentence;
                return queryExpander.gather(string, this.masters, this.rules, n2, this.obeyRules);
            }
            case 2: {
                SpellAider spellAider = new SpellAider(this.cPool, this.optionsPool, this.matchBufferPool);
                spellAider.extraRanking = this.extraRanking;
                spellAider.whiteSpaceTokenization = this.whiteSpaceTokenization;
                spellAider.allowExactMatch = this.allowExactMatch;
                spellAider.doWhiteSpaces = this.doWhiteSpaces;
                spellAider.doExtraSuffix = true;
                spellAider.strictMWU = this.strictMWU;
                spellAider.skipFirstNPositions = this.operationsConfig.skipFirstNPositions;
                spellAider.firstWordOfSentence = this.firstWordOfSentence;
                if (this.supportCrazyCase) {
                    switch (this.verifyCrazyCase(string)) {
                        case 3: {
                            string = string.substring(0, 1) + string.substring(1).toLowerCase();
                            spellAider.allowExactMatch = true;
                            break;
                        }
                        case 2: {
                            string = string.toUpperCase();
                            spellAider.allowExactMatch = true;
                            break;
                        }
                        case 1: {
                            string = string.toLowerCase();
                            spellAider.allowExactMatch = true;
                        }
                    }
                }
                return spellAider.gather(string, this.masters, this.rules, n2, this.obeyRules);
            }
            case 1: {
                FuzzyMatcher fuzzyMatcher = new FuzzyMatcher(this.cPool, this.optionsPool);
                fuzzyMatcher.extraRanking = this.extraRanking;
                fuzzyMatcher.whiteSpaceTokenization = this.whiteSpaceTokenization;
                fuzzyMatcher.allowExactMatch = true;
                return fuzzyMatcher.gather(string, this.masters, null, n2, false);
            }
            case 5: {
                AggregateMatcher aggregateMatcher = new AggregateMatcher(this.cPool, this.optionsPool, this.matchBufferPool);
                aggregateMatcher.extraRanking = false;
                aggregateMatcher.whiteSpaceTokenization = this.whiteSpaceTokenization;
                aggregateMatcher.allowExactMatch = this.allowExactMatch;
                aggregateMatcher.doWhiteSpaces = this.doWhiteSpaces;
                aggregateMatcher.doExtraSuffix = true;
                aggregateMatcher.skipFirstNPositions = this.operationsConfig.skipFirstNPositions;
                aggregateMatcher.firstWordOfSentence = this.firstWordOfSentence;
                return aggregateMatcher.gather(string, this.masters, null, n2, false);
            }
            case 4: {
                RuleBasedNormalizer ruleBasedNormalizer = new RuleBasedNormalizer(this.cPool, this.optionsPool, this.matchBufferPool);
                ruleBasedNormalizer.extraRanking = false;
                ruleBasedNormalizer.whiteSpaceTokenization = this.whiteSpaceTokenization;
                ruleBasedNormalizer.allowExactMatch = this.allowExactMatch;
                ruleBasedNormalizer.doWhiteSpaces = this.doWhiteSpaces;
                ruleBasedNormalizer.doExtraSuffix = false;
                ruleBasedNormalizer.doKatakanaMiddleDot = this.doKatakanaMiddleDot;
                ruleBasedNormalizer.firstWordOfSentence = this.firstWordOfSentence;
                return ruleBasedNormalizer.gather(string, this.masters, this.rules, n2, true);
            }
            case 6: {
                QGramMatcher qGramMatcher = new QGramMatcher(this.cPool);
                qGramMatcher.extraRanking = this.extraRanking;
                qGramMatcher.whiteSpaceTokenization = this.whiteSpaceTokenization;
                qGramMatcher.allowExactMatch = true;
                return qGramMatcher.gather(string, this.masters, null, n2, false);
            }
        }
        return null;
    }

    public void dispose() {
        this.masters = null;
        this.rules = null;
        this.cPool = null;
    }

    public static int getCostScale() {
        return NondeterministicWalker.getScaleFactor();
    }

    public class OperationsConfigurator {
        static final int MASK_INSERTION = 15;
        static final int MASK_SUBSTITUTION = 240;
        static final int MASK_TRANSPOSITION = 3840;
        static final int MASK_REMOVAL = 61440;
        static final int MASK_RULES = 983040;
        static final int OP_INSERTION = 0;
        static final int OP_SUBSTITUTION = 4;
        static final int OP_TRANSPOSITION = 8;
        static final int OP_REMOVAL = 12;
        static final int OP_RULES = 16;
        private int skipFirstNPositions = 0;

        public void skipAll(int n) {
            this.skipInsertion(n);
            this.skipSubstitution(n);
            this.skipTrasposition(n);
            this.skipRemoval(n);
            this.skipRules(n);
        }

        public void skipInsertion(int n) {
            this.skipFirstNPositions |= (n < 0 || n > 9 ? 0 : n) << 0;
        }

        public void skipSubstitution(int n) {
            this.skipFirstNPositions |= (n < 0 || n > 9 ? 0 : n) << 4;
        }

        public void skipTrasposition(int n) {
            this.skipFirstNPositions |= (n < 0 || n > 9 ? 0 : n) << 8;
        }

        public void skipRemoval(int n) {
            this.skipFirstNPositions |= (n < 0 || n > 9 ? 0 : n) << 12;
        }

        public void skipRules(int n) {
            this.skipFirstNPositions |= (n < 0 || n > 9 ? 0 : n) << 16;
        }
    }
}

