/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.Dictionary;
import com.ibm.dltj.nondeterm.AdvancedLookupDriver;
import com.ibm.dltj.nondeterm.Pool;
import com.ibm.dltj.nondeterm.Poolable;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

class AdvancedLookupTCPDispatcher
extends Thread {
    private ServerSocket localServerSocket = null;
    int iPort = -1;
    public int soTimeout = 0;
    private Pool pool = null;
    private AdvancedLookupDriver driver = null;
    public int lookupMode = 3;
    private boolean shuttingDown = false;
    private boolean down = true;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public AdvancedLookupTCPDispatcher(Dictionary[] dictionaryArray, Dictionary dictionary, int n, int n2) {
        this.init(dictionaryArray, dictionary, n, n2);
    }

    public AdvancedLookupDriver getDriver() {
        return this.driver;
    }

    private void init(Dictionary[] dictionaryArray, Dictionary dictionary, int n, int n2) {
        this.driver = new AdvancedLookupDriver(dictionaryArray);
        if (dictionary != null) {
            this.driver.setRules(dictionary);
        }
        this.iPort = n;
        this.pool = new Pool();
        this.pool.init(Worker.class, n2);
    }

    @Override
    public void run() {
        this.down = false;
        this.shuttingDown = false;
        try {
            this.localServerSocket = new ServerSocket(this.iPort, 50, InetAddress.getByName("127.0.0.1"));
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        while (!this.shuttingDown) {
            try {
                Socket socket = this.localServerSocket.accept();
                socket.setSoTimeout(this.soTimeout);
                this.handleConnection(socket);
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
        if (this.localServerSocket != null) {
            this.shutdown();
        }
        this.down = true;
        this.shuttingDown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnection(Socket socket) {
        Worker worker = (Worker)this.pool.evoke();
        worker.init(socket, this.driver, this.lookupMode);
        if (worker.isAlive()) {
            Worker worker2 = worker;
            synchronized (worker2) {
                worker.notify();
            }
        } else {
            worker.start();
        }
    }

    public synchronized void shutdown() {
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        if (this.localServerSocket != null) {
            try {
                this.localServerSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Thread.yield();
        }
    }

    static class Worker
    extends Thread
    implements Poolable {
        AdvancedLookupDriver driver = null;
        Socket socket = null;
        int nonFuzzyMode = 1;
        public int id = -1;
        public Pool pool = null;
        protected InputStream inS = null;
        protected OutputStream outS = null;

        Worker() {
        }

        public void init(Socket socket, AdvancedLookupDriver advancedLookupDriver, int n) {
            this.driver = advancedLookupDriver;
            this.socket = socket;
            this.nonFuzzyMode = n;
        }

        @Override
        public void reg4pool(int n, Pool pool) {
            this.id = n;
            this.pool = pool;
        }

        @Override
        public synchronized void run() {
            while (true) {
                this.process();
                this.pool.reclaim(this.id);
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process() {
            try {
                try {
                    DataInputStream dataInputStream = new DataInputStream(this.socket.getInputStream());
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
                    DataOutputStream dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
                    String string = null;
                    int n = -1;
                    int n2 = 0;
                    block14: while (true) {
                        if ((string = bufferedReader.readLine()).indexOf("*") >= 0 || string.indexOf("?") >= 0) {
                            n = 1;
                            n2 = 50;
                        } else {
                            n = this.nonFuzzyMode;
                            n2 = 10;
                        }
                        String[] stringArray = this.driver.match(string, n, n2);
                        if (stringArray != null) {
                            dataOutputStream.writeByte(stringArray.length);
                            int n3 = 0;
                            while (true) {
                                if (n3 >= stringArray.length) continue block14;
                                dataOutputStream.writeBytes(stringArray[n3] + "\n");
                                ++n3;
                            }
                        }
                        dataOutputStream.writeByte(0);
                    }
                }
                catch (Exception exception) {
                    try {
                        this.inS.close();
                        this.outS.close();
                    }
                    catch (Exception exception2) {
                    }
                    finally {
                        this.inS = null;
                        this.outS = null;
                        this.socket = null;
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    this.inS.close();
                    this.outS.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.inS = null;
                    this.outS = null;
                    this.socket = null;
                }
                throw throwable;
            }
        }
    }
}

