/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.CharacterBuffer;
import com.ibm.dltj.CharacterBufferPool;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.ISuggestionValidator;
import com.ibm.dltj.SuggestionValidator;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.gloss.CaseGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.TCRGloss;
import com.ibm.dltj.nondeterm.AppmWalkerOptions;
import com.ibm.dltj.nondeterm.BiCompoundAnalyzer;
import com.ibm.dltj.nondeterm.DeReformedPosAnalyzer;
import com.ibm.dltj.nondeterm.DefaultPosAnalyzer;
import com.ibm.dltj.nondeterm.EsPosAnalyzer;
import com.ibm.dltj.nondeterm.HyphenApostrofePosAnalyzer;
import com.ibm.dltj.nondeterm.NondeterministicWalker;
import com.ibm.dltj.nondeterm.Pool;
import com.ibm.dltj.nondeterm.Poolable;
import com.ibm.dltj.nondeterm.PosAnalyzer;
import com.ibm.dltj.nondeterm.SimplePosAnalyser;
import com.ibm.dltj.nondeterm.SuggestionSet;
import com.ibm.dltj.nondeterm.WalkerOptions;
import com.ibm.dltj.util.CharacterMapper;
import java.text.StringCharacterIterator;

abstract class ApproximateMatcher
extends NondeterministicWalker {
    public static final int DLTAID_REM_COSTINC = 40;
    public static final int DLTAID_SUB_COSTINC = 65;
    public static final int DLTAID_TRN_COSTINC = 35;
    public static final int DLTAID_INS_COSTINC = 35;
    public static final int DLTAID_WHT_COSTINC = 185;
    public static final int DLTAID_DEFAULT_COSTINC = 35;
    public static final int DLTAID_DEFAULT_EXTRACOST_1 = 10;
    public static final int DLTAID_DEFAULT_EXTRACOST_2 = 10;
    public static final int DLTAID_DEFAULT_DELTA = 45;
    public static final int DLTAID_CASE_COSTINC = 10;
    public static final int DICTAID_EDIT_LIMIT = 256;
    int remInc;
    int subInc;
    int trnInc;
    int insInc;
    int whtInc;
    int ext1Inc;
    int ext2Inc;
    int rulInc = 0;
    int bofaInc;
    int caseInc;
    int actualTolerance;
    public Dictionary iDict;
    Dictionary rDict = null;
    protected int deltaCost = 0;
    final StringCharacterIterator itr = new StringCharacterIterator("");
    public SuggestionSet sgSet = null;
    public boolean doWhiteSpaces = true;
    public boolean doExtraSuffix = true;
    public boolean doKatakanaMiddleDot = false;
    private static final char KATAKANA_MIDDLE_DOT = '\u30fb';
    private static final char INSERTABLE_APOSTROPHE = '\'';
    public boolean strictMWU = false;
    public int skipFirstNPositions = 0;
    public boolean firstWordOfSentence = false;
    protected Pool matchBufferPool = null;
    protected static final PosAnalyzer DE_REFORMED_POS_ANALYZER = new DeReformedPosAnalyzer();
    protected static final PosAnalyzer ES_POS_ANALYZER = new EsPosAnalyzer();
    protected static final PosAnalyzer SIMPLE_POS_ANALYZER = new SimplePosAnalyser();
    protected static final PosAnalyzer HYPHEN_APOSTROPHE_POS_ANALYZER = new HyphenApostrofePosAnalyzer();
    protected static final PosAnalyzer POS_ANALYZER = new DefaultPosAnalyzer();
    protected static final PosAnalyzer LOOSE_POS_ANALYZER = new BiCompoundAnalyzer();
    protected ISuggestionValidator spellerValidator = null;
    protected int caseHandlingMethod;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public abstract void assignIncrements();

    public abstract void assignOperations(AppmWalkerOptions var1) throws DLTException;

    public abstract int getTolerance(int var1);

    @Deprecated
    public ApproximateMatcher(CharacterBufferPool characterBufferPool) {
        super(characterBufferPool);
        this.optionsPool = new Pool();
        this.optionsPool.init(AppmWalkerOptions.class, 32);
        this.matchBufferPool = new Pool();
        this.matchBufferPool.init(PoolableMatchBuffer.class, 32);
    }

    public ApproximateMatcher(CharacterBufferPool characterBufferPool, Pool pool, Pool pool2) {
        super(characterBufferPool, pool);
        this.matchBufferPool = pool2;
    }

    @Override
    void preSwichHandler(WalkerOptions walkerOptions, WalkerOptions walkerOptions2) {
        AppmWalkerOptions appmWalkerOptions = (AppmWalkerOptions)walkerOptions;
        AppmWalkerOptions appmWalkerOptions2 = (AppmWalkerOptions)walkerOptions2;
        appmWalkerOptions.end = appmWalkerOptions2.end;
        appmWalkerOptions.bofaLevel = appmWalkerOptions2.bofaLevel;
        appmWalkerOptions.bofaPos = appmWalkerOptions2.bofaPos;
        appmWalkerOptions.posAnalyzer = appmWalkerOptions2.posAnalyzer;
        appmWalkerOptions.originalCase = appmWalkerOptions2.originalCase;
        appmWalkerOptions.bofaCase = appmWalkerOptions2.bofaCase;
    }

    @Override
    void forkNodeHandler(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) throws DLTException {
        int n = node.num_trans();
        this.prepLoop((AppmWalkerOptions)walkerOptions, (AppmWalkerOptions)walkerOptions2);
        for (int i = n - 1; i >= 0; --i) {
            Node node2 = node.get_trans(i);
            if (node2 == null) continue;
            this.enumWords(node2, characterBuffer, walkerOptions);
            node2.dispose();
        }
    }

    @Override
    void ptrGlossNodeHandler(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) throws DLTException {
        boolean bl;
        if (!this.doExtraSuffix) {
            return;
        }
        AppmWalkerOptions appmWalkerOptions = (AppmWalkerOptions)walkerOptions;
        AppmWalkerOptions appmWalkerOptions2 = (AppmWalkerOptions)walkerOptions2;
        boolean bl2 = bl = appmWalkerOptions2.skipRemoval == 0;
        if (bl) {
            this.preSwichHandler(appmWalkerOptions, appmWalkerOptions2);
            appmWalkerOptions.cost = appmWalkerOptions2.cost + this.remInc + appmWalkerOptions2.extraCost;
            if (this.canContinue(appmWalkerOptions2.editDistance + 1, characterBuffer.length, appmWalkerOptions.cost)) {
                this.prepRemoval(appmWalkerOptions, appmWalkerOptions2);
                appmWalkerOptions.target = appmWalkerOptions2.target;
                this.enumWords(node, characterBuffer, appmWalkerOptions);
            }
        }
    }

    @Override
    void defaultNodeHandler(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) throws DLTException {
        boolean bl;
        AppmWalkerOptions appmWalkerOptions = (AppmWalkerOptions)walkerOptions;
        AppmWalkerOptions appmWalkerOptions2 = (AppmWalkerOptions)walkerOptions2;
        int n = node.num_trans();
        if (n == 0) {
            return;
        }
        boolean bl2 = appmWalkerOptions2.skipInsertion == 0;
        boolean bl3 = appmWalkerOptions2.skipSubstitution == 0;
        boolean bl4 = appmWalkerOptions2.skipTransposition == 0;
        boolean bl5 = bl = appmWalkerOptions2.skipRemoval == 0;
        if (this.canContinue(appmWalkerOptions2.editDistance + 1, characterBuffer.length)) {
            if (appmWalkerOptions2.skipRules == 0 && this.rDict != null && appmWalkerOptions2.level < appmWalkerOptions2.target.length) {
                this.doRules(node, characterBuffer, appmWalkerOptions, appmWalkerOptions2);
            }
        } else {
            bl2 = false;
            bl3 = false;
            bl = false;
        }
        char c = '\u0000';
        appmWalkerOptions.target = appmWalkerOptions2.target;
        boolean bl6 = false;
        if (appmWalkerOptions2.level < appmWalkerOptions2.target.length) {
            c = appmWalkerOptions2.target.string[appmWalkerOptions2.level];
            bl6 = Character.isUpperCase(c);
        } else {
            bl3 = false;
            bl4 = false;
            bl = false;
            if (characterBuffer.length != 0) {
                bl6 = Character.isUpperCase(characterBuffer.string[characterBuffer.length - 1]);
            }
        }
        CharacterBuffer characterBuffer2 = this.characterBufferPool.newBuffer(characterBuffer);
        if (characterBuffer2 == null) {
            return;
        }
        if (bl) {
            appmWalkerOptions.cost = appmWalkerOptions2.cost + this.remInc + appmWalkerOptions2.extraCost;
            if (this.canContinue(appmWalkerOptions2.editDistance + 1, characterBuffer.length, appmWalkerOptions.cost)) {
                this.prepRemoval(appmWalkerOptions, appmWalkerOptions2);
                this.enumWords(node, characterBuffer2, appmWalkerOptions);
            }
        }
        for (int i = n - 1; i >= 0; --i) {
            char c2;
            Node node2 = null;
            if (!(bl4 || bl3 || bl2 || this.doKatakanaMiddleDot)) {
                c2 = c;
                node2 = node.next(c);
                i = 0;
            } else {
                node2 = node.get_trans(i);
                c2 = node.get_char(i);
            }
            if (node2 == null) continue;
            boolean bl7 = Character.isUpperCase(c2);
            if (bl7 != bl6 && CharacterMapper.toLowerCase(c2) == CharacterMapper.toLowerCase(c)) {
                bl7 = bl6;
            }
            characterBuffer2.add(c2);
            if (c2 != c) {
                if (bl4 && appmWalkerOptions2.level == 0 && appmWalkerOptions2.target.length > 1 && appmWalkerOptions2.target.string[1] == c2) {
                    appmWalkerOptions.cost = appmWalkerOptions2.cost + this.subInc + appmWalkerOptions2.extraCost;
                    this.prepSubstitution(appmWalkerOptions, appmWalkerOptions2);
                    this.enumWords(node2, characterBuffer2, appmWalkerOptions);
                }
                if (bl4 && appmWalkerOptions2.level != 0 && characterBuffer.length != 0 && appmWalkerOptions2.target.string[appmWalkerOptions2.level - 1] == characterBuffer2.string[characterBuffer.length] && appmWalkerOptions2.target.string[appmWalkerOptions2.level] == characterBuffer2.string[characterBuffer.length - 1] && (appmWalkerOptions2.editDistance != 0 || appmWalkerOptions2.level == 1)) {
                    this.prepTransposition(appmWalkerOptions, appmWalkerOptions2);
                    this.enumWords(node2, characterBuffer2, appmWalkerOptions);
                    bl4 = false;
                    characterBuffer2.decLength();
                    node2.dispose();
                    continue;
                }
                if (bl3) {
                    appmWalkerOptions.cost = appmWalkerOptions2.cost + this.subInc + appmWalkerOptions2.extraCost;
                    if (this.canContinue(appmWalkerOptions2.editDistance + 1, characterBuffer2.length)) {
                        if (!bl6 && bl7 && CharacterMapper.toLowerCase(c2) == c) {
                            bl7 = bl6;
                        }
                        if (bl7 == bl6) {
                            this.prepSubstitution(appmWalkerOptions, appmWalkerOptions2);
                            this.enumWords(node2, characterBuffer2, appmWalkerOptions);
                        }
                    }
                }
                if (bl2 && (bl7 == bl6 || c2 == '\'')) {
                    appmWalkerOptions.cost = appmWalkerOptions2.cost + this.insInc + appmWalkerOptions2.extraCost;
                    if (this.canContinue(appmWalkerOptions2.editDistance + 1, characterBuffer2.length, appmWalkerOptions.cost)) {
                        this.prepInsertion(appmWalkerOptions, appmWalkerOptions2);
                        this.enumWords(node2, characterBuffer2, appmWalkerOptions);
                    }
                }
                if (this.doKatakanaMiddleDot && bl7 == bl6 && c2 == '\u30fb') {
                    appmWalkerOptions.cost = appmWalkerOptions2.cost + this.insInc + appmWalkerOptions2.extraCost;
                    if (this.canContinue(appmWalkerOptions2.editDistance + 1, characterBuffer2.length, appmWalkerOptions.cost)) {
                        this.prepInsertion(appmWalkerOptions, appmWalkerOptions2);
                        this.enumWords(node2, characterBuffer2, appmWalkerOptions);
                    }
                }
            } else {
                this.prepMatch(appmWalkerOptions, appmWalkerOptions2);
                this.enumWords(node2, characterBuffer2, appmWalkerOptions);
            }
            characterBuffer2.decLength();
            node2.dispose();
        }
        this.characterBufferPool.releaseBuffer(characterBuffer2);
    }

    void doRules(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) throws DLTException {
        AppmWalkerOptions appmWalkerOptions = (AppmWalkerOptions)walkerOptions;
        AppmWalkerOptions appmWalkerOptions2 = (AppmWalkerOptions)walkerOptions2;
        this.itr.setText(appmWalkerOptions2.target.toString());
        this.itr.setIndex(appmWalkerOptions2.level);
        PoolableMatchBuffer poolableMatchBuffer = (PoolableMatchBuffer)this.matchBufferPool.evoke();
        poolableMatchBuffer.clear();
        this.rDict.traverse(this.itr, poolableMatchBuffer);
        for (int i = poolableMatchBuffer.mpos - 1; i >= 0; --i) {
            GlossCollection glossCollection = poolableMatchBuffer.gloss[i];
            int n = poolableMatchBuffer.index[i];
            for (Gloss gloss : glossCollection) {
                int n2;
                int n3;
                if (gloss.getType() != 17) continue;
                TCRGloss tCRGloss = (TCRGloss)gloss;
                int n4 = tCRGloss.getBOFA();
                if (appmWalkerOptions2.level != 0 ? appmWalkerOptions2.level > 0 && (appmWalkerOptions2.target.length != n ? 0 == (n4 & 4) : 0 == (n4 & 8)) : (appmWalkerOptions2.target.length == n ? 0 == (n4 & 1) : 0 == (n4 & 2))) continue;
                char[] cArray = tCRGloss.charValue;
                if (cArray.length >= n - appmWalkerOptions2.level) {
                    n3 = 0;
                    for (n3 = 0; n3 < cArray.length && n3 + appmWalkerOptions2.level < appmWalkerOptions2.target.length && cArray[n3] == appmWalkerOptions2.target.string[n3 + appmWalkerOptions2.level]; ++n3) {
                    }
                    if (n3 == cArray.length) continue;
                }
                n3 = 0;
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    if (cArray[n2] != ' ') continue;
                    n3 = 1;
                    break;
                }
                if (n3 != 0 && appmWalkerOptions2.editDistance != 0) continue;
                n2 = this.rulInc != 0 ? this.rulInc : tCRGloss.getCost() << 7;
                appmWalkerOptions.cost = appmWalkerOptions2.cost + n2 + appmWalkerOptions2.extraCost;
                int n5 = tCRGloss.charValue.length;
                this.prepRule(appmWalkerOptions, appmWalkerOptions2, n5);
                if (!this.canContinue(appmWalkerOptions.editDistance, characterBuffer.length, appmWalkerOptions.cost)) continue;
                appmWalkerOptions.target = this.characterBufferPool.infix(characterBuffer, characterBuffer.length, appmWalkerOptions2.target, cArray, n);
                if (appmWalkerOptions.target == null) continue;
                appmWalkerOptions.adopLen = appmWalkerOptions2.adopLen + (n5 - (n - appmWalkerOptions2.level));
                CharacterBuffer characterBuffer2 = this.characterBufferPool.newBuffer(characterBuffer);
                if (n3 != 0) {
                    appmWalkerOptions.editDistance = this.actualTolerance;
                }
                if (characterBuffer2 != null) {
                    this.enumWords(node, characterBuffer2, appmWalkerOptions);
                    this.characterBufferPool.releaseBuffer(characterBuffer2);
                }
                this.characterBufferPool.releaseBuffer(appmWalkerOptions.target);
            }
        }
        this.matchBufferPool.reclaim(poolableMatchBuffer.id);
    }

    private boolean canContinue(int n, int n2) {
        if (n > this.actualTolerance) {
            return false;
        }
        return n2 <= 125;
    }

    private boolean canContinue(int n, int n2, int n3) {
        if (n3 > this.sgSet.getWorstCost()) {
            return false;
        }
        if (n > this.actualTolerance) {
            return false;
        }
        return n2 <= 125;
    }

    @Override
    boolean finalise(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) throws DLTException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = !this.doWhiteSpaces;
        boolean bl2 = false;
        AppmWalkerOptions appmWalkerOptions = (AppmWalkerOptions)walkerOptions;
        AppmWalkerOptions appmWalkerOptions2 = (AppmWalkerOptions)walkerOptions2;
        for (Gloss gloss : node.getGloss()) {
            CharacterBuffer characterBuffer2;
            int n4;
            Gloss gloss2;
            int n5 = gloss.getType();
            if (n5 == 1) {
                gloss2 = ((MidGloss)gloss).getFeatureGloss();
                if (gloss2 != null) {
                    if (!gloss2.is(207)) break;
                    n = gloss2.getBOFA();
                    n2 = gloss2.getPOS();
                    if (appmWalkerOptions2.originalCase != null && appmWalkerOptions2.bofaLevel == 0) {
                        n4 = gloss.numChildren();
                        for (int i = 0; i < n4; ++i) {
                            if (gloss.getChild(i).getType() != 28) continue;
                            appmWalkerOptions.bofaCase = (CaseGloss)gloss.getChild(i);
                            bl2 = false;
                            bl = !this.doWhiteSpaces;
                            break;
                        }
                    }
                }
            } else if (n5 == 15) {
                FeatureSetGloss featureSetGloss = (FeatureSetGloss)gloss;
                if (!featureSetGloss.is(207)) break;
                n = featureSetGloss.getBOFA();
                n2 = featureSetGloss.getPOS();
            } else {
                if (n5 == 17) continue;
                n = 1;
            }
            if (!appmWalkerOptions.posAnalyzer.canContinueWithPos(n2, appmWalkerOptions2.bofaPos, appmWalkerOptions2.bofaLevel, characterBuffer)) continue;
            if (this.extraRanking) {
                n3 = -1;
                if (n == 1) {
                    if (n5 == 1) {
                        gloss2 = (IntegerGloss)((MidGloss)gloss).getGloss(18);
                        if (gloss2 != null) {
                            n3 = ((IntegerGloss)gloss2).weight;
                        }
                    } else if (n5 == 18) {
                        n3 = ((IntegerGloss)gloss).weight;
                    }
                }
                if (n3 == -1) {
                    int n6 = n3 = ApproximateMatcher.getScaleFactor() - 1 < 0 ? 0 : ApproximateMatcher.getScaleFactor() - 1;
                }
            }
            if ((n & appmWalkerOptions2.end) != 0) {
                int n7 = appmWalkerOptions2.adopLen - characterBuffer.length;
                if (!bl2) {
                    if (n7 == 0) {
                        bl2 = true;
                        this.process(characterBuffer, appmWalkerOptions2.cost + n3, appmWalkerOptions.bofaCase, appmWalkerOptions.originalCase, appmWalkerOptions.bofaLevel != 0, gloss);
                    }
                    if (n7 > 0 && this.doExtraSuffix) {
                        n4 = appmWalkerOptions2.cost + n7 * this.remInc + (n7 - 1) * this.ext2Inc + n3;
                        if (!bl2 && this.canContinue(appmWalkerOptions2.editDistance + n7, characterBuffer.length, n4)) {
                            bl2 = true;
                            this.process(characterBuffer, n4, appmWalkerOptions.bofaCase, appmWalkerOptions.originalCase, appmWalkerOptions.bofaLevel != 0, gloss);
                        }
                    }
                }
                if (!bl && n7 > 0 && (n & 1) != 0) {
                    CharacterBuffer characterBuffer3;
                    Node node2;
                    n4 = appmWalkerOptions2.level;
                    if ((appmWalkerOptions2.target.string[appmWalkerOptions2.level] == '.' || appmWalkerOptions2.target.string[appmWalkerOptions2.level] == ',' || appmWalkerOptions2.target.string[appmWalkerOptions2.level] == '!' || appmWalkerOptions2.target.string[appmWalkerOptions2.level] == '?' || appmWalkerOptions2.target.string[appmWalkerOptions2.level] == ':' || appmWalkerOptions2.target.string[appmWalkerOptions2.level] == ';') && appmWalkerOptions2.level < appmWalkerOptions2.target.length - 1) {
                        ++n4;
                    }
                    if (appmWalkerOptions2.target.string[n4] != ' ') {
                        if (appmWalkerOptions2.editDistance == 0) {
                            CharacterBuffer characterBuffer4;
                            appmWalkerOptions.cost = appmWalkerOptions2.cost + this.whtInc + appmWalkerOptions2.extraCost + n3;
                            if (this.canContinue(appmWalkerOptions2.editDistance + 1, characterBuffer.length, appmWalkerOptions.cost) && (characterBuffer4 = this.characterBufferPool.newBuffer(characterBuffer)) != null) {
                                if (n4 != appmWalkerOptions2.level) {
                                    characterBuffer4.add(appmWalkerOptions2.target.string[appmWalkerOptions2.level]);
                                }
                                characterBuffer4.add(' ');
                                this.prepWhiteSpace(appmWalkerOptions, appmWalkerOptions2);
                                appmWalkerOptions.level = n4;
                                appmWalkerOptions.editDistance = this.actualTolerance;
                                node2 = this.iDict.getNet().first();
                                this.enumWords(node2, characterBuffer4, appmWalkerOptions);
                                if (node2 != null) {
                                    node2.dispose();
                                }
                                this.characterBufferPool.releaseBuffer(characterBuffer4);
                                bl = true;
                            }
                        }
                    } else if (this.whiteSpaceTokenization && (characterBuffer3 = this.characterBufferPool.newBuffer(characterBuffer)) != null) {
                        characterBuffer3.add(' ');
                        this.prepMatch(appmWalkerOptions, appmWalkerOptions2);
                        appmWalkerOptions.target = appmWalkerOptions2.target;
                        appmWalkerOptions.cost += n3;
                        if (this.strictMWU && appmWalkerOptions.editDistance != 0) {
                            appmWalkerOptions.editDistance = this.actualTolerance;
                        }
                        if (this.extraRanking) {
                            appmWalkerOptions.cost += this.insInc;
                        }
                        node2 = this.iDict.getNet().first();
                        this.enumWords(node2, characterBuffer3, appmWalkerOptions);
                        if (node2 != null) {
                            node2.dispose();
                        }
                        this.characterBufferPool.releaseBuffer(characterBuffer3);
                        bl = true;
                    }
                }
            }
            if (!this.doCompoundLooping || characterBuffer.length >= appmWalkerOptions2.adopLen || (appmWalkerOptions2.bofaLevel == 0 || (n & 4) == 0) && (appmWalkerOptions2.bofaLevel != 0 || (n & 2) == 0)) continue;
            this.prepLoop(appmWalkerOptions, appmWalkerOptions2);
            appmWalkerOptions.bofaPos = appmWalkerOptions2.bofaLevel != 0 ? appmWalkerOptions2.bofaPos : n2;
            appmWalkerOptions.bofaLevel = appmWalkerOptions2.bofaLevel + 1;
            appmWalkerOptions.cost = appmWalkerOptions2.cost + (appmWalkerOptions2.editDistance == 0 ? 0 : this.bofaInc);
            if (!this.canContinue(appmWalkerOptions2.editDistance, characterBuffer.length, appmWalkerOptions.cost) || (characterBuffer2 = this.characterBufferPool.newBuffer(characterBuffer)) == null) continue;
            Node node3 = this.iDict.getNet().first();
            this.enumWords(node3, characterBuffer2, appmWalkerOptions);
            if (node3 != null) {
                node3.dispose();
            }
            this.characterBufferPool.releaseBuffer(characterBuffer2);
        }
        return false;
    }

    private void process(CharacterBuffer characterBuffer, int n, CaseGloss caseGloss, CaseGloss caseGloss2, boolean bl, Gloss gloss) throws DLTException {
        int n2 = 0;
        if (caseGloss != null) {
            int n3;
            int n4 = this.caseHandlingMethod;
            int n5 = n3 = this.firstWordOfSentence ? 268700161 : 268698113;
            if (this.spellerValidator != null) {
                n4 = this.spellerValidator.getCaseHandlingMethod();
            }
            CaseGloss caseGloss3 = caseGloss.chooseCompatibleCase(n4, caseGloss2, n3);
            CharacterBuffer characterBuffer2 = null;
            if (caseGloss3 != caseGloss2) {
                if (caseGloss2.isCrazyCase()) {
                    characterBuffer2 = this.transferCrazyCase(characterBuffer);
                }
                if (characterBuffer2 == null) {
                    n2 += this.caseInc;
                }
            }
            characterBuffer = characterBuffer2 != null ? characterBuffer2 : characterBuffer.applyCase(caseGloss3);
        } else if (caseGloss2 != null) {
            characterBuffer = characterBuffer.applyCase(caseGloss2);
        }
        if (!this.allowExactMatch && characterBuffer.equals(this.sgSet.target)) {
            return;
        }
        if (characterBuffer.length > 2 && this.sgSet.target.length > 2 && this.sgSet.target.string[0] != characterBuffer.string[0] && (this.sgSet.target.string[1] != characterBuffer.string[0] || this.sgSet.target.string[0] != characterBuffer.string[1])) {
            n2 += this.ext1Inc;
        }
        if (characterBuffer.length > 3 && this.sgSet.target.length > 3 && this.sgSet.target.string[this.sgSet.target.length - 1] != characterBuffer.string[characterBuffer.length - 1] && (this.sgSet.target.string[this.sgSet.target.length - 1] != characterBuffer.string[characterBuffer.length - 2] || this.sgSet.target.string[this.sgSet.target.length - 2] != characterBuffer.string[characterBuffer.length - 1])) {
            n2 += this.ext1Inc;
        }
        n2 += n;
        if (bl) {
            if (this.spellerValidator.isValidSuggestion(characterBuffer.toString())) {
                this.sgSet.add(characterBuffer.toString(), n2);
            }
        } else {
            this.sgSet.add(characterBuffer.toString(), n2);
        }
    }

    private CharacterBuffer transferCrazyCase(CharacterBuffer characterBuffer) {
        char c;
        int n;
        CharacterBuffer characterBuffer2 = this.sgSet.target;
        int n2 = 0;
        int n3 = 0;
        while (n3 < characterBuffer2.position()) {
            if (n2 >= characterBuffer.position()) {
                return null;
            }
            n = characterBuffer2.string[n3];
            c = characterBuffer.string[n2];
            if (Character.isUpperCase((char)n)) {
                if (!Character.isUpperCase(c)) {
                    if (c == ' ') {
                        if (++n2 >= characterBuffer.position()) {
                            return null;
                        }
                        c = characterBuffer.string[n2];
                    } else if (n3 != 0) {
                        return null;
                    }
                    if (n != Character.toUpperCase(c)) {
                        return null;
                    }
                }
            } else if (n != c) {
                return null;
            }
            ++n3;
            ++n2;
        }
        if (n2 != characterBuffer.position()) {
            return null;
        }
        CharacterBuffer characterBuffer3 = new CharacterBuffer();
        n2 = 0;
        n = 0;
        while (n < characterBuffer2.position()) {
            c = characterBuffer2.string[n];
            char c2 = characterBuffer.string[n2];
            if (Character.isUpperCase(c)) {
                if (Character.isUpperCase(c2)) {
                    characterBuffer3.add(c2);
                }
                if (c2 == ' ') {
                    characterBuffer3.add(c2);
                    c2 = characterBuffer.string[++n2];
                }
                characterBuffer3.add(Character.toUpperCase(c2));
            } else {
                characterBuffer3.add(c2);
            }
            ++n;
            ++n2;
        }
        return characterBuffer3;
    }

    private int checkCapital(String string, String string2) {
        char c;
        if (string.length() != string2.length()) {
            return 0;
        }
        if (!string.regionMatches(1, string2, 1, string2.length() - 1)) {
            return 0;
        }
        char c2 = string.charAt(0);
        if (c2 == (c = string2.charAt(0))) {
            return 0;
        }
        if (c2 == Character.toUpperCase(c)) {
            return 1;
        }
        if (c == Character.toUpperCase(c2)) {
            return 2;
        }
        return 0;
    }

    private String[] retResult() {
        int n;
        String[] stringArray = new String[this.replySize];
        int[] nArray = new int[this.replySize];
        int n2 = -1;
        if (this.sgSet.count == 0) {
            return null;
        }
        boolean bl = Character.isLowerCase(this.sgSet.target.string[0]);
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = Integer.MAX_VALUE;
            for (n = 0; n < this.sgSet.count; ++n) {
                if (this.sgSet.sgsSet[n] == null || this.sgSet.sgsCost[n] > n4) continue;
                n4 = this.sgSet.sgsCost[n];
                n2 = n;
            }
            if (n4 == Integer.MAX_VALUE) break;
            stringArray[n3] = this.sgSet.sgsSet[n2];
            nArray[n3] = this.sgSet.sgsCost[n2];
            this.sgSet.sgsSet[n2] = null;
            if (bl) {
                for (n = 0; n < n3; ++n) {
                    if (stringArray[n] == null) continue;
                    int n5 = this.checkCapital(stringArray[n3], stringArray[n]);
                    if (n5 == 1 && nArray[n3] >= nArray[n]) break;
                    if (n5 != 2 || nArray[n3] > nArray[n]) continue;
                    stringArray[n] = stringArray[n3];
                    nArray[n] = nArray[n3];
                    break;
                }
                n3 += n == n3 ? 1 : 0;
                continue;
            }
            ++n3;
        }
        if (this.deltaCost != 0) {
            for (n = 0; n < n3 - 1; ++n) {
                if (nArray[n + 1] - nArray[n] <= this.deltaCost) continue;
                String[] stringArray2 = new String[n + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
                return stringArray2;
            }
        }
        if (n3 < stringArray.length) {
            String[] stringArray3 = new String[n3];
            System.arraycopy(stringArray, 0, stringArray3, 0, n3);
            return stringArray3;
        }
        return stringArray;
    }

    static int aidSkipDec(int n) {
        return n != 0 ? n - 1 : n;
    }

    static final int aidSkipInc(int n) {
        return n == 0 ? n + 1 : n;
    }

    private void prepRemoval(AppmWalkerOptions appmWalkerOptions, AppmWalkerOptions appmWalkerOptions2) {
        appmWalkerOptions.adopLen = appmWalkerOptions2.adopLen - 1;
        appmWalkerOptions.editDistance = appmWalkerOptions2.editDistance + 1;
        appmWalkerOptions.level = appmWalkerOptions2.level + 1;
        appmWalkerOptions.skipRemoval = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipRemoval);
        appmWalkerOptions.skipInsertion = ApproximateMatcher.aidSkipInc(appmWalkerOptions2.skipInsertion);
        appmWalkerOptions.skipSubstitution = ApproximateMatcher.aidSkipInc(appmWalkerOptions2.skipSubstitution);
        appmWalkerOptions.skipTransposition = ApproximateMatcher.aidSkipInc(appmWalkerOptions2.skipTransposition);
        appmWalkerOptions.skipRules = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipRules);
        appmWalkerOptions.extraCost = this.ext2Inc;
    }

    private void prepTransposition(AppmWalkerOptions appmWalkerOptions, AppmWalkerOptions appmWalkerOptions2) {
        appmWalkerOptions.adopLen = appmWalkerOptions2.adopLen;
        appmWalkerOptions.editDistance = appmWalkerOptions2.editDistance;
        appmWalkerOptions.level = appmWalkerOptions2.level + 1;
        appmWalkerOptions.skipRemoval = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipRemoval);
        appmWalkerOptions.skipInsertion = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipInsertion);
        appmWalkerOptions.skipSubstitution = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipSubstitution);
        appmWalkerOptions.skipTransposition = ApproximateMatcher.aidSkipInc(appmWalkerOptions2.skipTransposition);
        appmWalkerOptions.skipRules = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipRules);
        appmWalkerOptions.extraCost = this.ext2Inc;
        appmWalkerOptions.cost = appmWalkerOptions2.cost - this.subInc + this.trnInc;
    }

    private void prepSubstitution(AppmWalkerOptions appmWalkerOptions, AppmWalkerOptions appmWalkerOptions2) {
        appmWalkerOptions.adopLen = appmWalkerOptions2.adopLen;
        appmWalkerOptions.editDistance = appmWalkerOptions2.editDistance + 1;
        appmWalkerOptions.level = appmWalkerOptions2.level + 1;
        appmWalkerOptions.skipRemoval = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipRemoval);
        appmWalkerOptions.skipInsertion = ApproximateMatcher.aidSkipInc(appmWalkerOptions2.skipInsertion);
        appmWalkerOptions.skipSubstitution = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipSubstitution);
        appmWalkerOptions.skipTransposition = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipTransposition);
        appmWalkerOptions.skipRules = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipRules);
        appmWalkerOptions.extraCost = this.ext2Inc;
    }

    private void prepInsertion(AppmWalkerOptions appmWalkerOptions, AppmWalkerOptions appmWalkerOptions2) {
        appmWalkerOptions.adopLen = appmWalkerOptions2.adopLen + 1;
        appmWalkerOptions.editDistance = appmWalkerOptions2.editDistance + 1;
        appmWalkerOptions.level = appmWalkerOptions2.level;
        appmWalkerOptions.skipRemoval = ApproximateMatcher.aidSkipInc(appmWalkerOptions2.skipRemoval);
        appmWalkerOptions.skipInsertion = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipInsertion);
        appmWalkerOptions.skipSubstitution = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipSubstitution);
        appmWalkerOptions.skipTransposition = ApproximateMatcher.aidSkipInc(appmWalkerOptions2.skipTransposition);
        appmWalkerOptions.skipRules = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipRules);
        appmWalkerOptions.extraCost = this.ext2Inc;
    }

    private void prepMatch(AppmWalkerOptions appmWalkerOptions, AppmWalkerOptions appmWalkerOptions2) {
        appmWalkerOptions.adopLen = appmWalkerOptions2.adopLen;
        appmWalkerOptions.bofaLevel = appmWalkerOptions2.bofaLevel;
        appmWalkerOptions.editDistance = appmWalkerOptions2.editDistance;
        appmWalkerOptions.level = appmWalkerOptions2.level + 1;
        appmWalkerOptions.skipRemoval = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipRemoval);
        appmWalkerOptions.skipInsertion = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipInsertion);
        appmWalkerOptions.skipSubstitution = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipSubstitution);
        appmWalkerOptions.skipTransposition = ApproximateMatcher.aidSkipInc(appmWalkerOptions2.skipTransposition);
        appmWalkerOptions.skipRules = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipRules);
        appmWalkerOptions.extraCost = appmWalkerOptions2.skipRules == 0 ? 0 : appmWalkerOptions2.extraCost;
        appmWalkerOptions.cost = appmWalkerOptions2.cost;
    }

    private void prepWhiteSpace(AppmWalkerOptions appmWalkerOptions, AppmWalkerOptions appmWalkerOptions2) {
        appmWalkerOptions.target = appmWalkerOptions2.target;
        appmWalkerOptions.bofaLevel = appmWalkerOptions2.bofaLevel;
        appmWalkerOptions.end = 1;
        appmWalkerOptions.adopLen = appmWalkerOptions2.adopLen + 1;
        appmWalkerOptions.editDistance = appmWalkerOptions2.editDistance + 1;
        appmWalkerOptions.level = appmWalkerOptions2.level;
        appmWalkerOptions.skipRemoval = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipRemoval);
        appmWalkerOptions.skipInsertion = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipInsertion);
        appmWalkerOptions.skipSubstitution = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipSubstitution);
        appmWalkerOptions.skipTransposition = ApproximateMatcher.aidSkipInc(appmWalkerOptions2.skipTransposition);
        appmWalkerOptions.skipRules = ApproximateMatcher.aidSkipDec(appmWalkerOptions2.skipRules);
        appmWalkerOptions.extraCost = this.ext2Inc + this.remInc;
    }

    private void prepLoop(AppmWalkerOptions appmWalkerOptions, AppmWalkerOptions appmWalkerOptions2) {
        appmWalkerOptions.target = appmWalkerOptions2.target;
        appmWalkerOptions.end = 8;
        appmWalkerOptions.adopLen = appmWalkerOptions2.adopLen;
        appmWalkerOptions.editDistance = appmWalkerOptions2.editDistance;
        appmWalkerOptions.level = appmWalkerOptions2.level;
        appmWalkerOptions.skipRemoval = appmWalkerOptions2.skipRemoval;
        appmWalkerOptions.skipInsertion = appmWalkerOptions2.skipInsertion;
        appmWalkerOptions.skipSubstitution = appmWalkerOptions2.skipSubstitution;
        appmWalkerOptions.skipTransposition = appmWalkerOptions2.skipTransposition;
        appmWalkerOptions.skipRules = appmWalkerOptions2.skipRules;
        appmWalkerOptions.cost = appmWalkerOptions2.cost;
        appmWalkerOptions.extraCost = appmWalkerOptions2.extraCost;
    }

    private void prepRule(AppmWalkerOptions appmWalkerOptions, AppmWalkerOptions appmWalkerOptions2, int n) {
        appmWalkerOptions.editDistance = appmWalkerOptions2.editDistance + 1;
        appmWalkerOptions.level = appmWalkerOptions2.level - (appmWalkerOptions2.target.length - appmWalkerOptions2.adopLen);
        appmWalkerOptions.skipRemoval = appmWalkerOptions2.skipRemoval + n;
        appmWalkerOptions.skipInsertion = appmWalkerOptions2.skipInsertion + n;
        appmWalkerOptions.skipSubstitution = appmWalkerOptions2.skipSubstitution + n;
        appmWalkerOptions.skipTransposition = appmWalkerOptions2.skipTransposition + n;
        appmWalkerOptions.skipRules = appmWalkerOptions2.skipRules + n;
        appmWalkerOptions.extraCost = this.ext2Inc;
    }

    void verifyIsSuggestion(String[] stringArray, int n, Dictionary dictionary) {
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null || this.checkIsSuggestion(stringArray[i], dictionary)) continue;
            stringArray[i] = null;
        }
    }

    private boolean checkIsSuggestion(String string, Dictionary dictionary) {
        GlossCollection glossCollection = dictionary.get(string);
        if (glossCollection == null) {
            return true;
        }
        for (Gloss gloss : glossCollection) {
            FeatureSetGloss featureSetGloss;
            int n = gloss.getType();
            if (!(n == 1 ? (featureSetGloss = ((MidGloss)gloss).getFeatureGloss()) != null && !featureSetGloss.is(207) : n == 15 && !((FeatureSetGloss)gloss).is(207))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String[] gather(String string, Dictionary[] dictionaryArray, Dictionary dictionary, int n, boolean bl) throws DLTException {
        int n2;
        this.sgSet = new SuggestionSet(n, new CharacterBuffer(string));
        this.replySize = n;
        boolean bl2 = false;
        for (n2 = 0; n2 < dictionaryArray.length; ++n2) {
            Object object;
            Object object2;
            this.iDict = dictionaryArray[n2];
            if (this.iDict == null || this.iDict.getSummary().hasFunction(85)) continue;
            if (bl2) {
                object2 = this.iDict.getLanguages();
                object = "";
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    object = (String)object + object2[i] + " ";
                }
                this.sgSet.add((String)object + this.iDict.getSummary().getVersionStr(), 0);
                continue;
            }
            object2 = (AppmWalkerOptions)this.optionsPool.evoke();
            Dictionary dictionary2 = bl ? (dictionary != null ? dictionary : this.iDict) : (this.rDict = null);
            if (this.iDict.getSummary().isLowerCase()) {
                object2.originalCase = new CaseGloss(string);
                object2.target = !object2.originalCase.isLowerCase() ? new CharacterBuffer(string.toLowerCase()) : new CharacterBuffer(string);
            } else {
                object2.originalCase = null;
                object2.target = new CharacterBuffer(string);
            }
            if (object2.target.string == null) {
                this.optionsPool.reclaim(object2.id);
                return null;
            }
            object2.end = 1;
            object2.adopLen = string.length();
            object2.editDistance = 0;
            object2.level = 0;
            object2.skipRemoval = 0;
            object2.skipTransposition = 0;
            object2.skipRules = 0;
            object2.extraCost = 0;
            object2.cost = 0;
            object2.bofaLevel = 0;
            object2.bofaPos = 0;
            object2.bofaCase = null;
            this.assignIncrements();
            this.assignOperations((AppmWalkerOptions)object2);
            this.actualTolerance = this.getTolerance(string.length());
            this.setPosAnalyzer((AppmWalkerOptions)object2, dictionaryArray);
            if (this.spellerValidator != null) {
                ((SuggestionValidator)this.spellerValidator).open();
                this.sgSet.filter_spec = this.spellerValidator.getCharacterFilter();
            }
            object = this.characterBufferPool.newBuffer();
            ((CharacterBuffer)object).clear();
            Node node = this.iDict.getNet().first();
            this.enumWords(node, (CharacterBuffer)object, (WalkerOptions)object2);
            if (node != null) {
                node.dispose();
                node = null;
            }
            this.optionsPool.reclaim(object2.id);
            this.characterBufferPool.releaseBuffer((CharacterBuffer)object);
            if (this.spellerValidator == null) continue;
            ((SuggestionValidator)this.spellerValidator).close();
        }
        if (!bl2) {
            for (n2 = 0; n2 < dictionaryArray.length; ++n2) {
                if (dictionaryArray[n2] == null || dictionaryArray[n2].getSummary().hasFunction(85)) continue;
                this.verifyIsSuggestion(this.sgSet.sgsSet, this.sgSet.count, dictionaryArray[n2]);
            }
        }
        return this.retResult();
    }

    protected void setPosAnalyzer(AppmWalkerOptions appmWalkerOptions, Dictionary[] dictionaryArray) throws DLTException {
        appmWalkerOptions.posAnalyzer = POS_ANALYZER;
        this.spellerValidator = null;
        this.caseHandlingMethod = 67372551;
        String[] stringArray = this.iDict.getLanguages();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].toLowerCase();
            if (string.startsWith("de") && string.indexOf("prereform") < 0) {
                appmWalkerOptions.posAnalyzer = DE_REFORMED_POS_ANALYZER;
                this.bofaInc = this.whtInc;
                this.spellerValidator = new SuggestionValidator(dictionaryArray, string);
                break;
            }
            if (string.startsWith("en")) {
                appmWalkerOptions.posAnalyzer = LOOSE_POS_ANALYZER;
                this.spellerValidator = new SuggestionValidator(dictionaryArray, string);
                this.doCompoundLooping = true;
                break;
            }
            if (string.startsWith("sv")) {
                appmWalkerOptions.posAnalyzer = HYPHEN_APOSTROPHE_POS_ANALYZER;
                break;
            }
            if (string.startsWith("nl")) {
                appmWalkerOptions.posAnalyzer = DE_REFORMED_POS_ANALYZER;
                this.bofaInc = this.whtInc;
                break;
            }
            if (string.startsWith("es")) {
                appmWalkerOptions.posAnalyzer = ES_POS_ANALYZER;
                break;
            }
            if (string.startsWith("ar")) {
                appmWalkerOptions.posAnalyzer = SIMPLE_POS_ANALYZER;
                this.spellerValidator = new SuggestionValidator(dictionaryArray, string);
                break;
            }
            if (!string.startsWith("fr")) continue;
            appmWalkerOptions.posAnalyzer = SIMPLE_POS_ANALYZER;
            this.doCompoundLooping = true;
            this.spellerValidator = new SuggestionValidator(dictionaryArray, string);
            break;
        }
    }

    public static class PoolableMatchBuffer
    extends MatchBuffer
    implements Poolable {
        public int id = -1;

        @Override
        public void reg4pool(int n, Pool pool) {
            this.id = n;
        }
    }
}

