/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.CharacterBuffer;
import com.ibm.dltj.nondeterm.PosAnalyzer;

class FrPosAnalyzer
implements PosAnalyzer {
    private static final CharacterBuffer apostrohe = new CharacterBuffer("'");
    private static final CharacterBuffer hyphen = new CharacterBuffer("-");
    private static final CharacterBuffer Dapostrohe = new CharacterBuffer("D'");
    private static final CharacterBuffer Lapostrohe = new CharacterBuffer("L'");
    private static final CharacterBuffer Tapostrohe = new CharacterBuffer("T'");
    private static final CharacterBuffer dapostrohe = new CharacterBuffer("d'");
    private static final CharacterBuffer lapostrohe = new CharacterBuffer("l'");
    private static final CharacterBuffer tapostrohe = new CharacterBuffer("t'");

    FrPosAnalyzer() {
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    public boolean canContinueWithPos(int n, int n2, int n3, CharacterBuffer characterBuffer) {
        if (n3 == 0) {
            return true;
        }
        if (characterBuffer.indexOf(apostrohe) == -1 && characterBuffer.indexOf(hyphen) == -1) {
            return false;
        }
        if (n3 == 1) {
            if (characterBuffer.indexOf(Dapostrohe) == 0 || characterBuffer.indexOf(dapostrohe) == 0) {
                return n == 1 || n == 3 || n == 2 || n == 5;
            }
            if (characterBuffer.indexOf(Lapostrohe) == 0 || characterBuffer.indexOf(lapostrohe) == 0) {
                return n == 3 || n == 2;
            }
            if (characterBuffer.indexOf(Tapostrohe) == 0 || characterBuffer.indexOf(tapostrohe) == 0) {
                return n == 2;
            }
        }
        return false;
    }
}

