/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.CharacterBuffer;
import com.ibm.dltj.CharacterBufferPool;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.nondeterm.NondeterministicWalker;
import com.ibm.dltj.nondeterm.Pool;
import com.ibm.dltj.nondeterm.SuggestionSet;
import com.ibm.dltj.nondeterm.WalkerOptions;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class FuzzyMatcher
extends NondeterministicWalker {
    public static final char QQ = '?';
    public static final char SS = '*';
    private SuggestionSet sgSet = null;
    public static final int maxRSize = 1000;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public FuzzyMatcher(CharacterBufferPool characterBufferPool, Pool pool) {
        super(characterBufferPool, pool);
    }

    @Override
    boolean finalise(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) {
        if (walkerOptions2.level == walkerOptions2.target.length || walkerOptions2.level + 1 == walkerOptions2.target.length && walkerOptions2.target.string[walkerOptions2.target.string.length - 1] == '*') {
            int n = 0;
            if (this.extraRanking) {
                for (Gloss gloss : node.getGloss()) {
                    if (gloss.getType() == 1) {
                        IntegerGloss integerGloss = (IntegerGloss)((MidGloss)gloss).getGloss(18);
                        if (integerGloss != null) {
                            n = integerGloss.weight;
                            continue;
                        }
                        n = FuzzyMatcher.getScaleFactor() - 1;
                        continue;
                    }
                    if (gloss.getType() == 18) {
                        n = ((IntegerGloss)gloss).weight;
                        continue;
                    }
                    n = FuzzyMatcher.getScaleFactor() - 1;
                }
            }
            if (this.replySize == this.sgSet.add(characterBuffer.toString(), n) && !this.extraRanking) {
                return true;
            }
        }
        return false;
    }

    @Override
    void forkNodeHandler(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) throws DLTException {
        int n = node.num_trans();
        for (int i = n - 1; i >= 0; --i) {
            Node node2 = node.get_trans(i);
            if (node2 == null) continue;
            this.enumWords(node2, characterBuffer, walkerOptions2);
            node2.dispose();
        }
    }

    @Override
    void defaultNodeHandler(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) throws DLTException {
        Node node2;
        char c = '\u0000';
        if (walkerOptions2.level >= walkerOptions2.target.length) {
            return;
        }
        c = walkerOptions2.target.string[walkerOptions2.level];
        if (c != '\u0000' && (node2 = node.next(c)) != null) {
            characterBuffer.add(c);
            walkerOptions.level = walkerOptions2.level + 1;
            walkerOptions.target = walkerOptions2.target;
            this.enumWords(node2, characterBuffer, walkerOptions);
            characterBuffer.decLength();
            node2.dispose();
            return;
        }
        if (c == '*') {
            walkerOptions.level = walkerOptions2.level + 1;
            walkerOptions.target = walkerOptions2.target;
            this.enumWords(node, characterBuffer, walkerOptions);
        }
        if (c == '?' || c == '*') {
            int n = node.num_trans();
            for (int i = 0; i < n; ++i) {
                Node node3 = node.get_trans(i);
                if (node3 == null) continue;
                char c2 = node.get_char(i);
                characterBuffer.add(c2);
                walkerOptions.level = walkerOptions2.level + 1;
                walkerOptions.target = walkerOptions2.target;
                this.enumWords(node3, characterBuffer, walkerOptions);
                if (c == '*') {
                    walkerOptions.level = walkerOptions2.level;
                    this.enumWords(node3, characterBuffer, walkerOptions);
                }
                characterBuffer.decLength();
                node3.dispose();
            }
        }
        this.characterBufferPool.releaseBuffer(characterBuffer);
    }

    @Override
    void preSwichHandler(WalkerOptions walkerOptions, WalkerOptions walkerOptions2) {
    }

    @Override
    void ptrGlossNodeHandler(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) {
    }

    @Override
    public String[] gather(String string, Dictionary[] dictionaryArray, Dictionary dictionary, int n, boolean bl) throws DLTException {
        this.sgSet = new SuggestionSet(n > 1000 ? 1000 : n, null);
        this.replySize = n;
        CharacterBuffer characterBuffer = new CharacterBuffer(string);
        for (int i = 0; i < dictionaryArray.length; ++i) {
            if (dictionaryArray[i] == null) continue;
            WalkerOptions walkerOptions = (WalkerOptions)this.optionsPool.evoke();
            walkerOptions.target = characterBuffer;
            CharacterBuffer characterBuffer2 = this.characterBufferPool.newBuffer();
            characterBuffer2.clear();
            Node node = dictionaryArray[i].getNet().first();
            this.enumWords(node, characterBuffer2, walkerOptions);
            if (node != null) {
                node.dispose();
            }
            this.optionsPool.reclaim(walkerOptions.id);
            this.characterBufferPool.releaseBuffer(characterBuffer2);
        }
        return this.retResult();
    }

    private String[] retResult() {
        int n;
        if (this.sgSet.count == 0) {
            return null;
        }
        TreeMap treeMap = new TreeMap();
        Set set = null;
        int n2 = -1;
        for (n = 0; n < this.sgSet.count; ++n) {
            int n3 = this.sgSet.sgsCost[n];
            if (set == null || n2 != n3) {
                Integer n4 = n3;
                set = (TreeSet<String>)treeMap.get(n4);
                if (set == null) {
                    set = new TreeSet<String>();
                    treeMap.put(n4, set);
                }
                n2 = n3;
            }
            set.add(this.sgSet.sgsSet[n]);
        }
        n = Math.min(this.replySize, this.sgSet.count);
        String[] stringArray = new String[n];
        int n5 = 0;
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext() && n5 < n) {
            set = (Set)iterator.next();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext() && n5 < n) {
                stringArray[n5] = (String)iterator2.next();
                ++n5;
            }
        }
        return stringArray;
    }

    void doRules(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) throws DLTException {
    }
}

