/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.CharacterBuffer;
import com.ibm.dltj.CharacterBufferPool;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.nondeterm.Pool;
import com.ibm.dltj.nondeterm.WalkerOptions;

abstract class NondeterministicWalker {
    protected int replySize = -1;
    public static final int poolSize = 32;
    protected Pool optionsPool = null;
    protected CharacterBufferPool characterBufferPool = null;
    public boolean extraRanking = false;
    public boolean doCompoundLooping = false;
    public boolean whiteSpaceTokenization = false;
    public boolean allowExactMatch = false;
    protected static final int scaleFactor = 7;
    protected static int scale = 1;
    public static final int DLTAID_ABSOLUTE_WORSTCOST = Integer.MAX_VALUE;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static int getScaleFactor() {
        return 128;
    }

    public NondeterministicWalker(CharacterBufferPool characterBufferPool) {
        this.characterBufferPool = characterBufferPool;
    }

    public NondeterministicWalker(CharacterBufferPool characterBufferPool, Pool pool) {
        this.characterBufferPool = characterBufferPool;
        this.optionsPool = pool;
    }

    void chainNodeHandler() {
        throw new IllegalArgumentException(Messages.getString("notimplement"));
    }

    abstract void preSwichHandler(WalkerOptions var1, WalkerOptions var2) throws DLTException;

    abstract void defaultNodeHandler(Node var1, CharacterBuffer var2, WalkerOptions var3, WalkerOptions var4) throws DLTException;

    abstract void forkNodeHandler(Node var1, CharacterBuffer var2, WalkerOptions var3, WalkerOptions var4) throws DLTException;

    abstract void ptrGlossNodeHandler(Node var1, CharacterBuffer var2, WalkerOptions var3, WalkerOptions var4) throws DLTException;

    abstract boolean finalise(Node var1, CharacterBuffer var2, WalkerOptions var3, WalkerOptions var4) throws DLTException;

    abstract String[] gather(String var1, Dictionary[] var2, Dictionary var3, int var4, boolean var5) throws DLTException;

    public boolean enumWords(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions) throws DLTException {
        Node node2;
        if (node == null) {
            return false;
        }
        WalkerOptions walkerOptions2 = (WalkerOptions)this.optionsPool.evoke();
        this.preSwichHandler(walkerOptions2, walkerOptions);
        boolean bl = false;
        boolean bl2 = false;
        if (node.isFinal()) {
            bl = this.finalise(node, characterBuffer, walkerOptions2, walkerOptions);
            if (node.num_trans() > 0) {
                this.ptrGlossNodeHandler(node, characterBuffer, walkerOptions2, walkerOptions);
                this.preSwichHandler(walkerOptions2, walkerOptions);
            }
        }
        if (!bl) {
            if (node.num_chars() > 1) {
                this.chainNodeHandler();
            } else if (node.num_chars() == 0) {
                if (node.num_trans() > 1) {
                    this.forkNodeHandler(node, characterBuffer, walkerOptions2, walkerOptions);
                } else {
                    bl2 = true;
                }
            } else {
                this.defaultNodeHandler(node, characterBuffer, walkerOptions2, walkerOptions);
            }
        }
        if (!bl2) {
            this.optionsPool.reclaim(walkerOptions2.id);
        }
        if (bl2 && !bl && (node2 = node.get_trans(0)) != null) {
            this.enumWords(node2, characterBuffer, walkerOptions);
            node2.dispose();
        }
        return bl;
    }

    static void dlt_assert(boolean bl) {
        if (!bl) {
            System.err.println(Messages.getString("fail.assertion"));
            Exception exception = new Exception();
            exception.printStackTrace();
        }
    }
}

