/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.nondeterm.Poolable;

public class Pool {
    private int poolSize;
    private Poolable[] pool;
    Class<?> elementClass = null;
    private boolean[] PAT;
    public int numAvailable = 0;
    private int nextProbable = 0;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public boolean valid() {
        int n = 0;
        for (int i = 0; i < this.poolSize; ++i) {
            if (!this.PAT[i]) continue;
            ++n;
        }
        return n == this.numAvailable;
    }

    public Poolable evoke() {
        if (this.PAT[this.nextProbable]) {
            this.PAT[this.nextProbable] = false;
            --this.numAvailable;
            int n = this.nextProbable;
            this.nextProbable = this.nextProbable < this.poolSize - 1 ? ++this.nextProbable : 0;
            return this.getExisting(n);
        }
        for (int i = 0; i < this.poolSize; ++i) {
            if (!this.PAT[i]) continue;
            this.PAT[i] = false;
            --this.numAvailable;
            return this.getExisting(i);
        }
        return this.newElement();
    }

    private Poolable getExisting(int n) {
        Poolable poolable = this.pool[n];
        if (poolable == null) {
            this.pool[n] = poolable = this.newElement();
            poolable.reg4pool(n, this);
        }
        return poolable;
    }

    private Poolable newElement() {
        try {
            return (Poolable)this.elementClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    public void reclaim(int n) {
        if (n != -1) {
            this.PAT[n] = true;
            ++this.numAvailable;
            this.nextProbable = n;
        }
    }

    public boolean init(Class<?> clazz, int n) {
        this.poolSize = n;
        this.elementClass = clazz;
        this.pool = new Poolable[n];
        this.PAT = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.PAT[i] = true;
        }
        this.numAvailable = this.poolSize;
        this.nextProbable = 0;
        return this.valid();
    }
}

