/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.CharacterBuffer;
import com.ibm.dltj.CharacterBufferPool;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.nondeterm.AppmWalkerOptions;
import com.ibm.dltj.nondeterm.ApproximateMatcher;
import com.ibm.dltj.nondeterm.LookupResult;
import com.ibm.dltj.nondeterm.Pool;
import com.ibm.dltj.nondeterm.SuggestionSet;

public class RuleBasedLookup
extends ApproximateMatcher {
    protected GlossCollection[] glossCollection;
    private static final int RSIZE = 1;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public RuleBasedLookup(CharacterBufferPool characterBufferPool, Pool pool, Pool pool2) {
        super(characterBufferPool, pool, pool2);
    }

    @Deprecated
    public RuleBasedLookup(CharacterBufferPool characterBufferPool) {
        super(characterBufferPool);
    }

    public static RuleBasedLookup getInstance() {
        CharacterBufferPool characterBufferPool = new CharacterBufferPool();
        characterBufferPool.init(CharacterBuffer.class, 32);
        Pool pool = new Pool();
        pool.init(AppmWalkerOptions.class, 32);
        Pool pool2 = new Pool();
        pool2.init(ApproximateMatcher.PoolableMatchBuffer.class, 32);
        RuleBasedLookup ruleBasedLookup = new RuleBasedLookup(characterBufferPool, pool, pool2);
        ruleBasedLookup.extraRanking = false;
        ruleBasedLookup.whiteSpaceTokenization = false;
        ruleBasedLookup.allowExactMatch = false;
        ruleBasedLookup.doWhiteSpaces = false;
        ruleBasedLookup.doExtraSuffix = false;
        ruleBasedLookup.doKatakanaMiddleDot = false;
        return ruleBasedLookup;
    }

    @Override
    public void assignIncrements() {
    }

    @Override
    public void assignOperations(AppmWalkerOptions appmWalkerOptions) throws DLTException {
        if (this.rDict == null) {
            throw new DLTException(Messages.getString("error.dict.rule"));
        }
        appmWalkerOptions.skipInsertion = 127;
        appmWalkerOptions.skipSubstitution = 127;
        appmWalkerOptions.skipRemoval = 127;
        appmWalkerOptions.skipTransposition = 127;
        appmWalkerOptions.skipRules = 0;
    }

    @Override
    public int getTolerance(int n) {
        if (n > 5) {
            return 2;
        }
        return 1;
    }

    public LookupResult lookup(String string, Dictionary[] dictionaryArray, Dictionary dictionary) throws DLTException {
        int n;
        boolean bl = true;
        this.sgSet = new SuggestionSet(1, new CharacterBuffer(string));
        this.replySize = 1;
        for (n = 0; n < dictionaryArray.length; ++n) {
            this.iDict = dictionaryArray[n];
            if (this.iDict == null) continue;
            AppmWalkerOptions appmWalkerOptions = (AppmWalkerOptions)this.optionsPool.evoke();
            this.rDict = bl ? (dictionary != null ? dictionary : this.iDict) : null;
            appmWalkerOptions.target = new CharacterBuffer(string);
            if (appmWalkerOptions.target.string == null) {
                this.optionsPool.reclaim(appmWalkerOptions.id);
                return null;
            }
            appmWalkerOptions.end = 1;
            appmWalkerOptions.adopLen = string.length();
            appmWalkerOptions.editDistance = 0;
            appmWalkerOptions.level = 0;
            appmWalkerOptions.skipRemoval = 0;
            appmWalkerOptions.skipTransposition = 0;
            appmWalkerOptions.skipRules = 0;
            appmWalkerOptions.extraCost = 0;
            appmWalkerOptions.cost = 0;
            appmWalkerOptions.bofaLevel = 0;
            appmWalkerOptions.bofaPos = 0;
            this.assignIncrements();
            this.assignOperations(appmWalkerOptions);
            this.actualTolerance = this.getTolerance(string.length());
            this.setPosAnalyzer(appmWalkerOptions, dictionaryArray);
            CharacterBuffer characterBuffer = this.characterBufferPool.newBuffer();
            characterBuffer.clear();
            Node node = this.iDict.getNet().first();
            this.enumWords(node, characterBuffer, appmWalkerOptions);
            if (node != null) {
                node.dispose();
            }
            this.optionsPool.reclaim(appmWalkerOptions.id);
            this.characterBufferPool.releaseBuffer(characterBuffer);
        }
        for (n = 0; n < dictionaryArray.length; ++n) {
            if (dictionaryArray[n] == null) continue;
            this.verifyIsSuggestion(this.sgSet.sgsSet, this.sgSet.count, dictionaryArray[n]);
        }
        return this.retResult();
    }

    GlossCollection IsSuggestion(String string, Dictionary dictionary) {
        GlossCollection glossCollection = dictionary.get(string);
        if (glossCollection == null) {
            return null;
        }
        for (Gloss gloss : glossCollection) {
            FeatureSetGloss featureSetGloss;
            if (!(gloss.getType() == 1 ? (featureSetGloss = ((MidGloss)gloss).getFeatureGloss()) != null && !featureSetGloss.is(207) : gloss.getType() == 15 && !((FeatureSetGloss)gloss).is(207))) continue;
            return null;
        }
        return glossCollection;
    }

    @Override
    void verifyIsSuggestion(String[] stringArray, int n, Dictionary dictionary) {
        this.glossCollection = new GlossCollection[stringArray.length];
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            GlossCollection glossCollection = this.IsSuggestion(stringArray[i], dictionary);
            if (glossCollection == null) {
                stringArray[i] = null;
                continue;
            }
            this.glossCollection[i] = glossCollection;
        }
    }

    private LookupResult retResult() {
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        if (this.sgSet.count == 0) {
            return null;
        }
        for (int i = 0; i < this.sgSet.count; ++i) {
            if (this.sgSet.sgsSet[i] == null || this.sgSet.sgsCost[i] > n) continue;
            n = this.sgSet.sgsCost[i];
            n2 = i;
        }
        if (n != Integer.MAX_VALUE && n2 >= 0) {
            return new LookupResult(this.sgSet.sgsSet[n2], this.glossCollection[n2]);
        }
        return null;
    }
}

