/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.CharacterBuffer;
import com.ibm.dltj.util.CharacterFilterSpecification;
import com.ibm.dltj.util.CharacterFilteringIterator;

class SuggestionSet {
    int count;
    private final int setSize;
    final String[] sgsSet;
    final int[] sgsCost;
    public final CharacterBuffer target;
    public CharacterFilterSpecification filter_spec;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    SuggestionSet(int n, CharacterBuffer characterBuffer) {
        this.setSize = n;
        this.count = 0;
        this.target = characterBuffer;
        this.sgsSet = new String[this.setSize];
        this.sgsCost = new int[this.setSize];
        this.sgsCost[this.setSize - 1] = Integer.MAX_VALUE;
    }

    private final int compare(int n, String string, int n2) {
        int n3 = this.sgsCost[n] - n2;
        if (n3 == 0) {
            n3 = this.sgsSet[n].compareTo(string);
        }
        assert (n3 != 0);
        return n3;
    }

    public final int getWorstCost() {
        return this.sgsCost[this.setSize - 1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int add(String string, int n) {
        if (n > this.getWorstCost()) {
            return this.count;
        }
        int n2 = this.count;
        string = CharacterFilteringIterator.filter(this.filter_spec, string);
        for (int i = 0; i < this.count; ++i) {
            if (!this.sgsSet[i].equalsIgnoreCase(string)) continue;
            if (this.sgsCost[i] <= n) return this.count;
            n2 = i;
            --this.count;
            break;
        }
        if (n2 == this.setSize) {
            if (this.compare(n2 - 1, string, n) <= 0) return this.count;
            --n2;
        } else {
            ++this.count;
        }
        while (n2 > 0 && this.compare(n2 - 1, string, n) >= 0) {
            this.sgsCost[n2] = this.sgsCost[n2 - 1];
            this.sgsSet[n2] = this.sgsSet[n2 - 1];
            --n2;
        }
        this.sgsCost[n2] = n;
        this.sgsSet[n2] = string;
        return this.count;
    }

    public String toString() {
        String string = "[";
        if (this.count > 0) {
            string = string + this.sgsSet[0] + ':' + this.sgsCost[0];
        }
        for (int i = 1; i < this.count; ++i) {
            string = string + ',' + this.sgsSet[i] + ':' + this.sgsCost[i];
        }
        return string + ']';
    }
}

