/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.normaliser;

import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.gloss.TCRGloss;
import com.ibm.dltj.util.IntArray;
import com.ibm.dltj.util.StringBufferCharacterIterator;
import com.ibm.icu.text.Normalizer2;

public class DLTNormaliser {
    private final Dictionary dict;
    private final Normalizer2 norm;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public DLTNormaliser(Dictionary dictionary, String string, Normalizer2.Mode mode) {
        this.dict = dictionary;
        this.norm = Normalizer2.getInstance(null, (String)string, (Normalizer2.Mode)mode);
    }

    public String normalise(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        this.norm.normalize(charSequence, stringBuilder);
        this.normaliseTCR(stringBuilder, null);
        return stringBuilder.toString();
    }

    public String normalise(CharSequence charSequence, IntArray intArray) {
        intArray.clear();
        StringBuilder stringBuilder = new StringBuilder();
        this.normaliseUnicode(charSequence, stringBuilder, intArray);
        this.normaliseTCR(stringBuilder, intArray);
        return stringBuilder.toString();
    }

    private void normaliseUnicode(CharSequence charSequence, StringBuilder stringBuilder, IntArray intArray) {
        int n = 0;
        int n2 = 0;
        while (n < charSequence.length()) {
            int n3;
            int n4 = this.norm.spanQuickCheckYes(charSequence.subSequence(n, charSequence.length()));
            stringBuilder.append(charSequence, n, n + n4);
            n2 += n4;
            if ((n += n4) == charSequence.length()) break;
            for (n3 = n + 1; n3 < charSequence.length() && !this.norm.hasBoundaryBefore((int)charSequence.charAt(n3)); ++n3) {
            }
            this.norm.normalizeSecondAndAppend(stringBuilder, charSequence.subSequence(n, n3));
            int n5 = stringBuilder.length();
            if (n5 - n2 != n3 - n) {
                int n6;
                int n7 = Math.min(n5 - n2, n3 - n);
                for (n6 = 0; n6 < n7 && charSequence.charAt(n3 - 1 - n6) == stringBuilder.charAt(n5 - 1 - n6); ++n6) {
                }
                intArray.add(n3 - n6);
                intArray.add(n5 - n6);
            }
            n = n3;
            n2 = n5;
        }
    }

    private void normaliseTCR(StringBuilder stringBuilder, IntArray intArray) {
        int n;
        for (n = 0; n < stringBuilder.length(); ++n) {
            int n2;
            int n3;
            Gloss gloss;
            GlossCollection glossCollection;
            if (stringBuilder.charAt(n) == '\ufffe' || stringBuilder.charAt(n) == '\uffff') {
                stringBuilder.setCharAt(n, ' ');
            }
            StringBufferCharacterIterator stringBufferCharacterIterator = new StringBufferCharacterIterator(stringBuilder, n);
            MatchBuffer matchBuffer = new MatchBuffer();
            this.dict.lookupLongest(stringBufferCharacterIterator, matchBuffer);
            if (matchBuffer.getNumMatches() != 1 || (glossCollection = matchBuffer.gloss[0]) == null || glossCollection.size() != 1 || (gloss = glossCollection.first()).getType() != 17) continue;
            TCRGloss tCRGloss = (TCRGloss)gloss;
            char[] cArray = tCRGloss.charValue;
            stringBuilder.replace(n, matchBuffer.index[0], String.valueOf(cArray));
            if (intArray != null && (n3 = cArray.length - (n2 = matchBuffer.index[0] - n)) != 0) {
                int n4 = n + Math.min(n2, cArray.length);
                DLTNormaliser.insertChange(intArray, n4, n3);
            }
            if (cArray.length != 0) continue;
            --n;
        }
        for (n = 0; n < stringBuilder.length() && stringBuilder.charAt(n) == ' '; ++n) {
        }
        if (intArray != null && n > 0) {
            stringBuilder.delete(0, n);
            DLTNormaliser.insertChange(intArray, 0, -n);
        }
    }

    public static int searchByDest(IntArray intArray, int n) {
        int n2 = intArray.size() / 2;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            int n5 = (n3 + n4) / 2;
            if (intArray.get(2 * n5 + 1) < n) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5;
        }
        return n3;
    }

    public static int getSourceIndex(IntArray intArray, int n) {
        int n2 = DLTNormaliser.searchByDest(intArray, n);
        return DLTNormaliser.getSourceIndex(intArray, n, n2);
    }

    private static int getSourceIndex(IntArray intArray, int n, int n2) {
        int n3;
        int n4 = intArray.size() / 2;
        if (n2 < n4 && intArray.get(2 * n2 + 1) == n) {
            return intArray.get(2 * n2);
        }
        int n5 = 0;
        int n6 = 0;
        if (n2 > 0) {
            n5 = intArray.get(n2 * 2 - 2);
            n6 = intArray.get(n2 * 2 - 1);
        }
        if (n2 >= n4) {
            return n5 + (n - n6);
        }
        int n7 = intArray.get(n2 * 2);
        int n8 = Math.min(n7 - n5, (n3 = intArray.get(n2 * 2 + 1)) - n6);
        if (n - n6 < n8) {
            return n5 + (n - n6);
        }
        return n7;
    }

    public static int searchBySource(IntArray intArray, int n) {
        int n2 = intArray.size() / 2;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            int n5 = (n3 + n4) / 2;
            if (intArray.get(2 * n5) < n) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5;
        }
        return n3;
    }

    public static int getDestIndex(IntArray intArray, int n) {
        int n2 = DLTNormaliser.searchBySource(intArray, n);
        return DLTNormaliser.getDestIndex(intArray, n, n2);
    }

    private static int getDestIndex(IntArray intArray, int n, int n2) {
        int n3;
        int n4 = intArray.size() / 2;
        if (n2 < n4 && intArray.get(2 * n2) == n) {
            return intArray.get(2 * n2 + 1);
        }
        int n5 = 0;
        int n6 = 0;
        if (n2 > 0) {
            n5 = intArray.get(n2 * 2 - 2);
            n6 = intArray.get(n2 * 2 - 1);
        }
        if (n2 >= n4) {
            return n6 + (n - n5);
        }
        int n7 = intArray.get(n2 * 2);
        int n8 = Math.min(n7 - n5, (n3 = intArray.get(n2 * 2 + 1)) - n6);
        if (n - n5 < n8) {
            return n6 + (n - n5);
        }
        return n3;
    }

    private static void insertChange(IntArray intArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        for (n5 = DLTNormaliser.searchByDest(intArray, n); n5 < intArray.size() / 2 && intArray.get(n5 * 2 + 1) == n; ++n5) {
        }
        if (n2 > 0) {
            n4 = DLTNormaliser.getSourceIndex(intArray, n, n5);
            n3 = n + n2;
        } else {
            n4 = DLTNormaliser.getSourceIndex(intArray, n - n2);
            n3 = n;
        }
        intArray.add(n5 * 2, n4);
        intArray.add(n5 * 2 + 1, n3);
        for (int i = n5 * 2 + 3; i < intArray.size(); i += 2) {
            intArray.set(i, intArray.get(i) + n2);
            if (intArray.get(i - 3) - intArray.get(i - 1) != intArray.get(i - 2) - intArray.get(i)) continue;
            intArray.removeRange(i - 1, i + 1);
            i -= 2;
        }
    }
}

