/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.parser;

public abstract class RBBICategory {
    public static final int TOKEN_TYPE_UNKNOWN = 0;
    public static final int TOKEN_TYPE_PUNCTUATION = 1;
    public static final int TOKEN_TYPE_MID_WORD_PUNCTUATION = 2;
    public static final int TOKEN_TYPE_CLAUSE_END_PUNCTUATION = 8;
    public static final int TOKEN_TYPE_SENTENCE_BREAK = 11;
    public static final int TOKEN_TYPE_PARAGRAPH_BREAK = 13;
    public static final int TOKEN_TYPE_WHITESPACE = 10;
    public static final int TOKEN_TYPE_WORDLIKESEQUENCE = 100;
    public static final int TOKEN_TYPE_FILEPATH = 101;
    public static final int TOKEN_TYPE_EMAIL = 102;
    public static final int TOKEN_TYPE_NUMBER = 103;
    public static final int TOKEN_TYPE_URL = 104;
    public static final int TOKEN_TYPE_DATE = 105;
    public static final int TOKEN_TYPE_TIME = 106;
    public static final int TOKEN_TYPE_DATE_AND_TIME = 107;
    public static final int TOKEN_TYPE_TEL = 108;
    public static final int TOKEN_TYPE_CURRENCY = 109;
    public static final int TOKEN_TYPE_CLITIC = 110;
    public static final int TOKEN_TYPE_REPEATED_WORD = 111;
    public static final int TOKEN_TYPE_WORD = 200;
    public static final int TOKEN_TYPE_LOWERCASEWORD = 201;
    public static final int TOKEN_TYPE_UPPERCASEWORD = 202;
    public static final int TOKEN_TYPE_CAPITALIZEDWORD = 203;
    public static final int TOKEN_TYPE_ACRONYM = 205;
    public static final int TOKEN_TYPE_ROMAN = 206;
    public static final int TOKEN_TYPE_IDEOGRAPHIC = 300;
    public static final int TOKEN_TYPE_JAPANESE_HIRAGANA = 301;
    public static final int TOKEN_TYPE_HAN = 302;
    public static final int TOKEN_TYPE_KOREAN = 303;
    public static final int TOKEN_TYPE_JAPANESE_KATAKANA = 304;
    public static final int TOKEN_TYPE_ARABIC = 310;
    public static final int TOKEN_TYPE_HEBREW = 311;
    public static final int TOKEN_TYPE_THAI = 320;
    public static final int TOKEN_TYPE_LAO = 321;
    public static final int TOKEN_TYPE_DEVANAGARI = 330;
    @Deprecated
    public static final int TOKEN_TYPE_CJKNUMBER = 400;
    @Deprecated
    public static final int TOKEN_TYPE_CJKDATE = 401;
    public static final int TOKEN_TYPE_ZH_IDEO_NUMBER = 420;
    public static final int TOKEN_TYPE_ZH_IDEO_LARGE_NUMBER = 421;
    public static final int TOKEN_TYPE_ZH_IDEO_SEQUENCE = 425;
    public static final int TOKEN_TYPE_ZH_FRACTION = 426;
    public static final int TOKEN_TYPE_ZH_DECADE_YEARS = 427;
    @Deprecated
    public static final int TOKEN_TYPE_CJKNUMBER1 = 490;
    public static final int TOKEN_TYPE_VERSION = 500;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static final boolean isToken(int n) {
        return n > 10;
    }

    public static final boolean isSentenceBreak(int n) {
        return n == 11;
    }

    public static boolean isPararaphBreak(int n) {
        return n == 13;
    }

    public static final boolean isWord(int n) {
        return n >= 200 && n <= 203 || n == 303 || n == 310 || n == 311 || n == 320 || n == 321 || n == 330;
    }

    public static final boolean isPunctuation(int n) {
        return n == 1 || n == 2 || n == 8 || n == 11;
    }

    public static final boolean isWhitespace(int n) {
        return n == 10;
    }

    public static final boolean isWordLike(int n) {
        return n >= 200 && n <= 203 || n == 100 || n == 206 || n == 303 || n == 310 || n == 311 || n == 320 || n == 321 || n == 330;
    }

    public static final String toString(int n) {
        switch (n) {
            case 1: {
                return "TOKEN_TYPE_PUNCTUATION";
            }
            case 2: {
                return "TOKEN_TYPE_MID_WORD_PUNCTUATION";
            }
            case 8: {
                return "TOKEN_TYPE_CLAUSE_END_PUNCTUATION";
            }
            case 13: {
                return "TOKEN_TYPE_PARAGRAPH_BREAK";
            }
            case 10: {
                return "TOKEN_TYPE_WHITESPACE";
            }
            case 100: {
                return "TOKEN_TYPE_WORDLIKESEQUENCE";
            }
            case 101: {
                return "TOKEN_TYPE_FILEPATH";
            }
            case 102: {
                return "TOKEN_TYPE_EMAIL";
            }
            case 103: {
                return "TOKEN_TYPE_NUMBER";
            }
            case 104: {
                return "TOKEN_TYPE_URL";
            }
            case 105: {
                return "TOKEN_TYPE_DATE";
            }
            case 106: {
                return "TOKEN_TYPE_TIME";
            }
            case 107: {
                return "TOKEN_TYPE_DATE_AND_TIME";
            }
            case 108: {
                return "TOKEN_TYPE_TEL";
            }
            case 109: {
                return "TOKEN_TYPE_CURRENCY";
            }
            case 111: {
                return "TOKEN_TYPE_REPEATED_WORD";
            }
            case 201: {
                return "TOKEN_TYPE_LOWERCASEWORD";
            }
            case 202: {
                return "TOKEN_TYPE_UPPERCASEWORD";
            }
            case 203: {
                return "TOKEN_TYPE_CAPITALIZEDWORD";
            }
            case 205: {
                return "TOKEN_TYPE_ACRONYM";
            }
            case 206: {
                return "TOKEN_TYPE_ROMAN";
            }
            case 300: {
                return "TOKEN_TYPE_IDEOGRAPHIC";
            }
            case 301: {
                return "TOKEN_TYPE_JAPANESE_HIRAGANA";
            }
            case 302: {
                return "TOKEN_TYPE_HAN";
            }
            case 303: {
                return "TOKEN_TYPE_KOREAN";
            }
            case 304: {
                return "TOKEN_TYPE_JAPANESE_KATAKANA";
            }
            case 310: {
                return "TOKEN_TYPE_ARABIC";
            }
            case 311: {
                return "TOKEN_TYPE_HEBREW";
            }
            case 320: {
                return "TOKEN_TYPE_THAI";
            }
            case 321: {
                return "TOKEN_TYPE_LAO";
            }
            case 330: {
                return "TOKEN_TYPE_DEVANAGARI";
            }
            case 400: {
                return "TOKEN_TYPE_CJNUMBER";
            }
            case 401: {
                return "TOKEN_TYPE_CJDATE";
            }
            case 420: {
                return "TOKEN_TYPE_ZH_IDEO_NUMBER";
            }
            case 421: {
                return "TOKEN_TYPE_ZH_IDEO_LARGE_NUMBER";
            }
            case 425: {
                return "TOKEN_TYPE_ZH_IDEO_SEQUENCE";
            }
            case 426: {
                return "TOKEN_TYPE_ZH_FRACTION";
            }
            case 427: {
                return "TOKEN_TYPE_ZH_DECADE_YEARS";
            }
            case 500: {
                return "TOKEN_TYPE_VERSION";
            }
        }
        return "TOKEN_TYPE_UNKNOWN";
    }

    public static final String toDescription(int n) {
        switch (n) {
            case 1: {
                return "punctuation";
            }
            case 2: {
                return "mid-word punctuation";
            }
            case 8: {
                return "clause-ending punctuation";
            }
            case 10: {
                return "whitespace";
            }
            case 13: {
                return "paragraph break";
            }
            case 100: {
                return "word-like token (not a word)";
            }
            case 101: {
                return "filepath";
            }
            case 102: {
                return "e-mail";
            }
            case 103: {
                return "numeric expression";
            }
            case 104: {
                return "URL";
            }
            case 105: {
                return "date expression";
            }
            case 106: {
                return "time expression";
            }
            case 107: {
                return "date and time expression";
            }
            case 108: {
                return "telephone number";
            }
            case 109: {
                return "currency expression";
            }
            case 111: {
                return "repeated word";
            }
            case 201: {
                return "lowercase word";
            }
            case 202: {
                return "uppercase word";
            }
            case 203: {
                return "capitalized word";
            }
            case 205: {
                return "acronym";
            }
            case 206: {
                return "Roman numeral";
            }
            case 300: {
                return "ideographic";
            }
            case 301: {
                return "Hiragana";
            }
            case 302: {
                return "Han";
            }
            case 303: {
                return "Korean";
            }
            case 304: {
                return "Katakana";
            }
            case 310: {
                return "Arabic";
            }
            case 311: {
                return "Hebrew";
            }
            case 320: {
                return "Thai";
            }
            case 321: {
                return "Lao";
            }
            case 330: {
                return "Devanagari";
            }
            case 400: {
                return "Chinese, Japanese, or Korean numeric expression";
            }
            case 401: {
                return "Chinese, Japanese, or Korean date expression";
            }
            case 420: {
                return "Chinese ideographic numeric expression";
            }
            case 421: {
                return "Chinese ideographic numeric expression (large number)";
            }
            case 425: {
                return "Chinese ideographic sequence";
            }
            case 426: {
                return "Chinese fractional number";
            }
            case 427: {
                return "Chinese decadal year expression";
            }
            case 500: {
                return "LanguageWare version";
            }
        }
        return "Unknown";
    }
}

