/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.parser.impl;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.classificationcodeslist.WordClasses;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.parser.ClassificationMWUParsingStream;
import com.ibm.dltj.parser.ClassificationParsingStream;
import com.ibm.dltj.parser.MWUParsingStream;
import java.text.CharacterIterator;

public class ClassificationMWUParsingStreamImpl
implements MWUParsingStream {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    private UniLexAnalyzer uniLex;
    private ClassificationParsingStream cParsingStream;
    private CharacterIterator ci;
    WordClasses wordClasses;

    public ClassificationMWUParsingStreamImpl(UniLexAnalyzer uniLexAnalyzer, ClassificationParsingStream classificationParsingStream) {
        this.uniLex = uniLexAnalyzer;
        this.cParsingStream = classificationParsingStream;
        this.wordClasses = new WordClasses();
        this.ci = uniLexAnalyzer.getSourceText();
    }

    @Override
    public void addToFork() {
        this.cParsingStream.addToFork();
    }

    @Override
    public void close() {
        this.cParsingStream.close();
    }

    @Override
    public void closeGroup(int n) {
        this.cParsingStream.closeGroup(n);
    }

    @Override
    public void createBreakpoint(int n, int n2, int n3) {
        this.cParsingStream.createBreakpoint(n, n2, n3);
    }

    @Override
    public void createPunctuation(int n, int n2, int n3, int n4) {
        this.cParsingStream.createPunctuation(n, n2, n3, n4);
    }

    @Override
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        this.cParsingStream.createStd(n, n2, n3, glossCollection);
    }

    @Override
    public void fork() {
        this.cParsingStream.fork();
    }

    @Override
    public void mergeRoutes(int n) {
        this.cParsingStream.mergeRoutes(n);
    }

    @Override
    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.cParsingStream.reset(uniLexAnalyzer);
        this.ci = (CharacterIterator)uniLexAnalyzer.getSourceText().clone();
    }

    @Override
    public int startGroup(int n, int n2, int n3) {
        return this.cParsingStream.startGroup(n, n2, n3);
    }

    @Override
    public void createUnknown(int n, int n2, int n3, int n4) {
        GlossCollection glossCollection;
        this.wordClasses = new WordClasses();
        this.ci.setIndex(n2);
        try {
            glossCollection = this.uniLex.getBreakIterator().lookupWord(this.ci, n3 - n2);
        }
        catch (DLTException dLTException) {
            throw new UnsupportedOperationException(dLTException);
        }
        TokenClassGloss tokenClassGloss = (TokenClassGloss)glossCollection.first();
        this.wordClasses.setClassificationCodes(tokenClassGloss);
        this.cParsingStream.createUnknown(n, n2, n3, this.wordClasses);
    }

    @Override
    public void createMWU(int n, int n2, int n3, Gloss gloss) {
        ((ClassificationMWUParsingStream)this.cParsingStream).createMWU(n, n2, n3, gloss);
    }
}

