/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.parser.impl;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.parser.LemmaParsingStream;
import com.ibm.dltj.parser.ParsingStream;
import java.text.CharacterIterator;

public class PreLemmatization
implements ParsingStream {
    private LemmaParsingStream lemmaStream;
    CharacterIterator Oitr;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public PreLemmatization(LemmaParsingStream lemmaParsingStream, CharacterIterator characterIterator) {
        this.lemmaStream = lemmaParsingStream;
        this.Oitr = characterIterator;
    }

    @Override
    public void close() {
        this.lemmaStream.close();
    }

    @Override
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        for (Gloss gloss : glossCollection) {
            String string = "";
            if (gloss.getType() == 1) {
                try {
                    LemmaGenerator lemmaGenerator;
                    if (gloss instanceof MidGloss && (lemmaGenerator = ((MidGloss)gloss).getLemmaGloss()) != null) {
                        string = string.concat(lemmaGenerator.getLemma(this.Oitr, n2, n3));
                        this.lemmaStream.createStd(n, n2, n3, string, gloss);
                        continue;
                    }
                    if (!(gloss instanceof LemmaGenerator.ForLemma)) continue;
                    string = string.concat(((LemmaGenerator)((Object)gloss)).getLemma(this.Oitr, n2, n3));
                    this.lemmaStream.createStd(n, n2, n3, string, gloss);
                }
                catch (DLTException dLTException) {
                    dLTException.printStackTrace();
                }
                continue;
            }
            this.lemmaStream.createStd(n, n2, n3, string, gloss);
        }
        this.lemmaStream.endLemma();
    }

    @Override
    public void createUnknown(int n, int n2, int n3, int n4) {
        this.lemmaStream.createUnknown(n, n2, n3, n4);
    }

    @Override
    public void createBreakpoint(int n, int n2, int n3) {
        this.lemmaStream.createBreakpoint(n, n2, n3);
    }

    @Override
    public void createPunctuation(int n, int n2, int n3, int n4) {
        this.lemmaStream.createPunctuation(n, n2, n3, n4);
    }

    @Override
    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.lemmaStream.reset(uniLexAnalyzer);
    }

    @Override
    public int startGroup(int n, int n2, int n3) {
        this.lemmaStream.startGroup(n, n2, n3);
        return 0;
    }

    @Override
    public void closeGroup(int n) {
        this.lemmaStream.closeGroup(n);
    }

    @Override
    public void fork() {
        this.lemmaStream.fork();
    }

    @Override
    public void addToFork() {
        this.lemmaStream.addToFork();
    }

    @Override
    public void mergeRoutes(int n) {
        this.lemmaStream.mergeRoutes(n);
    }
}

