/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.parser.impl;

import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.parser.ParsingStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TokenCountObserverParsingStream
implements ParsingStream {
    private static final Logger _logger = Logger.getLogger(TokenCountObserverParsingStream.class.getName());
    private final int threshold = 200;
    private int count = 0;

    private void increment(int n, int n2) {
        ++this.count;
        if (this.count == 200 && _logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, Messages.format("warning.longsentence", n, n2, this.count));
        }
    }

    @Override
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        this.increment(n2, n3);
    }

    @Override
    public void createUnknown(int n, int n2, int n3, int n4) {
        this.increment(n2, n3);
    }

    @Override
    public void createPunctuation(int n, int n2, int n3, int n4) {
        this.increment(n2, n3);
    }

    @Override
    public void createBreakpoint(int n, int n2, int n3) {
        if (n3 == 2) {
            this.count = 0;
        }
    }

    @Override
    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.count = 0;
    }

    @Override
    public void close() {
        this.count = 0;
    }
}

