/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.poe;

public class BinaryBlock {
    protected byte[] data;
    protected boolean isBigEndian;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public BinaryBlock(byte[] byArray, boolean bl) {
        this.data = byArray;
        this.isBigEndian = bl;
    }

    public short getShort(int n) {
        int n2 = 0;
        if (this.isBigEndian) {
            n2 = this.data[n];
            n2 <<= 8;
            n2 |= 0xFF & this.data[n + 1];
        } else {
            n2 = this.data[n + 1];
            n2 <<= 8;
            n2 |= 0xFF & this.data[n];
        }
        return (short)n2;
    }

    public void setShort(int n, short s) {
        if (this.isBigEndian) {
            this.data[n] = (byte)(0xFF & s >> 8);
            this.data[n + 1] = (byte)(0xFF & s);
        } else {
            this.data[n] = (byte)(0xFF & s);
            this.data[n + 1] = (byte)(0xFF & s >> 8);
        }
    }

    void setInt(int n, int n2) {
        if (this.isBigEndian) {
            this.setShort(n, (short)(0xFFFF & n2 >> 16));
            this.setShort(n + 2, (short)(0xFFFF & n2));
        } else {
            this.setShort(n + 2, (short)(0xFFFF & n2 >> 16));
            this.setShort(n, (short)(0xFFFF & n2));
        }
    }

    void setLong8(int n, int n2) {
        if (this.isBigEndian) {
            this.setShort(n, (short)0);
            this.setShort(n + 2, (short)0);
            this.setShort(n + 4, (short)(0xFFFF & n2 >> 16));
            this.setShort(n + 6, (short)(0xFFFF & n2));
        } else {
            this.setShort(n + 6, (short)0);
            this.setShort(n + 4, (short)0);
            this.setShort(n + 2, (short)(0xFFFF & n2 >> 16));
            this.setShort(n, (short)(0xFFFF & n2));
        }
    }
}

