/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.poe;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.DictionaryInfo;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.MisspeltWord;
import com.ibm.dltj.SpellCheckerSession;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.nondeterm.AdvancedLookupDriver;
import com.ibm.dltj.poe.BinaryBlock;
import com.ibm.dltj.poe.PoeStyleControlBlock;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public class PoeEntryPoint {
    static final short DICT_POOL_OFFSET = 30;
    private static DictionaryRef[] dictionaryPool = new DictionaryRef[50];
    static final String debugPrefix = "JRE: ";
    private static final int endDictCacheIndex = 2;
    private static int dictCacheIndex = 0;
    private static AdvancedLookupDriver lastSpellAidDriver = null;
    private static int continueReplyState = -1;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static synchronized short NlpEntry(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) {
        try {
            PoeStyleControlBlock.init();
            PoeStyleControlBlock poeStyleControlBlock = new PoeStyleControlBlock(byArray, bl);
            short s = poeStyleControlBlock.getFunctionCode();
            if (s == 9) {
                try {
                    return PoeEntryPoint.dictionaryActivate(poeStyleControlBlock, new String(byArray2, poeStyleControlBlock.getCharsetName()), new BinaryBlock(byArray3, bl));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return 109;
                }
            }
            if (s == 10) {
                return PoeEntryPoint.dictionaryDeActivate(poeStyleControlBlock, new BinaryBlock(byArray3, bl));
            }
            if (s == 24 || s == 13 || s == 21) {
                return PoeEntryPoint.processWord(s, poeStyleControlBlock, new BinaryBlock(byArray2, bl), new BinaryBlock(byArray3, bl));
            }
            if (s == 1) {
                return PoeEntryPoint.spellCheck(poeStyleControlBlock, new BinaryBlock(byArray2, bl), new BinaryBlock(byArray3, bl));
            }
            if (s == 2) {
                return PoeEntryPoint.spellAid(poeStyleControlBlock, new BinaryBlock(byArray2, bl), new BinaryBlock(byArray3, bl));
            }
            if (s == 11) {
                try {
                    return PoeEntryPoint.createDictionary(poeStyleControlBlock, new String(byArray2, poeStyleControlBlock.getCharsetName()), new BinaryBlock(byArray3, bl));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return 109;
                }
            }
            if (s == 23) {
                return PoeEntryPoint.saveDictionary(poeStyleControlBlock);
            }
            if (s == 22) {
                return PoeEntryPoint.listWords(poeStyleControlBlock, new BinaryBlock(byArray3, bl));
            }
            return 19;
        }
        catch (Throwable throwable) {
            return 86;
        }
    }

    private static short saveDictionary(PoeStyleControlBlock poeStyleControlBlock) {
        byte[] byArray = poeStyleControlBlock.getDictTokens();
        if (byArray == null) {
            return 11;
        }
        if (byArray.length != 1) {
            return 12;
        }
        try {
            dictionaryPool[byArray[0]].getDictionary().save(true);
        }
        catch (Throwable throwable) {
            return 27;
        }
        return 73;
    }

    private static short listWords(PoeStyleControlBlock poeStyleControlBlock, BinaryBlock binaryBlock) {
        Dictionary[] dictionaryArray = PoeEntryPoint.extractDictionarySet(poeStyleControlBlock);
        if (dictionaryArray == null) {
            return 11;
        }
        if (dictionaryArray[0] == null) {
            return 11;
        }
        Iterator<Map.Entry<String, Object>> iterator = null;
        int n = 73;
        try {
            iterator = dictionaryArray[0].iterator();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String string = entry.getKey();
                if (poeStyleControlBlock.getRequestType() == 1 && continueReplyState > n4) {
                    ++n4;
                    continue;
                }
                byte[] byArray = string.getBytes(poeStyleControlBlock.getCharsetName());
                if (n2 >= binaryBlock.data.length - (4 + byArray.length)) {
                    poeStyleControlBlock.setContReply();
                    n = 76;
                    continueReplyState = n3 + n4;
                    break;
                }
                binaryBlock.data[n2] = 0;
                binaryBlock.data[++n2] = 0;
                binaryBlock.data[++n2] = (byte)string.length();
                System.arraycopy(byArray, 0, binaryBlock.data, ++n2, byArray.length);
                n2 += byArray.length;
                ++n3;
            }
            poeStyleControlBlock.setDelivered(n3);
            poeStyleControlBlock.setReplyUsed(n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 109;
        }
        catch (DLTException dLTException) {
            return 86;
        }
        return (short)n;
    }

    private static short processWord(int n, PoeStyleControlBlock poeStyleControlBlock, BinaryBlock binaryBlock, BinaryBlock binaryBlock2) {
        int n2;
        Dictionary[] dictionaryArray = PoeEntryPoint.extractDictionarySet(poeStyleControlBlock);
        if (dictionaryArray == null) {
            return 11;
        }
        for (n2 = 0; n2 < dictionaryArray.length; ++n2) {
            if (dictionaryArray[n2] != null) continue;
            return 11;
        }
        for (n2 = 0; n2 < dictionaryArray.length; ++n2) {
            int n3 = 0;
            for (int i = poeStyleControlBlock.getElementsCount(); i > 0; --i) {
                String string = null;
                short s = binaryBlock.getShort(n3);
                try {
                    string = new String(binaryBlock.data, n3 + 2, (int)s, poeStyleControlBlock.getCharsetName());
                    n3 += s + 2;
                    if (n == 13) {
                        dictionaryArray[n2].addWord(string, dictionaryArray[n2].addFeatureSetGloss(0, 1, false, false, true, true));
                        continue;
                    }
                    if (n == 24) {
                        GlossCollection glossCollection = dictionaryArray[n2].lookupWord(new StringCharacterIterator(string), string.length());
                        if (glossCollection == null) continue;
                        Iterator iterator = glossCollection.iterator();
                        int n4 = 0;
                        while (iterator.hasNext()) {
                            Gloss gloss = (Gloss)iterator.next();
                            if (gloss instanceof LemmaGloss) {
                                String string2 = ((LemmaGloss)gloss).getValue();
                                int n5 = 26;
                                byte[] byArray = string2.getBytes(poeStyleControlBlock.getCharsetName());
                                if (binaryBlock2.data.length < 32 + byArray.length) {
                                    return 93;
                                }
                                binaryBlock2.setShort(n5, (short)byArray.length);
                                System.arraycopy(byArray, 0, binaryBlock2.data, n5 + 6, byArray.length);
                            }
                            ++n4;
                        }
                        return 73;
                    }
                    if (n != 21) continue;
                    dictionaryArray[n2].removeWord(string, null);
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return 109;
                }
                catch (DLTException dLTException) {
                    return 86;
                }
                catch (Throwable throwable) {
                    return 86;
                }
            }
        }
        return n == 24 ? (short)87 : 73;
    }

    private static short createDictionary(PoeStyleControlBlock poeStyleControlBlock, String string, BinaryBlock binaryBlock) {
        int n;
        File file = new File(string);
        Dictionary dictionary = null;
        int n2 = 0;
        DictionaryInfo dictionaryInfo = new DictionaryInfo();
        try {
            dictionary = Dictionary.createDictionary(file, dictionaryInfo);
            dictionary.registerType(15, "poeDictionary");
            dictionary.registerType(11, "poeDictionary");
        }
        catch (DLTException dLTException) {
            return 86;
        }
        for (n = 31; n < dictionaryPool.length; n = (int)((byte)(n + 2))) {
            if (dictionaryPool[n] != null) continue;
            PoeEntryPoint.dictionaryPool[n] = new DictionaryRef(dictionary);
            dictionaryPool[n].incRefCount();
            n2 = n;
            break;
        }
        if (n == dictionaryPool.length) {
            return 90;
        }
        binaryBlock.data[0] = n2;
        binaryBlock.data[1] = 12;
        binaryBlock.data[4] = poeStyleControlBlock.data[PoeStyleControlBlock.languageCodeOffset];
        binaryBlock.data[5] = poeStyleControlBlock.data[PoeStyleControlBlock.languageCodeOffset + 1];
        poeStyleControlBlock.setReplyUsed(6);
        return 73;
    }

    private static short spellAid(PoeStyleControlBlock poeStyleControlBlock, BinaryBlock binaryBlock, BinaryBlock binaryBlock2) {
        try {
            String[] stringArray;
            String string = new String(binaryBlock.data, 2, (int)binaryBlock.getShort(0), poeStyleControlBlock.getCharsetName());
            long l = System.currentTimeMillis();
            Dictionary[] dictionaryArray = PoeEntryPoint.extractDictionarySet(poeStyleControlBlock);
            if (dictionaryArray == null) {
                return 11;
            }
            AdvancedLookupDriver advancedLookupDriver = null;
            if (lastSpellAidDriver != null && PoeEntryPoint.lastSpellAidDriver.masters != null && PoeEntryPoint.lastSpellAidDriver.masters.length == dictionaryArray.length) {
                int n;
                for (n = 0; n < dictionaryArray.length && dictionaryArray[n] == PoeEntryPoint.lastSpellAidDriver.masters[n]; ++n) {
                }
                if (n == dictionaryArray.length) {
                    advancedLookupDriver = lastSpellAidDriver;
                }
            }
            if (advancedLookupDriver == null) {
                advancedLookupDriver = new AdvancedLookupDriver(dictionaryArray);
                for (Dictionary object : dictionaryArray) {
                    if (!object.getSummary().hasFunction(17)) continue;
                    advancedLookupDriver.setRules(object);
                    break;
                }
                lastSpellAidDriver = advancedLookupDriver;
            }
            if ((stringArray = advancedLookupDriver.match(string, 2, 6)) == null) {
                poeStyleControlBlock.setDelivered(0);
                poeStyleControlBlock.setReplyUsed(0);
                return 62;
            }
            int n = 0;
            binaryBlock2.data[n] = (byte)binaryBlock.getShort(0);
            System.arraycopy(binaryBlock.data, 2, binaryBlock2.data, ++n, binaryBlock.getShort(0));
            binaryBlock2.data[n += binaryBlock.getShort((int)0)] = 0;
            binaryBlock2.setShort(++n, (short)0);
            binaryBlock2.data[n += 2] = 0;
            binaryBlock2.data[++n] = (byte)stringArray.length;
            ++n;
            for (int i = 0; i < stringArray.length; ++i) {
                if (n >= binaryBlock2.data.length - 1) {
                    poeStyleControlBlock.setContReply();
                    break;
                }
                byte[] byArray = stringArray[i].getBytes(poeStyleControlBlock.getCharsetName());
                binaryBlock2.data[n] = (byte)byArray.length;
                System.arraycopy(byArray, 0, binaryBlock2.data, ++n, byArray.length);
                n += byArray.length;
            }
            poeStyleControlBlock.setDelivered(stringArray.length);
            poeStyleControlBlock.setReplyUsed(n);
            l = System.currentTimeMillis() - l;
            return 73;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 109;
        }
        catch (DLTException dLTException) {
            return 86;
        }
    }

    private static short spellCheck(PoeStyleControlBlock poeStyleControlBlock, BinaryBlock binaryBlock, BinaryBlock binaryBlock2) {
        try {
            int n;
            Object object;
            String string = new String(binaryBlock.data, 2, (int)binaryBlock.getShort(0), poeStyleControlBlock.getCharsetName());
            Dictionary[] dictionaryArray = PoeEntryPoint.extractDictionarySet(poeStyleControlBlock);
            if (dictionaryArray == null || dictionaryArray.length == 0) {
                return 11;
            }
            SpellCheckerSession spellCheckerSession = null;
            if (spellCheckerSession == null) {
                object = dictionaryArray[0].getSummary().getLanguages();
                for (n = 0; n < ((String[])object).length && "MWU".equals(object[n]); ++n) {
                }
                if (n >= ((String[])object).length) {
                    return 11;
                }
                spellCheckerSession = new SpellCheckerSession(dictionaryArray, (String)object[n]);
            }
            spellCheckerSession.open();
            object = spellCheckerSession.checkSpelling(string);
            spellCheckerSession.close();
            if (!poeStyleControlBlock.isLXBlockFormat()) {
                poeStyleControlBlock.setDelivered(0);
                if (object.isEmpty() || PoeEntryPoint.ignoreMisspelling((MisspeltWord)object.get(0))) {
                    return 73;
                }
                return 87;
            }
            if (binaryBlock2.data.length <= PoeStyleControlBlock.elementStrictSize * object.size()) {
                poeStyleControlBlock.setDelivered(0);
                poeStyleControlBlock.setReplyUsed(0);
                return 93;
            }
            n = 0;
            int n2 = poeStyleControlBlock.getPOEStyleCodePage() == 13488 ? 2 : 1;
            byte[] byArray = string.getBytes(poeStyleControlBlock.getCharsetName());
            int n3 = 0;
            ListIterator listIterator = object.listIterator();
            while (listIterator.hasNext()) {
                int n4;
                MisspeltWord misspeltWord = (MisspeltWord)listIterator.next();
                if (PoeEntryPoint.ignoreMisspelling(misspeltWord)) continue;
                binaryBlock2.setInt(n, misspeltWord.start * n2);
                n += 4;
                for (n4 = 0; n4 < PoeStyleControlBlock.pointerSize - 4; ++n4) {
                    binaryBlock2.data[n++] = 0;
                }
                binaryBlock2.setInt(n, 0);
                n += 4;
                for (n4 = 0; n4 < PoeStyleControlBlock.pointerSize - 4; ++n4) {
                    binaryBlock2.data[n++] = 0;
                }
                binaryBlock2.setShort(n, (short)((misspeltWord.end - misspeltWord.start) * n2));
                binaryBlock2.setShort(n += 2, (short)87);
                binaryBlock2.data[n += 2] = 0;
                binaryBlock2.data[n + 1] = 0;
                binaryBlock2.data[n += 2] = misspeltWord.end < byArray.length ? byArray[misspeltWord.end] : (byte)0;
                binaryBlock2.data[++n] = 0;
                if (PoeStyleControlBlock.pointerSize == 16 && ++n % 16 > 0) {
                    n += 16 - n % 16;
                }
                if (n % PoeStyleControlBlock.elementStrictSize != 0) {
                    poeStyleControlBlock.setReplyUsed(0);
                    return 86;
                }
                ++n3;
            }
            poeStyleControlBlock.setReplyUsed(n);
            poeStyleControlBlock.setDelivered(n3);
            return 73;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 109;
        }
        catch (Throwable throwable) {
            return 86;
        }
    }

    private static boolean ignoreMisspelling(MisspeltWord misspeltWord) {
        int n = misspeltWord.type;
        switch (n) {
            case 1: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 109: {
                return true;
            }
        }
        return false;
    }

    static short dictionaryActivate(PoeStyleControlBlock poeStyleControlBlock, String string, BinaryBlock binaryBlock) {
        int n;
        DictionaryRef dictionaryRef = null;
        int n2 = 0;
        short s = 73;
        File file = new File(string);
        for (n = 30; n < dictionaryPool.length; n = (int)((byte)(n + 1))) {
            if (dictionaryPool[n] == null || !dictionaryPool[n].getFile().equals(file)) continue;
            dictionaryRef = dictionaryPool[n];
            n2 = n;
            break;
        }
        for (n = 0; n < 2; n = (int)((byte)(n + 1))) {
            if (dictionaryPool[n] == null || !dictionaryPool[n].getFile().equals(file)) continue;
            dictionaryRef = dictionaryPool[n];
            break;
        }
        if (dictionaryRef == null) {
            try {
                dictionaryRef = new DictionaryRef(new Dictionary(file, 1));
            }
            catch (Throwable throwable) {
                s = 9;
            }
        }
        if (n2 == 0 && s == 73) {
            for (n = 30; n < dictionaryPool.length; n = (int)((byte)(n + 2))) {
                if (dictionaryPool[n] != null) continue;
                PoeEntryPoint.dictionaryPool[n] = dictionaryRef;
                n2 = n;
                break;
            }
        }
        if (n == dictionaryPool.length) {
            s = 90;
        }
        String[] stringArray = null;
        if (s == 73) {
            dictionaryRef.incRefCount();
            try {
                stringArray = dictionaryRef.getDictionary().getLanguages();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        short s2 = 0;
        if (stringArray != null) {
            s2 = PoeStyleControlBlock.getPoeLangCode(stringArray[0]);
        }
        binaryBlock.data[0] = n2;
        binaryBlock.data[1] = 12;
        binaryBlock.setShort(4, s2);
        poeStyleControlBlock.setReplyUsed(6 + PoeStyleControlBlock.pointerSize);
        return s;
    }

    private static short dictionaryDeActivate(PoeStyleControlBlock poeStyleControlBlock, BinaryBlock binaryBlock) {
        byte[] byArray = poeStyleControlBlock.getDictTokens();
        if (byArray == null) {
            return 11;
        }
        if (byArray.length == 0) {
            return 12;
        }
        byte by = byArray[0];
        if (by % 2 == 0) {
            PoeEntryPoint.dictionaryPool[PoeEntryPoint.dictCacheIndex] = dictionaryPool[by];
            dictCacheIndex = ++dictCacheIndex == 2 ? 0 : dictCacheIndex;
        }
        dictionaryPool[by].decRefCount();
        if (!dictionaryPool[by].isReferenced()) {
            PoeEntryPoint.dictionaryPool[by] = null;
        }
        return 73;
    }

    static Dictionary[] extractDictionarySet(PoeStyleControlBlock poeStyleControlBlock) {
        byte[] byArray = poeStyleControlBlock.getDictTokens();
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return null;
        }
        Dictionary[] dictionaryArray = new Dictionary[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] < 30) continue;
            if (byArray[i] >= dictionaryPool.length) {
                return null;
            }
            dictionaryArray[i] = dictionaryPool[byArray[i]].getDictionary();
            if (dictionaryArray[i] != null) continue;
            return null;
        }
        return dictionaryArray;
    }

    private static class DictionaryRef {
        private final Dictionary _dict;
        private int _refCount;

        DictionaryRef(Dictionary dictionary) {
            this._dict = dictionary;
            this._refCount = 0;
        }

        void incRefCount() {
            ++this._refCount;
        }

        void decRefCount() {
            --this._refCount;
        }

        boolean isReferenced() {
            return this._refCount > 0;
        }

        File getFile() {
            return this._dict.getFile();
        }

        Dictionary getDictionary() {
            return this._dict;
        }
    }
}

