/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.poe;

import com.ibm.dltj.poe.BinaryBlock;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class PoeStyleControlBlock
extends BinaryBlock {
    static short dictFileNamesOffset = (short)-1;
    static short deliveredOutunitsOffset = (short)-1;
    static short replyUsedsOffset = (short)-1;
    static short functionCodeOffset = (short)-1;
    static short elementsCountOffset = (short)-1;
    static short codepageNumberOffset = (short)-1;
    static short dictTokensOffset = (short)-1;
    static short languageCodeOffset = (short)-1;
    static short dictTokenCtOffset = (short)-1;
    static short contReplyFlagOffset = (short)-1;
    static short eltFormatOffset = (short)-1;
    static short requestTypeOffset = (short)-1;
    private static final String USASCII = "US-ASCII";
    private static final String ISO88591 = "ISO-8859-1";
    private static final String UTF16 = "UTF-16";
    private static final String LATIN1 = "LATIN1";
    private static final String os400 = "OS/400";
    private static final String archPPC = "ppc";
    private static final String archPPC2 = "PowerPC";
    private static final String archPPC64 = "ppc64";
    private static boolean offsetInit = false;
    static int pointerSize = -1;
    private static int longSize = 4;
    public static int elementStrictSize = -1;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static void init() {
        if (!offsetInit) {
            String string = System.getProperty("os.name");
            String string2 = System.getProperty("os.arch");
            String string3 = System.getProperty("sun.arch.data.model");
            if (string.equalsIgnoreCase(os400) && (string2.equalsIgnoreCase(archPPC) || string2.equalsIgnoreCase(archPPC2))) {
                dictFileNamesOffset = (short)160;
                deliveredOutunitsOffset = (short)272;
                replyUsedsOffset = (short)312;
                functionCodeOffset = (short)346;
                elementsCountOffset = (short)344;
                codepageNumberOffset = (short)356;
                dictTokensOffset = (short)444;
                languageCodeOffset = (short)350;
                dictTokenCtOffset = (short)340;
                contReplyFlagOffset = (short)421;
                eltFormatOffset = (short)506;
                requestTypeOffset = (short)362;
                pointerSize = 16;
                elementStrictSize = 48;
            } else if ("64".equals(string3)) {
                if (string2.equalsIgnoreCase(archPPC64)) {
                    longSize = 8;
                    dictFileNamesOffset = (short)80;
                    deliveredOutunitsOffset = (short)136;
                    replyUsedsOffset = (short)160;
                    functionCodeOffset = (short)194;
                    elementsCountOffset = (short)192;
                    codepageNumberOffset = (short)204;
                    dictTokensOffset = (short)292;
                    languageCodeOffset = (short)198;
                    dictTokenCtOffset = (short)188;
                    contReplyFlagOffset = (short)269;
                    eltFormatOffset = (short)354;
                    requestTypeOffset = (short)210;
                } else {
                    dictFileNamesOffset = (short)80;
                    deliveredOutunitsOffset = (short)136;
                    replyUsedsOffset = (short)152;
                    functionCodeOffset = (short)186;
                    elementsCountOffset = (short)184;
                    codepageNumberOffset = (short)196;
                    dictTokensOffset = (short)284;
                    languageCodeOffset = (short)190;
                    dictTokenCtOffset = (short)180;
                    contReplyFlagOffset = (short)261;
                    eltFormatOffset = (short)346;
                    requestTypeOffset = (short)202;
                }
                pointerSize = 8;
                elementStrictSize = 24;
            } else {
                dictFileNamesOffset = (short)44;
                deliveredOutunitsOffset = (short)72;
                replyUsedsOffset = (short)88;
                functionCodeOffset = (short)122;
                elementsCountOffset = (short)120;
                codepageNumberOffset = (short)132;
                dictTokensOffset = (short)220;
                languageCodeOffset = (short)126;
                dictTokenCtOffset = (short)116;
                contReplyFlagOffset = (short)197;
                eltFormatOffset = (short)282;
                requestTypeOffset = (short)138;
                pointerSize = 4;
                elementStrictSize = 16;
            }
            offsetInit = true;
        }
    }

    public PoeStyleControlBlock(byte[] byArray, boolean bl) {
        super(byArray, bl);
    }

    public short getFunctionCode() {
        return this.getShort(functionCodeOffset);
    }

    public short getElementsCount() {
        return this.getShort(elementsCountOffset);
    }

    public short getPOEStyleCodePage() {
        return this.getShort(codepageNumberOffset);
    }

    public String getCharsetName() throws UnsupportedEncodingException {
        short s = this.getShort(codepageNumberOffset);
        switch (s) {
            case 13488: {
                return UTF16;
            }
            case 367: {
                return USASCII;
            }
            case 850: {
                return ISO88591;
            }
            case 1275: {
                return LATIN1;
            }
        }
        if (Charset.isSupported("cp" + s)) {
            return "cp" + s;
        }
        if (Charset.isSupported("cp0" + s)) {
            return "cp0" + s;
        }
        if (Charset.isSupported("" + s)) {
            return "" + s;
        }
        throw new UnsupportedEncodingException();
    }

    public byte[] getDictTokens() {
        short s = this.getShort(dictTokenCtOffset);
        if (s > 20) {
            return null;
        }
        byte[] byArray = new byte[s];
        System.arraycopy(this.data, dictTokensOffset, byArray, 0, s);
        return byArray;
    }

    public String getDictFileName() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = dictFileNamesOffset;
        while (this.data[n] != 0) {
            stringBuffer.append((char)this.data[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isLXBlockFormat() {
        return this.data[eltFormatOffset] == 0;
    }

    public void setDelivered(int n) {
        if (longSize == 8) {
            this.setLong8(deliveredOutunitsOffset, n);
        } else {
            this.setInt(deliveredOutunitsOffset, n);
        }
    }

    public void setReplyUsed(int n) {
        this.setInt(replyUsedsOffset, n);
    }

    public void setContReply() {
        this.data[PoeStyleControlBlock.contReplyFlagOffset] = 1;
    }

    public short getRequestType() {
        return this.getShort(requestTypeOffset);
    }

    public static short getPoeLangCode(String string) {
        if (string == null) {
            return 0;
        }
        String string2 = string.toLowerCase();
        if (string2.startsWith("en")) {
            if (string2.indexOf("us") > 0) {
                return 6011;
            }
            if (string2.indexOf("uk") > 0) {
                return 5997;
            }
        }
        if (string2.startsWith("fr")) {
            if (string2.indexOf("ca") > 0) {
                return 7013;
            }
            return 7011;
        }
        if (string2.startsWith("pt")) {
            if (string2.indexOf("br") > 0) {
                return 16072;
            }
            return 16077;
        }
        if (string2.startsWith("fi")) {
            return 6754;
        }
        if (string2.startsWith("it")) {
            return 9771;
        }
        if (string2.startsWith("es")) {
            return 6156;
        }
        if (string2.startsWith("fi")) {
            return 6754;
        }
        if (string2.startsWith("de")) {
            return 4841;
        }
        return 0;
    }
}

