/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.feature;

import com.ibm.dltj.tagger.feature.CompoundTag;
import com.ibm.dltj.tagger.feature.Tag;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;

public class CompoundTagFactory<T extends Enum<T>> {
    protected final Class<T> eType;
    protected final T[] eList;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected CompoundTagFactory(Class<T> clazz) {
        assert (clazz != null);
        this.eType = clazz;
        this.eList = (Enum[])clazz.getEnumConstants();
    }

    public static final <T extends Enum<T>> CompoundTagFactory<T> newInstance(Class<T> clazz) {
        return new CompoundTagFactory<T>(clazz);
    }

    public CompoundTag<T> create() {
        return this.create(new Tag[0]);
    }

    public Tag create(List<? extends Tag> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        if (this.eList.length < 32) {
            return new SmallCompoundTag(list);
        }
        if (this.eList.length < 64) {
            return new MediumCompoundTag(list);
        }
        return new HugeCompoundTag(list.toArray(new Tag[list.size()]));
    }

    public CompoundTag<T> create(Tag ... tagArray) {
        if (this.eList.length < 32) {
            return new SmallCompoundTag(tagArray);
        }
        if (this.eList.length < 64) {
            return new MediumCompoundTag(tagArray);
        }
        return new HugeCompoundTag(tagArray);
    }

    protected static String toString(CompoundTag<?> compoundTag) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Tag tag : compoundTag.split()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("_");
            }
            stringBuilder.append(tag.toString());
        }
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    final class HugeCompoundTag
    implements CompoundTag<T> {
        private Tag[] element;

        public HugeCompoundTag(Tag[] tagArray) {
            int n;
            Arrays.sort(tagArray);
            int n2 = 0;
            for (n = 0; n < tagArray.length - 1; ++n) {
                if (tagArray[n] != tagArray[n + 1]) continue;
                tagArray[n] = null;
                ++n2;
            }
            if (n2 == 0) {
                this.element = tagArray;
                return;
            }
            n = 0;
            this.element = new Tag[tagArray.length - n2];
            for (Tag tag : tagArray) {
                if (tag == null) continue;
                this.element[n++] = tag;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.element.length == 0;
        }

        @Override
        public boolean contains(Tag tag) {
            Class<?> clazz = tag.getClass();
            if (CompoundTagFactory.this.eType.isAssignableFrom(clazz)) {
                for (Tag tag2 : this.element) {
                    if (tag2 != tag) continue;
                    return true;
                }
                return false;
            }
            if (clazz == this.getClass()) {
                Tag[] tagArray = ((HugeCompoundTag)tag).element;
                Tag[] tagArray2 = this.element;
                for (int i = 0; i < tagArray.length; ++i) {
                    int n;
                    for (n = 0; n < tagArray2.length && tagArray[i] != tagArray2[n]; ++n) {
                    }
                    if (n != tagArray2.length) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isAmbiguous() {
            return this.element.length > 1;
        }

        @Override
        public void add(Tag tag) {
            Class<?> clazz = tag.getClass();
            if (CompoundTagFactory.this.eType.isAssignableFrom(clazz)) {
                for (Tag tag2 : this.element) {
                    if (tag2 != tag) continue;
                    return;
                }
                Object[] objectArray = new Tag[this.element.length + 1];
                System.arraycopy(this.element, 0, objectArray, 0, this.element.length);
                objectArray[objectArray.length - 1] = tag;
                Arrays.sort(objectArray);
                this.element = objectArray;
                return;
            }
            if (clazz == this.getClass()) {
                for (Tag tag3 : ((HugeCompoundTag)tag).element) {
                    this.add(tag3);
                }
                return;
            }
            throw new IllegalArgumentException(clazz.getName());
        }

        @Override
        public Tag first() {
            if (this.element.length == 0) {
                throw new NoSuchElementException();
            }
            return this.element[0];
        }

        @Override
        public Tag last() {
            if (this.element.length == 0) {
                throw new NoSuchElementException();
            }
            return this.element[this.element.length - 1];
        }

        @Override
        public Tag[] split() {
            return this.element;
        }

        @Override
        public Tag selectRandom() {
            Tag[] tagArray = this.split();
            int n = new Random().nextInt(tagArray.length);
            return tagArray[n];
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + Arrays.hashCode(this.element);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HugeCompoundTag hugeCompoundTag = (HugeCompoundTag)object;
            return this.element == hugeCompoundTag.element || Arrays.equals(this.element, hugeCompoundTag.element);
        }

        public String toString() {
            return CompoundTagFactory.toString(this);
        }

        @Override
        public void clear() {
            this.element = new Tag[0];
        }
    }

    final class MediumCompoundTag
    implements CompoundTag<T> {
        private long element;

        public MediumCompoundTag(Tag[] tagArray) {
            for (Tag tag : tagArray) {
                this.add(tag);
            }
        }

        public MediumCompoundTag(Collection<? extends Tag> collection) {
            for (Tag tag : collection) {
                this.add(tag);
            }
        }

        private long encode(Tag tag) {
            return 1L << ((Enum)((Object)tag)).ordinal();
        }

        @Override
        public boolean isEmpty() {
            return this.element == 0L;
        }

        @Override
        public boolean contains(Tag tag) {
            long l = 0L;
            Class<?> clazz = tag.getClass();
            if (CompoundTagFactory.this.eType.isAssignableFrom(clazz)) {
                l = this.encode(tag);
            } else if (clazz == this.getClass()) {
                l = ((MediumCompoundTag)tag).element;
            }
            return (this.element & l) == l;
        }

        @Override
        public boolean isAmbiguous() {
            return (this.element & this.element - 1L) != 0L;
        }

        @Override
        public void add(Tag tag) {
            Class<?> clazz = tag.getClass();
            if (CompoundTagFactory.this.eType.isAssignableFrom(clazz)) {
                this.element |= this.encode(tag);
                return;
            }
            if (clazz == this.getClass()) {
                this.element |= ((MediumCompoundTag)tag).element;
                return;
            }
            throw new IllegalArgumentException(clazz.getName());
        }

        @Override
        public Tag first() {
            if (this.element == 0L) {
                throw new NoSuchElementException();
            }
            return (Tag)CompoundTagFactory.this.eList[Long.numberOfTrailingZeros(this.element)];
        }

        @Override
        public Tag last() {
            if (this.element == 0L) {
                throw new NoSuchElementException();
            }
            return (Tag)CompoundTagFactory.this.eList[64 - Long.numberOfLeadingZeros(this.element) - 1];
        }

        @Override
        public Tag[] split() {
            Tag[] tagArray = new Tag[Long.bitCount(this.element)];
            long l = this.element;
            int n = 0;
            int n2 = 0;
            while (n < 64) {
                if ((l & 1L) != 0L) {
                    tagArray[n2++] = (Tag)CompoundTagFactory.this.eList[n];
                }
                ++n;
                l >>>= 1;
            }
            return tagArray;
        }

        @Override
        public Tag selectRandom() {
            Tag[] tagArray = this.split();
            int n = new Random().nextInt(tagArray.length);
            return tagArray[n];
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (int)(this.element ^ this.element >>> 32);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MediumCompoundTag mediumCompoundTag = (MediumCompoundTag)object;
            return this.element == mediumCompoundTag.element;
        }

        public String toString() {
            return CompoundTagFactory.toString(this);
        }

        @Override
        public void clear() {
            this.element = 0L;
        }
    }

    final class SmallCompoundTag
    implements CompoundTag<T> {
        private int element;

        public SmallCompoundTag(Tag[] tagArray) {
            for (Tag tag : tagArray) {
                this.add(tag);
            }
        }

        public SmallCompoundTag(Collection<? extends Tag> collection) {
            for (Tag tag : collection) {
                this.add(tag);
            }
        }

        private int encode(Tag tag) {
            return 1 << ((Enum)((Object)tag)).ordinal();
        }

        @Override
        public boolean isEmpty() {
            return this.element == 0;
        }

        @Override
        public boolean contains(Tag tag) {
            int n = 0;
            Class<?> clazz = tag.getClass();
            if (CompoundTagFactory.this.eType.isAssignableFrom(clazz)) {
                n = this.encode(tag);
            } else if (clazz == this.getClass()) {
                n = ((SmallCompoundTag)tag).element;
            }
            return (this.element & n) == n;
        }

        @Override
        public boolean isAmbiguous() {
            return (this.element & this.element - 1) != 0;
        }

        @Override
        public void add(Tag tag) {
            Class<?> clazz = tag.getClass();
            if (CompoundTagFactory.this.eType.isAssignableFrom(clazz)) {
                this.element |= this.encode(tag);
                return;
            }
            if (clazz == this.getClass()) {
                this.element |= ((SmallCompoundTag)tag).element;
                return;
            }
            throw new IllegalArgumentException(clazz.getName());
        }

        @Override
        public Tag first() {
            if (this.element == 0) {
                throw new NoSuchElementException();
            }
            return (Tag)CompoundTagFactory.this.eList[Integer.numberOfTrailingZeros(this.element)];
        }

        @Override
        public Tag last() {
            if (this.element == 0) {
                throw new NoSuchElementException();
            }
            return (Tag)CompoundTagFactory.this.eList[32 - Integer.numberOfLeadingZeros(this.element) - 1];
        }

        @Override
        public Tag[] split() {
            Tag[] tagArray = new Tag[Integer.bitCount(this.element)];
            int n = this.element;
            int n2 = 0;
            int n3 = 0;
            while (n2 < 32) {
                if ((n & 1) != 0) {
                    tagArray[n3++] = (Tag)CompoundTagFactory.this.eList[n2];
                }
                ++n2;
                n >>>= 1;
            }
            return tagArray;
        }

        @Override
        public Tag selectRandom() {
            Tag[] tagArray = this.split();
            int n = new Random().nextInt(tagArray.length);
            return tagArray[n];
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.element;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SmallCompoundTag smallCompoundTag = (SmallCompoundTag)object;
            return this.element == smallCompoundTag.element;
        }

        public String toString() {
            return CompoundTagFactory.toString(this);
        }

        @Override
        public void clear() {
            this.element = 0;
        }
    }
}

