/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.feature;

import com.ibm.dltj.Messages;
import com.ibm.dltj.tagger.TagHandler;
import com.ibm.dltj.tagger.feature.CompoundTag;
import com.ibm.dltj.tagger.feature.CompoundTagFactory;
import com.ibm.dltj.tagger.feature.Tag;
import java.util.HashMap;
import java.util.Map;

public class DefaultTagHandler<T extends Enum<T>>
implements TagHandler<Tag> {
    protected final Class<T> type;
    protected final Map<String, Tag> map = new HashMap<String, Tag>();
    protected final CompoundTagFactory<T> factory;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public DefaultTagHandler(Class<T> clazz) {
        if (!Enum.class.isAssignableFrom(clazz)) {
            throw new UnsupportedOperationException(Messages.format("error.tag.unsupported", clazz));
        }
        this.type = clazz;
        this.factory = CompoundTagFactory.newInstance(clazz);
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            this.map.put(enum_.name(), (Tag)((Object)enum_));
            this.map.put(enum_.toString(), (Tag)((Object)enum_));
        }
    }

    @Override
    public Class<? extends Enum<?>> getType() {
        return this.type;
    }

    @Override
    public Tag getStartTag() {
        return this.map.get("START");
    }

    @Override
    public Tag getFinalTag() {
        return this.map.get("FINAL");
    }

    @Override
    public Tag getUnknownTag() {
        Tag tag = this.map.get("UNKNOWN");
        if (tag != null) {
            return tag;
        }
        return this.map.get("UKW");
    }

    @Override
    public boolean isAmbiguous(Tag tag) {
        return tag instanceof CompoundTag && ((CompoundTag)tag).isAmbiguous();
    }

    @Override
    public Tag first(Tag tag) {
        CompoundTag compoundTag;
        if (tag instanceof CompoundTag && !(compoundTag = (CompoundTag)tag).isEmpty()) {
            return compoundTag.first();
        }
        return tag;
    }

    @Override
    public Tag last(Tag tag) {
        CompoundTag compoundTag;
        if (tag instanceof CompoundTag && !(compoundTag = (CompoundTag)tag).isEmpty()) {
            return compoundTag.last();
        }
        return tag;
    }

    @Override
    public Tag selectRandom(Tag tag) {
        if (this.isAmbiguous(tag)) {
            return ((CompoundTag)tag).selectRandom();
        }
        return tag;
    }

    @Override
    public Tag parse(String string) {
        if (string.contains("_")) {
            return this.parse(string.split("_"));
        }
        Tag tag = this.map.get(string);
        if (tag == null) {
            throw new IllegalArgumentException(Messages.format("error.tag.illegal", string));
        }
        return tag;
    }

    @Override
    public Tag parse(String[] stringArray) {
        if (stringArray.length > 1) {
            Tag[] tagArray = new Tag[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Tag tag = this.map.get(stringArray[i]);
                if (tag == null) {
                    throw new IllegalArgumentException(stringArray[i]);
                }
                tagArray[i] = tag;
            }
            return this.factory.create(tagArray);
        }
        Tag tag = this.map.get(stringArray[0]);
        if (tag == null) {
            throw new IllegalArgumentException(stringArray[0]);
        }
        return tag;
    }

    public Tag[] split(Tag tag) {
        if (tag instanceof CompoundTag) {
            return ((CompoundTag)tag).split();
        }
        return new Tag[]{tag};
    }

    @Override
    public boolean contains(Tag tag, Tag tag2) {
        return tag == tag2 || tag instanceof CompoundTag && ((CompoundTag)tag).contains(tag2);
    }

    @Override
    public String toString(Tag tag) {
        if (tag instanceof CompoundTag) {
            Tag[] tagArray = ((CompoundTag)tag).split();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < tagArray.length; ++i) {
                stringBuilder.append(tagArray[i].toString());
                if (i == tagArray.length - 1) continue;
                stringBuilder.append("_");
            }
            stringBuilder.trimToSize();
            return stringBuilder.toString();
        }
        return tag.toString();
    }
}

