/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.feature;

import com.ibm.dltj.tagger.TagHandler;
import java.util.Random;

public class RawTagHandler
implements TagHandler<String> {
    private final String _startTag;
    private final String _finalTag;
    private final String _unknownTag;
    private final String _delimiter;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public RawTagHandler() {
        this("0", "0", "0", ",");
    }

    public RawTagHandler(String string, String string2, String string3, String string4) {
        this._startTag = string;
        this._finalTag = string2;
        this._unknownTag = string3;
        this._delimiter = string4;
    }

    @Override
    public Class<?> getType() {
        return String.class;
    }

    @Override
    public String getStartTag() {
        return this._startTag;
    }

    @Override
    public String getFinalTag() {
        return this._finalTag;
    }

    @Override
    public String getUnknownTag() {
        return this._unknownTag;
    }

    @Override
    public boolean isAmbiguous(String string) {
        return this._delimiter != null && string.contains(this._delimiter);
    }

    @Override
    public String first(String string) {
        int n;
        if (this._delimiter != null && (n = string.indexOf(this._delimiter)) > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    @Override
    public String last(String string) {
        int n;
        if (this._delimiter != null && (n = string.lastIndexOf(this._delimiter)) + 1 < string.length()) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Override
    public String selectRandom(String string) {
        String[] stringArray;
        if (this._delimiter != null && string.contains(this._delimiter) && (stringArray = this.split(string)).length > 0) {
            int n = new Random().nextInt(stringArray.length);
            return stringArray[n];
        }
        return string;
    }

    @Override
    public String parse(String string) {
        return string;
    }

    @Override
    public String parse(String[] stringArray) {
        if (stringArray.length == 0) {
            return stringArray[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (this._delimiter == null || i >= stringArray.length - 1) continue;
            stringBuilder.append(this._delimiter);
        }
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    public String[] split(String string) {
        if (this._delimiter != null && string.contains(this._delimiter)) {
            return string.split(this._delimiter);
        }
        return new String[]{string};
    }

    @Override
    public boolean contains(String string, String string2) {
        return string.indexOf(string2) >= 0;
    }

    @Override
    public String toString(String string) {
        return string;
    }
}

