/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.tagger.Tagger;
import com.ibm.dltj.tagger.TaggerDictionary;
import com.ibm.dltj.tagger.Token;
import com.ibm.dltj.tagger.impl.DLTTaggerDictionary;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class AbstractTagger<G, T>
implements Tagger<G, T> {
    protected URL url;
    private String text;
    String[] token;
    G[] gloss;
    T[] tag;
    BitSet skip;
    protected int size = 0;
    protected Map<String, Object> map;
    protected TaggerDictionary dictionary;
    protected static final Logger logger = Logger.getLogger(AbstractTagger.class.getName());

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected AbstractTagger() {
    }

    @Override
    public void open(URL uRL) throws IOException {
        this.open(uRL, 16);
    }

    protected void open(URL uRL, int n) throws IOException {
        this.url = uRL;
        this.token = new String[n];
        this.gloss = new Object[n];
        this.tag = new Object[n];
        this.skip = new BitSet(n);
        this.size = 0;
        this.text = null;
        this.map = new HashMap<String, Object>();
        this.dictionary = new DLTTaggerDictionary(uRL);
    }

    @Override
    public void save() throws IOException {
        this.dictionary.save();
    }

    @Override
    public void close() throws IOException {
        this.url = null;
        this.token = null;
        this.gloss = null;
        this.tag = null;
        this.skip = null;
        this.size = 0;
        this.text = null;
        this.map = null;
        if (this.dictionary != null) {
            this.dictionary.close();
        }
        this.dictionary = null;
    }

    @Override
    public void clear() {
        Arrays.fill(this.token, 0, this.size, null);
        Arrays.fill(this.gloss, 0, this.size, null);
        Arrays.fill(this.tag, 0, this.size, null);
        this.skip.clear();
        this.size = 0;
        this.text = null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Level getLevel() {
        return logger.getLevel();
    }

    @Override
    public void setLevel(Level level) {
        logger.setLevel(level);
    }

    @Override
    public <V> V getFeature(String string) {
        return (V)this.map.get(string);
    }

    @Override
    public <V> void setFeature(String string, V v) {
        this.map.put(string, v);
    }

    @Override
    public boolean hasFeature(String string) {
        return this.map.containsKey(string);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String string) {
        this.text = string;
    }

    @Override
    public void setAnnotation(int n, int n2, G g) {
        this.setAnnotation(n, n2, g, null);
    }

    @Override
    public void setAnnotation(int n, int n2, G g, T t) {
        int n3 = this.size++;
        this.ensureCapacity(n3);
        this.token[n3] = this.text.substring(n, n2);
        this.gloss[n3] = g;
        this.tag[n3] = t;
    }

    protected final String text(int n) {
        return this.token[n];
    }

    @Override
    public Iterator<Token<G, T>> iterator() {
        return new Iterator<Token<G, T>>(){
            int pivot = -1;

            @Override
            public boolean hasNext() {
                return this.pivot + 1 < AbstractTagger.this.size;
            }

            @Override
            public Token<G, T> next() {
                ++this.pivot;
                return new Token<G, T>(){

                    @Override
                    public String getText() {
                        return AbstractTagger.this.token[pivot];
                    }

                    @Override
                    public G getGloss() {
                        return AbstractTagger.this.gloss[pivot];
                    }

                    @Override
                    public T getTag() {
                        return AbstractTagger.this.tag[pivot];
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void ensureCapacity(int n) {
        int n2;
        if (n < this.token.length) {
            return;
        }
        for (n2 = this.token.length; n2 <= n; n2 *= 2) {
        }
        this.token = AbstractTagger.resize(this.token, n2);
        this.gloss = AbstractTagger.resize(this.gloss, n2);
        this.tag = AbstractTagger.resize(this.tag, n2);
    }

    protected static <T> T resize(T t, int n) {
        Object object = Array.newInstance(t.getClass().getComponentType(), n);
        System.arraycopy(t, 0, object, 0, Math.min(Array.getLength(t), n));
        return (T)object;
    }
}

