/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.tagger.TagHandler;
import com.ibm.dltj.tagger.impl.AbstractTagger;
import com.ibm.dltj.tagger.impl.MappingBook;
import com.ibm.dltj.tagger.impl.Pair;
import com.ibm.dltj.tagger.impl.PretagBook;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class BasicAssumptionTrainer<T>
extends AbstractTagger<T, T> {
    protected PretagBook<T> pretag;
    protected MappingBook<T, T> mapping;
    protected TagHandler<T> handler;
    protected int MAX_NUMBER_OF_PRETAG_WORD = 10;
    protected int THRESHOLD_FOR_PRETAG_WORD = 20;
    protected int MAX_NUMBER_OF_TAG_MAPPING = 10;
    protected int THRESHOLD_FOR_TAG_MAPPING = 10;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    protected void open(URL uRL, int n) throws IOException {
        super.open(uRL, n);
        File file = new File(URI.create(this.url.toString()));
        if (file.exists()) {
            this.dictionary.open();
        }
        this.pretag = (PretagBook)this.dictionary.getResource("pretag.lst");
        if (this.pretag == null) {
            this.pretag = new PretagBook("pretag.lst");
            this.dictionary.addResource(this.pretag.getId(), this.pretag);
        } else {
            this.pretag.clear();
        }
        this.mapping = (MappingBook)this.dictionary.getResource("mapping.lst");
        if (this.mapping == null) {
            this.mapping = new MappingBook("mapping.lst");
            this.dictionary.addResource(this.mapping.getId(), this.mapping);
        } else {
            this.mapping.clear();
        }
    }

    @Override
    public void save() throws IOException {
        super.save();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.pretag = null;
        this.mapping = null;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.pretag != null) {
            this.pretag.clear();
        }
        if (this.mapping != null) {
            this.mapping.clear();
        }
    }

    @Override
    public <V> void setFeature(String string, V v) {
        super.setFeature(string, v);
        if (string.equals("com.ibm.dltj.tagger.properites.basic-assumption.max-number-of-pretag-word")) {
            this.MAX_NUMBER_OF_PRETAG_WORD = (Integer)v;
        } else if (string.equals("com.ibm.dltj.tagger.properites.basic-assumption.threshold-for-pretag-word")) {
            this.THRESHOLD_FOR_PRETAG_WORD = (Integer)v;
        } else if (string.equals("com.ibm.dltj.tagger.properites.basic-assumption.max-number-of-tag-mapping")) {
            this.MAX_NUMBER_OF_TAG_MAPPING = (Integer)v;
        } else if (string.equals("com.ibm.dltj.tagger.properites.basic-assumption.threshold-for-tag-mapping")) {
            this.THRESHOLD_FOR_TAG_MAPPING = (Integer)v;
        } else if (string.equals("com.ibm.dltj.tagger.properites.basic-assumption.tag-handler")) {
            this.handler = (TagHandler)v;
            this.pretag.setHandler(this.handler);
            this.mapping.setInputHandler(this.handler);
            this.mapping.setOutputHandler(this.handler);
        } else if (string.equals("com.ibm.dltj.tagger.dictionary.name")) {
            this.dictionary.getDescription().setName((String)v);
        } else if (string.equals("com.ibm.dltj.tagger.dictionary.provider")) {
            this.dictionary.getDescription().setProvider((String)v);
        } else if (string.equals("com.ibm.dltj.tagger.dictionary.copyright")) {
            this.dictionary.getDescription().setCopyrightStatement((String)v);
        } else if (string.equals("com.ibm.dltj.tagger.dictionary.build-number")) {
            this.dictionary.getDescription().setBuildNumber((String)v);
        }
    }

    @Override
    public void process() throws DLTException {
        this.process_pretag();
        for (int i = 0; i < this.size; ++i) {
            T t = this.pretag.get(this.text(i));
            if (t == null) continue;
            this.gloss[i] = t;
            this.tag[i] = t;
        }
        this.process_mapping();
    }

    /*
     * WARNING - void declaration
     */
    private void process_pretag() {
        void var4_11;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.size; ++i) {
            object2 = this.text(i);
            HashMap i2 = (HashMap)hashMap.get(object2);
            if (i2 == null) {
                HashMap hashMap2 = new HashMap();
                hashMap.put(object2, hashMap2);
            }
            for (Object object3 : this.handler.split(this.tag[i])) {
                void hashMap2;
                Integer n = (Integer)hashMap2.get(object3);
                if (n == null) {
                    hashMap2.put(object3, 1);
                    continue;
                }
                hashMap2.put(object3, n + 1);
            }
        }
        HashMap<Object, Pair<Object, Integer>> hashMap3 = new HashMap<Object, Pair<Object, Integer>>();
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            HashMap hashMap4 = (HashMap)entry.getValue();
            if (hashMap4.keySet().size() <= 1) continue;
            Object k = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (Map.Entry entry2 : hashMap4.entrySet()) {
                Object k2 = entry2.getKey();
                int n4 = (Integer)entry2.getValue();
                n3 += n4;
                if (n4 > n) {
                    n2 = n;
                    n = n4;
                    k = k2;
                    continue;
                }
                if (n4 <= n2) continue;
                n2 = n4;
            }
            if (n2 == 0 || n / n2 <= this.THRESHOLD_FOR_PRETAG_WORD) continue;
            hashMap3.put(object, new Pair<Object, Integer>(k, n));
        }
        object2 = new ArrayList(hashMap3.entrySet());
        Collections.sort(object2, new Comparator<Map.Entry<String, Pair<T, Integer>>>(){

            @Override
            public int compare(Map.Entry<String, Pair<T, Integer>> entry, Map.Entry<String, Pair<T, Integer>> entry2) {
                Pair pair = entry.getValue();
                Pair pair2 = entry2.getValue();
                int n = (Integer)pair.value;
                int n2 = (Integer)pair2.value;
                return n2 - n;
            }
        });
        boolean bl = false;
        while (var4_11 < this.MAX_NUMBER_OF_PRETAG_WORD && var4_11 < ((ArrayList)object2).size()) {
            object = ((ArrayList)object2).get((int)var4_11);
            String string = (String)object.getKey();
            Pair pair = (Pair)object.getValue();
            Object k = pair.key;
            this.pretag.add(string, k);
            ++var4_11;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void process_mapping() {
        void var5_10;
        Object v;
        Object k;
        Object object;
        Object object2;
        HashMap hashMap;
        HashMap hashMap2 = new HashMap();
        for (int i = 0; i < this.size; ++i) {
            hashMap = this.gloss[i];
            object2 = this.tag[i];
            if (!this.handler.isAmbiguous(hashMap) || ((Object)hashMap).equals(object2)) continue;
            Pair pair = new Pair(hashMap, object2);
            object = hashMap2.containsKey(pair) ? Integer.valueOf((Integer)hashMap2.get(pair) + 1) : Integer.valueOf(1);
            hashMap2.put(pair, object);
        }
        ConcurrentHashMap<Object, Integer> concurrentHashMap = new ConcurrentHashMap<Object, Integer>();
        hashMap = new HashMap();
        for (Map.Entry entry : hashMap2.entrySet()) {
            object = (Pair)entry.getKey();
            int n = (Integer)entry.getValue();
            k = ((Pair)object).key;
            v = ((Pair)object).value;
            if (hashMap.containsKey(k) && n <= (Integer)hashMap.get(k) || n <= this.THRESHOLD_FOR_TAG_MAPPING) continue;
            hashMap.put(k, n);
            for (Map.Entry entry2 : concurrentHashMap.entrySet()) {
                Pair pair = (Pair)entry2.getKey();
                if (!k.equals(pair.key)) continue;
                concurrentHashMap.remove(pair);
            }
            if (!this.containDifferentTag(k, v)) continue;
            concurrentHashMap.put(object, n);
        }
        object2 = new ArrayList(concurrentHashMap.entrySet());
        Collections.sort(object2, new Comparator<Map.Entry<Pair<T, T>, Integer>>(){

            @Override
            public int compare(Map.Entry<Pair<T, T>, Integer> entry, Map.Entry<Pair<T, T>, Integer> entry2) {
                int n = entry.getValue();
                int n2 = entry2.getValue();
                return n2 - n;
            }
        });
        boolean bl = false;
        while (var5_10 < this.MAX_NUMBER_OF_PRETAG_WORD && var5_10 < ((ArrayList)object2).size()) {
            object = (Map.Entry)((ArrayList)object2).get((int)var5_10);
            Pair pair = (Pair)object.getKey();
            k = pair.key;
            v = pair.value;
            this.mapping.add(k, v);
            ++var5_10;
        }
    }

    private boolean containDifferentTag(T t, T t2) {
        for (T t3 : this.handler.split(t2)) {
            boolean bl = false;
            for (T t4 : this.handler.split(t)) {
                if (!t4.equals(t3)) continue;
                bl = true;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }
}

