/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.Messages;
import com.ibm.dltj.tagger.TagHandler;
import com.ibm.dltj.tagger.feature.DefaultTagHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

class DLTTagHandlerFactory {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected DLTTagHandlerFactory() {
    }

    public static <T> TagHandler<T> createHandler(String string) throws IllegalArgumentException {
        return DLTTagHandlerFactory.createHandler(string, null);
    }

    public static <T> TagHandler<T> createHandler(String string, String string2) throws UnsupportedOperationException {
        ClassLoader classLoader = DLTTagHandlerFactory.class.getClassLoader();
        if (string == null) {
            throw new UnsupportedOperationException(Messages.format("error.tagger.factory.unsupported", "null tag set"));
        }
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException(classNotFoundException);
        }
        if (string2 == null) {
            return new DefaultTagHandler(clazz);
        }
        Class<?> clazz2 = null;
        try {
            clazz2 = classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException(classNotFoundException);
        }
        Constructor<?> constructor = null;
        try {
            constructor = clazz2.getConstructor(Class.class);
        }
        catch (SecurityException securityException) {
            throw new UnsupportedOperationException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UnsupportedOperationException(noSuchMethodException);
        }
        try {
            return (TagHandler)constructor.newInstance(clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException(illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException(invocationTargetException);
        }
    }
}

