/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.Messages;
import com.ibm.dltj.tagger.Resource;
import com.ibm.dltj.tagger.Streamable;
import com.ibm.dltj.tagger.TaggerDictionary;
import com.ibm.dltj.tagger.impl.DLTTaggerDictionaryDescriptionImpl;
import com.ibm.dltj.tagger.impl.W3CDateTimeFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class DLTTaggerDictionary
implements TaggerDictionary {
    private final String id = TaggerDictionary.class.getName();
    private final URL url;
    private final TaggerDictionary.Description description = new DLTTaggerDictionaryDescriptionImpl();
    private final Map<String, Resource> map = new HashMap<String, Resource>();
    private static final String POSTAGGER_PREFIX = "LanguageWare-POSTaggerDictionary-";
    public static final String POSTAGGER_RESOURCE_PROPERTIES = "LanguageWare-POSTaggerDictionary-Properties";
    public static final String POSTAGGER_RESOURCE_NAME = "LanguageWare-POSTaggerDictionary-Name";
    public static final String POSTAGGER_RESOURCE_ALGORITHM = "LanguageWare-POSTaggerDictionary-Algorithm";
    public static final String POSTAGGER_RESOURCE_PROVIDER = "LanguageWare-POSTaggerDictionary-Provider";
    public static final String POSTAGGER_RESOURCE_COPYRIGHT = "LanguageWare-POSTaggerDictionary-Copyright";
    public static final String POSTAGGER_RESOURCE_BUILD_NUMBER = "LanguageWare-POSTaggerDictionary-BuildNumber";
    public static final String POSTAGGER_RESOURCE_CREATION_DATE = "LanguageWare-POSTaggerDictionary-CreationDate";
    private static final String DEFAULT_PROPERTIES_FILE = "META-INF/tagger.properties";
    private static final String DEFAULT_POS_TAGGER_RESOURCE_COMMENTS = "POS Tagger Resource Properties";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public DLTTaggerDictionary(URL uRL) {
        this.url = uRL;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public TaggerDictionary.Description getDescription() {
        return this.description;
    }

    void load() throws IOException {
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void open() throws IOException {
        File file = new File(URI.create(this.url.toString()));
        if (!file.exists()) {
            throw new FileNotFoundException(Messages.format("error.io.file.notfound", file.getCanonicalPath()));
        }
        JarFile jarFile = null;
        try {
            Object object;
            jarFile = new JarFile(file);
            Properties properties = new Properties();
            Manifest manifest = jarFile.getManifest();
            if (manifest != null) {
                Object object2;
                block27: {
                    object = manifest.getMainAttributes();
                    object2 = ((Attributes)object).getValue(POSTAGGER_RESOURCE_PROPERTIES);
                    if (object2 != null) {
                        InputStream inputStream;
                        InputStream object3 = null;
                        try {
                            inputStream = jarFile.getInputStream(new JarEntry((String)object2));
                            properties.load(inputStream);
                            if (inputStream == null) break block27;
                        }
                        catch (Throwable throwable) {
                            if (object3 == null) throw throwable;
                            object3.close();
                            throw throwable;
                        }
                        inputStream.close();
                    }
                }
                if ((object2 = ((Attributes)object).getValue(POSTAGGER_RESOURCE_PROVIDER)) != null) {
                    this.description.setProvider((String)object2);
                }
                if ((object2 = ((Attributes)object).getValue(POSTAGGER_RESOURCE_COPYRIGHT)) != null) {
                    this.description.setCopyrightStatement((String)object2);
                }
                if ((object2 = ((Attributes)object).getValue(POSTAGGER_RESOURCE_NAME)) != null) {
                    this.description.setName((String)object2);
                }
                if ((object2 = ((Attributes)object).getValue(POSTAGGER_RESOURCE_ALGORITHM)) != null) {
                    this.description.setAlgorithm((String)object2);
                }
                if ((object2 = ((Attributes)object).getValue(POSTAGGER_RESOURCE_BUILD_NUMBER)) != null) {
                    this.description.setBuildNumber((String)object2);
                }
                if ((object2 = ((Attributes)object).getValue(POSTAGGER_RESOURCE_CREATION_DATE)) != null) {
                    this.description.setCreationDate(W3CDateTimeFormat.parse((String)object2));
                }
            }
            object = this.getClass().getClassLoader();
            for (Map.Entry entry : properties.entrySet()) {
                Object instantiationException;
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                Resource resource = null;
                try {
                    instantiationException = ((ClassLoader)object).loadClass(string2);
                    resource = (Resource)((Class)instantiationException).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IOException(classNotFoundException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IOException(illegalAccessException.getMessage());
                }
                catch (InstantiationException instantiationException2) {
                    throw new IOException(instantiationException2.getMessage());
                }
                instantiationException = null;
                try {
                    instantiationException = jarFile.getInputStream(new JarEntry(string));
                    ((Streamable)((Object)resource)).load(new DataInputStream((InputStream)instantiationException));
                }
                finally {
                    if (instantiationException != null) {
                        ((InputStream)instantiationException).close();
                    }
                }
                this.map.put(string, resource);
            }
            return;
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.getMessage());
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws IOException {
        Iterator<Resource> iOException;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Properties properties = new Properties();
        for (Map.Entry<String, Resource> object62 : this.map.entrySet()) {
            object4 = object62.getKey();
            object3 = object62.getValue();
            object2 = object3.getClass().getName();
            properties.put(object4, object2);
        }
        File file = new File(URI.create(this.url.toString()));
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException(Messages.format("error.io.file.mkdirs", file2.getCanonicalPath()));
        }
        object4 = null;
        if (file.exists()) {
            object = new SimpleDateFormat("yyyyMMdd-HHmmssSSS", Locale.US);
            ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
            iOException = ((DateFormat)object).format(new Date(System.currentTimeMillis()));
            File file3 = new File(URI.create(this.url.toString() + "." + (String)((Object)iOException) + ".bak"));
            if (!file.renameTo(file3)) {
                throw new IOException(Messages.format("error.io.file.rename", file3.getCanonicalPath()));
            }
            try {
                object4 = new JarFile(file3);
            }
            catch (IOException iOException2) {
                object4 = null;
            }
        }
        object3 = null;
        object3 = object4 != null ? new Manifest(((JarFile)object4).getManifest()) : new Manifest();
        object2 = ((Manifest)object3).getMainAttributes();
        ((Attributes)object2).put(Attributes.Name.MANIFEST_VERSION, "1.0");
        ((Attributes)object2).put(new Attributes.Name(POSTAGGER_RESOURCE_PROVIDER), this.description.getProvider());
        ((Attributes)object2).put(new Attributes.Name(POSTAGGER_RESOURCE_COPYRIGHT), this.description.getCopyrightStatement());
        ((Attributes)object2).put(new Attributes.Name(POSTAGGER_RESOURCE_NAME), this.description.getName());
        ((Attributes)object2).put(new Attributes.Name(POSTAGGER_RESOURCE_ALGORITHM), this.description.getAlgorithm());
        ((Attributes)object2).put(new Attributes.Name(POSTAGGER_RESOURCE_BUILD_NUMBER), this.description.getBuildNumber());
        ((Attributes)object2).put(new Attributes.Name(POSTAGGER_RESOURCE_CREATION_DATE), W3CDateTimeFormat.format(new Date()));
        ((Attributes)object2).put(new Attributes.Name(POSTAGGER_RESOURCE_PROPERTIES), DEFAULT_PROPERTIES_FILE);
        object = null;
        try {
            object = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), (Manifest)object3);
            ((JarOutputStream)object).putNextEntry(new JarEntry(DEFAULT_PROPERTIES_FILE));
            properties.store((OutputStream)object, DEFAULT_POS_TAGGER_RESOURCE_COMMENTS);
            ((DeflaterOutputStream)object).flush();
            ((ZipOutputStream)object).closeEntry();
            if (object4 != null) {
                iOException = ((JarFile)object4).entries();
                while (iOException.hasMoreElements()) {
                    JarEntry jarEntry = (JarEntry)iOException.nextElement();
                    String string = jarEntry.getName();
                    if (string.equals("META-INF/MANIFEST.MF") || string.equals(DEFAULT_PROPERTIES_FILE) || properties.containsKey(string)) continue;
                    FilterInputStream filterInputStream = null;
                    try {
                        int n;
                        filterInputStream = new DataInputStream(new BufferedInputStream(((JarFile)object4).getInputStream(jarEntry)));
                        ((JarOutputStream)object).putNextEntry(new JarEntry(jarEntry));
                        byte[] byArray = new byte[1024];
                        while ((n = ((DataInputStream)filterInputStream).read(byArray, 0, byArray.length)) != -1) {
                            ((ZipOutputStream)object).write(byArray, 0, n);
                        }
                        ((DeflaterOutputStream)object).flush();
                        ((ZipOutputStream)object).closeEntry();
                    }
                    finally {
                        if (filterInputStream != null) {
                            filterInputStream.close();
                        }
                    }
                }
            }
            for (Resource resource : this.map.values()) {
                ((JarOutputStream)object).putNextEntry(new JarEntry(resource.getId()));
                ((Streamable)((Object)resource)).save(new DataOutputStream((OutputStream)object));
                ((DeflaterOutputStream)object).flush();
                ((ZipOutputStream)object).closeEntry();
            }
            ((ZipOutputStream)object).finish();
        }
        finally {
            if (object != null) {
                try {
                    ((DeflaterOutputStream)object).flush();
                    ((ZipOutputStream)object).close();
                }
                catch (IOException iOException3) {}
            }
            if (object4 != null) {
                try {
                    ((ZipFile)object4).close();
                }
                catch (IOException iOException4) {}
            }
        }
    }

    @Override
    public void clear() {
        for (Resource resource : this.map.values()) {
            resource.clear();
        }
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ArrayList<IOException> arrayList = new ArrayList<IOException>();
        try {
            for (Resource resource : this.map.values()) {
                try {
                    resource.close();
                }
                catch (IOException iOException) {
                    arrayList.add(iOException);
                }
            }
            this.map.clear();
        }
        finally {
            if (!arrayList.isEmpty()) {
                throw new IOException(((Object)arrayList).toString());
            }
        }
    }

    @Override
    public <R> R addResource(String string, Resource resource) {
        return (R)this.map.put(string, resource);
    }

    @Override
    public <R> R getResource(String string) {
        return (R)this.map.get(string);
    }

    @Override
    public <R> R removeResource(String string) {
        return (R)this.map.remove(string);
    }
}

