/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.Messages;
import com.ibm.dltj.tagger.Tagger;
import com.ibm.dltj.tagger.TaggerFactory;
import com.ibm.dltj.tagger.impl.BasicAssumptionTrainer;
import com.ibm.dltj.tagger.impl.MappingBasedTagger;
import com.ibm.dltj.tagger.impl.UnsupervisedRuleBasedTagger;
import com.ibm.dltj.tagger.impl.UnsupervisedRuleBasedTrainer;

public class DLTTaggerFactory
implements TaggerFactory {
    public static final String BASIC_ASSUMPTION = "BASIC_ASSUMPTION";
    public static final String UNSUPERVISED_RULE_BASED = "UNSUPERVISED_RULE_BASED";
    public static final String MAPPING_BASED = "MAPPING_BASED";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected DLTTaggerFactory() {
    }

    public static DLTTaggerFactory newInstance() {
        return new DLTTaggerFactory();
    }

    @Override
    public <G, T> Tagger<G, T> createTagger(String string) {
        if (UNSUPERVISED_RULE_BASED.equals(string)) {
            return new UnsupervisedRuleBasedTagger();
        }
        if (MAPPING_BASED.equals(string)) {
            return new MappingBasedTagger();
        }
        throw new UnsupportedOperationException(Messages.format("error.tagger.factory.unsupported", string));
    }

    @Override
    public <G, T> Tagger<G, T> createTrainer(String string) {
        if (BASIC_ASSUMPTION.equals(string)) {
            return new BasicAssumptionTrainer();
        }
        if (UNSUPERVISED_RULE_BASED.equals(string)) {
            return new UnsupervisedRuleBasedTrainer();
        }
        throw new UnsupportedOperationException(Messages.format("error.tagger.factory.unsupported", string));
    }
}

