/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.tagger.impl.AbstractTagger;
import com.ibm.dltj.tagger.interpreter.Interpreter;
import java.io.IOException;
import java.net.URL;

class MappingBasedTagger<G, T>
extends AbstractTagger<G, T> {
    protected Interpreter<G, T> interpreter;
    protected static final String ENCODING = "utf-8";

    MappingBasedTagger() {
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    protected void open(URL uRL, int n) throws IOException {
        super.open(uRL, n);
        this.dictionary.open();
        this.interpreter = (Interpreter)this.dictionary.getResource("tag-map.lst");
        if (this.interpreter == null) {
            throw new IOException(Messages.format("error.io.resource.missing", "tag-map.lst", this.url));
        }
        this.setFeature("com.ibm.dltj.tagger.properties.mapping-based.interpreter", this.interpreter);
    }

    @Override
    public void save() throws IOException {
        super.save();
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.interpreter = null;
    }

    @Override
    public <V> void setFeature(String string, V v) {
        super.setFeature(string, v);
        if (string.equals("com.ibm.dltj.tagger.properties.mapping-based.interpreter")) {
            this.interpreter = (Interpreter)v;
        }
    }

    @Override
    public void process() throws DLTException {
        for (int i = 0; i < this.size; ++i) {
            T t = this.interpreter.toTag(this.text(i), this.gloss[i]);
            if (t == null) continue;
            this.tag[i] = t;
        }
    }
}

