/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.tagger.TagHandler;
import com.ibm.dltj.tagger.feature.DefaultTagHandler;
import com.ibm.dltj.tagger.impl.DLTTagHandlerFactory;
import com.ibm.dltj.tagger.impl.DefaultResource;
import com.ibm.dltj.tagger.impl.Pair;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

class MappingBook<T1, T2>
extends DefaultResource {
    private final Map<T1, T2> book = new HashMap<T1, T2>();
    private TagHandler<T1> handler1;
    private TagHandler<T2> handler2;
    public static final String ID = "mapping.lst";
    private static final String TAG_SET_HEADER = "#tag-set=";
    private static final String TAG_HANDLER_HEADER = "#tag-handler=";
    private static final String INPUT_TAG_SET_HEADER = "#input-tag-set=";
    private static final String INPUT_TAG_HANDLER_HEADER = "#input-tag-handler=";
    private static final String OUTPUT_TAG_SET_HEADER = "#output-tag-set=";
    private static final String OUTPUT_TAG_HANDLER_HEADER = "#output-tag-handler=";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public MappingBook() {
        this(ID);
    }

    public MappingBook(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(DataInputStream dataInputStream) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)dataInputStream, "utf-8"));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.charAt(0) == '\ufeff') {
                    string = string.substring(1);
                }
                if (string.startsWith(TAG_SET_HEADER)) {
                    string2 = string4 = string.substring(TAG_SET_HEADER.length());
                    continue;
                }
                if (string.startsWith(TAG_HANDLER_HEADER)) {
                    string3 = string5 = string.substring(TAG_HANDLER_HEADER.length());
                    continue;
                }
                if (string.startsWith(INPUT_TAG_SET_HEADER)) {
                    string2 = string.substring(INPUT_TAG_SET_HEADER.length());
                    continue;
                }
                if (string.startsWith(INPUT_TAG_HANDLER_HEADER)) {
                    string3 = string.substring(INPUT_TAG_HANDLER_HEADER.length());
                    continue;
                }
                if (string.startsWith(OUTPUT_TAG_SET_HEADER)) {
                    string4 = string.substring(OUTPUT_TAG_SET_HEADER.length());
                    continue;
                }
                if (string.startsWith(OUTPUT_TAG_HANDLER_HEADER)) {
                    string5 = string.substring(OUTPUT_TAG_HANDLER_HEADER.length());
                    continue;
                }
                if (this.handler1 == null) {
                    this.setInputHandler(DLTTagHandlerFactory.createHandler(string2, string3));
                }
                if (this.handler2 == null) {
                    this.setOutputHandler(DLTTagHandlerFactory.createHandler(string4, string5));
                }
                int n = string.lastIndexOf(9);
                T1 T1 = this.handler1.parse(string.substring(0, n));
                T2 T2 = this.handler2.parse(string.substring(n + 1, string.length()));
                this.book.put(T1, T2);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(DataOutputStream dataOutputStream) throws IOException {
        PrintWriter printWriter = null;
        try {
            Object object;
            Object object2;
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)dataOutputStream, "utf-8"));
            String string = this.handler1.getType().getName();
            String string2 = this.handler2.getType().getName();
            String string3 = this.handler1.getClass().getName();
            String string4 = this.handler2.getClass().getName();
            if (string.equals(string2)) {
                printWriter.print(TAG_SET_HEADER);
                printWriter.print(string);
                printWriter.println();
            } else {
                printWriter.print(INPUT_TAG_SET_HEADER);
                printWriter.print(string);
                printWriter.println();
                printWriter.print(OUTPUT_TAG_SET_HEADER);
                printWriter.print(string2);
                printWriter.println();
            }
            if (string3.equals(string4)) {
                if (!string3.equals(DefaultTagHandler.class.getName())) {
                    printWriter.print(TAG_HANDLER_HEADER);
                    printWriter.print(string3);
                    printWriter.println();
                }
            } else {
                if (!string3.equals(DefaultTagHandler.class.getName())) {
                    printWriter.print(INPUT_TAG_HANDLER_HEADER);
                    printWriter.print(string3);
                    printWriter.println();
                }
                if (!string4.equals(DefaultTagHandler.class.getName())) {
                    printWriter.print(OUTPUT_TAG_HANDLER_HEADER);
                    printWriter.print(string4);
                    printWriter.println();
                }
            }
            ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>(this.book.size());
            for (Map.Entry<T1, T2> object3 : this.book.entrySet()) {
                object2 = object3.getKey();
                object = object3.getValue();
                arrayList.add(new Pair<String, String>(this.handler1.toString(object2), this.handler2.toString(object)));
            }
            Collections.sort(arrayList, new Comparator<Pair<String, String>>(){

                @Override
                public int compare(Pair<String, String> pair, Pair<String, String> pair2) {
                    String string = (String)pair.key;
                    String string2 = (String)pair2.key;
                    return string.compareTo(string2);
                }
            });
            for (Pair pair : arrayList) {
                object2 = (String)pair.key;
                object = (String)pair.value;
                printWriter.print((String)object2);
                printWriter.print('\t');
                printWriter.print((String)object);
                printWriter.println();
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.book.clear();
        this.handler1 = null;
        this.handler2 = null;
    }

    @Override
    public void clear() {
        this.book.clear();
    }

    public TagHandler<T1> getInputHandler() {
        return this.handler1;
    }

    public TagHandler<T2> getOutputHandler() {
        return this.handler2;
    }

    public void setInputHandler(TagHandler<T1> tagHandler) {
        this.handler1 = tagHandler;
    }

    public void setOutputHandler(TagHandler<T2> tagHandler) {
        this.handler2 = tagHandler;
    }

    public void add(T1 T1, T2 T2) {
        this.book.put(T1, T2);
    }

    public T2 get(T1 T1) {
        T2 T2 = this.book.get(T1);
        if (T2 == null && !this.handler1.isAmbiguous(T1)) {
            T2 = this.book.get(this.handler1.first(T1));
        }
        return T2;
    }

    public int size() {
        return this.book.size();
    }
}

