/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.tagger.TagHandler;
import com.ibm.dltj.tagger.feature.DefaultTagHandler;
import com.ibm.dltj.tagger.impl.DLTTagHandlerFactory;
import com.ibm.dltj.tagger.impl.DefaultResource;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

class PretagBook<T>
extends DefaultResource {
    private final Map<String, T> book = new HashMap<String, T>();
    private TagHandler<T> handler;
    public static final String ID = "pretag.lst";
    private static final String TAG_SET_HEADER = "#tag-set=";
    private static final String TAG_HANDLER_HEADER = "#tag-handler=";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public PretagBook() {
        this(ID);
    }

    public PretagBook(String string) {
        super(string);
    }

    @Override
    public void load(DataInputStream dataInputStream) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            String string2 = null;
            String string3 = null;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)dataInputStream, "utf-8"));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.charAt(0) == '\ufeff') {
                    string = string.substring(1);
                }
                if (string.startsWith(TAG_SET_HEADER)) {
                    string2 = string.substring(TAG_SET_HEADER.length());
                    continue;
                }
                if (string.startsWith(TAG_HANDLER_HEADER)) {
                    string3 = string.substring(TAG_HANDLER_HEADER.length());
                    continue;
                }
                if (this.handler == null) {
                    this.setHandler(DLTTagHandlerFactory.createHandler(string2, string3));
                }
                int n = string.lastIndexOf(9);
                String string4 = string.substring(0, n);
                T t = this.handler.parse(string.substring(n + 1, string.length()));
                this.book.put(string4, t);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(DataOutputStream dataOutputStream) throws IOException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)dataOutputStream, "utf-8"));
            printWriter.print(TAG_SET_HEADER);
            printWriter.print(this.handler.getType().getName());
            printWriter.println();
            if (this.handler.getClass() != DefaultTagHandler.class) {
                printWriter.print(TAG_HANDLER_HEADER);
                printWriter.print(this.handler.getClass().getName());
                printWriter.println();
            }
            ArrayList<Map.Entry<String, T>> arrayList = new ArrayList<Map.Entry<String, T>>(this.book.entrySet());
            Collections.sort(arrayList, new Comparator<Map.Entry<String, T>>(){

                @Override
                public int compare(Map.Entry<String, T> entry, Map.Entry<String, T> entry2) {
                    String string = entry.getKey();
                    String string2 = entry2.getKey();
                    return string.compareTo(string2);
                }
            });
            for (Map.Entry<String, T> entry : arrayList) {
                String string = entry.getKey();
                T t = entry.getValue();
                printWriter.print(string);
                printWriter.print('\t');
                printWriter.print(this.handler.toString(t));
                printWriter.println();
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.book.clear();
        this.handler = null;
    }

    @Override
    public void clear() {
        this.book.clear();
    }

    public TagHandler<T> getHandler() {
        return this.handler;
    }

    public void setHandler(TagHandler<T> tagHandler) {
        this.handler = tagHandler;
    }

    public void add(String string, T t) {
        this.book.put(string, t);
    }

    public T get(String string) {
        return this.book.get(string);
    }

    public int size() {
        return this.book.size();
    }
}

