/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

class UnsupervisedRule<T> {
    private final Condition<?, T> condition;
    private final T predicate;
    private final int priority;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public UnsupervisedRule(Condition<?, T> condition, T t, int n) {
        this.condition = condition;
        this.predicate = t;
        this.priority = n;
    }

    public Condition<?, T> condition() {
        return this.condition;
    }

    public T predicate() {
        return this.predicate;
    }

    public int priority() {
        return this.priority;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Rule[#").append(this.priority).append("] ");
        stringBuilder.append(this.condition.chi()).append("->").append(this.predicate);
        stringBuilder.append(" because ");
        stringBuilder.append(this.condition.location() == 1 ? "next-word" : (this.condition.location() == -1 ? "prev-word" : Integer.valueOf(this.condition.location())));
        stringBuilder.append("=").append(this.condition.feature());
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    static final class Condition<F, T> {
        public static final int NEXT_TOKEN = 1;
        public static final int PREVIOUS_TOKEN = -1;
        final F feature;
        final int location;
        final T chi;

        public Condition(F f, int n, T t) {
            this.feature = f;
            this.location = n;
            this.chi = t;
        }

        private Condition(Condition<F, T> condition, T t) {
            this.feature = condition.feature;
            this.location = condition.location;
            this.chi = t;
        }

        public static <F, T> Condition<F, T> fromContext(Condition<F, T> condition, T t) {
            return new Condition<F, T>(condition, t);
        }

        public F feature() {
            return this.feature;
        }

        public int location() {
            return this.location;
        }

        public T chi() {
            return this.chi;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.chi == null ? 0 : this.chi.hashCode());
            n = 31 * n + (this.feature == null ? 0 : this.feature.hashCode());
            n = 31 * n + this.location;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Condition condition = (Condition)object;
            if (this.chi == null ? condition.chi != null : !this.chi.equals(condition.chi)) {
                return false;
            }
            if (this.feature == null ? condition.feature != null : !this.feature.equals(condition.feature)) {
                return false;
            }
            return this.location == condition.location;
        }
    }
}

