/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.Messages;
import com.ibm.dltj.tagger.TagHandler;
import com.ibm.dltj.tagger.impl.AbstractTagger;
import com.ibm.dltj.tagger.impl.MappingBook;
import com.ibm.dltj.tagger.impl.PretagBook;
import com.ibm.dltj.tagger.impl.StopWordBook;
import com.ibm.dltj.tagger.impl.UnsupervisedRule;
import com.ibm.dltj.tagger.impl.UnsupervisedRuleBook;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;

abstract class UnsupervisedRuleBasedAbstractTagger<G, T>
extends AbstractTagger<G, T> {
    protected static final String ALGORITHM_NAME = "UNSUPERVISED_RULE_BASED";
    protected UnsupervisedRuleBook<T> book;
    protected PretagBook<T> pretag;
    protected MappingBook<G, T> mapping;
    protected StopWordBook stopword;
    protected TagHandler<T> handler;

    UnsupervisedRuleBasedAbstractTagger() {
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    protected void open(URL uRL, int n) throws IOException {
        super.open(uRL, n);
    }

    @Override
    public void save() throws IOException {
        super.save();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.book = null;
        this.pretag = null;
        this.mapping = null;
        this.stopword = null;
        this.handler = null;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public <V> void setFeature(String string, V v) {
        super.setFeature(string, v);
        if (string.equals("com.ibm.dltj.tagger.properites.unsupervised-rule-based.tag-handler")) {
            this.handler = (TagHandler)v;
            this.book.setHandler(this.handler);
            this.pretag.setHandler(this.handler);
            this.mapping.setInputHandler(this.handler);
            this.mapping.setOutputHandler(this.handler);
        }
    }

    protected void preprocess() {
        for (int i = 0; i < this.size; ++i) {
            T t;
            String string = this.text(i);
            boolean bl = this.stopword.contains(string);
            if (bl) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, Messages.format("info.trace.stopword", Integer.toString(i), this.text(i)));
                }
                this.skip.set(i);
            }
            if ((t = this.pretag.get(string)) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, Messages.format("info.trace.pretagging", Integer.toString(i), this.text(i), this.tag[i], t));
                }
                this.tag[i] = t;
                continue;
            }
            T t2 = this.mapping.get(this.gloss[i]);
            if (t2 != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, Messages.format("info.trace.tagmapping", Integer.toString(i), this.text(i), this.tag[i], t2));
                }
                this.tag[i] = t2;
                continue;
            }
            if (this.handler.isAmbiguous(this.tag[i])) continue;
            this.tag[i] = this.handler.first(this.tag[i]);
        }
    }

    protected final int nextIndex(int n) {
        int n2;
        if (this.skip.isEmpty() || n2 >= this.skip.size()) {
            return n2;
        }
        for (n2 = n + 1; n2 < this.skip.size() && this.skip.get(n2); ++n2) {
        }
        return n2;
    }

    protected final int prevIndex(int n) {
        int n2;
        if (this.skip.isEmpty() || n2 >= this.skip.size()) {
            return n2;
        }
        for (n2 = n - 1; n2 >= 0 && this.skip.get(n2); --n2) {
        }
        return n2;
    }

    protected final UnsupervisedRule<T> rule(T t, T t2, String string, int n) {
        UnsupervisedRule<T> unsupervisedRule = this.book.get(new UnsupervisedRule.Condition<T, T>(t2, n, t));
        UnsupervisedRule<T> unsupervisedRule2 = this.book.get(new UnsupervisedRule.Condition<String, T>(string, n, t));
        int n2 = unsupervisedRule == null ? Integer.MAX_VALUE : unsupervisedRule.priority();
        int n3 = unsupervisedRule2 == null ? Integer.MAX_VALUE : unsupervisedRule2.priority();
        return n2 < n3 ? unsupervisedRule : unsupervisedRule2;
    }
}

