/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.Messages;
import com.ibm.dltj.tagger.impl.MappingBook;
import com.ibm.dltj.tagger.impl.Pair;
import com.ibm.dltj.tagger.impl.PretagBook;
import com.ibm.dltj.tagger.impl.StopWordBook;
import com.ibm.dltj.tagger.impl.UnsupervisedRule;
import com.ibm.dltj.tagger.impl.UnsupervisedRuleBasedAbstractTagger;
import com.ibm.dltj.tagger.impl.UnsupervisedRuleBook;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.logging.Level;

class UnsupervisedRuleBasedTagger<G, T>
extends UnsupervisedRuleBasedAbstractTagger<G, T> {
    private PriorityQueue<Pair<Integer, UnsupervisedRule<T>>> queue;
    private static final int QUEUE_CAPACITY = 128;

    UnsupervisedRuleBasedTagger() {
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    protected void open(URL uRL, int n) throws IOException {
        super.open(uRL, n);
        this.dictionary.open();
        this.pretag = (PretagBook)this.dictionary.getResource("pretag.lst");
        if (this.pretag == null) {
            this.pretag = new PretagBook("pretag.lst");
            this.dictionary.addResource(this.pretag.getId(), this.pretag);
        }
        this.mapping = (MappingBook)this.dictionary.getResource("mapping.lst");
        if (this.mapping == null) {
            this.mapping = new MappingBook("mapping.lst");
            this.dictionary.addResource(this.mapping.getId(), this.mapping);
        }
        this.stopword = (StopWordBook)this.dictionary.getResource("stop-word.lst");
        if (this.stopword == null) {
            this.stopword = new StopWordBook("stop-word.lst");
            this.dictionary.addResource(this.stopword.getId(), this.stopword);
        }
        this.book = (UnsupervisedRuleBook)this.dictionary.getResource("rule-book.xml");
        if (this.book == null) {
            throw new IOException(Messages.format("error.io.resource.missing", "rule-book.xml", this.url.toString()));
        }
        this.setFeature("com.ibm.dltj.tagger.properites.unsupervised-rule-based.tag-handler", this.book.getHandler());
        this.queue = new PriorityQueue(128, new Comparator<Pair<Integer, UnsupervisedRule<T>>>(){

            @Override
            public int compare(Pair<Integer, UnsupervisedRule<T>> pair, Pair<Integer, UnsupervisedRule<T>> pair2) {
                UnsupervisedRule unsupervisedRule = (UnsupervisedRule)pair.value;
                UnsupervisedRule unsupervisedRule2 = (UnsupervisedRule)pair2.value;
                return unsupervisedRule.priority() - unsupervisedRule2.priority();
            }
        });
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.queue = null;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.queue != null) {
            this.queue.clear();
        }
    }

    @Override
    public void process() {
        long l = System.currentTimeMillis();
        System.arraycopy(this.gloss, 0, this.tag, 0, this.size);
        this.preprocess();
        int n = 0;
        int n2 = this.size - 1;
        for (int i = 0; i < this.size; ++i) {
            int n3;
            if (this.skip.get(i) || this.handler.isAmbiguous(this.tag[i]) && i != n2) continue;
            if (i - n == 1) {
                n = i;
                continue;
            }
            for (n3 = n; n3 < i; ++n3) {
                this.forward(n3);
            }
            for (n3 = i; n3 > n; --n3) {
                this.backward(n3);
            }
            while (!this.queue.isEmpty()) {
                Pair<Integer, UnsupervisedRule<T>> pair = this.queue.poll();
                int n4 = (Integer)pair.key;
                UnsupervisedRule unsupervisedRule = (UnsupervisedRule)pair.value;
                if (!this.handler.isAmbiguous(this.tag[n4])) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, Messages.format("info.trace.rule", Integer.toString(n4), this.text(n4), unsupervisedRule));
                }
                this.tag[n4] = unsupervisedRule.predicate();
                UnsupervisedRule.Condition condition = unsupervisedRule.condition();
                if (condition.location() < 0) {
                    this.forward(n4);
                    continue;
                }
                this.backward(n4);
            }
            n = i;
        }
        long l2 = System.currentTimeMillis() - l;
        logger.log(Level.FINE, Messages.format("info.elapsed.time", l2));
    }

    private void forward(int n) {
        int n2 = this.nextIndex(n);
        if (n2 >= this.size) {
            return;
        }
        Object object = this.tag[n2];
        if (!this.handler.isAmbiguous(object)) {
            return;
        }
        UnsupervisedRule<Object> unsupervisedRule = this.rule(object, this.tag[n], this.text(n), -1);
        if (unsupervisedRule == null) {
            return;
        }
        this.queue.add(new Pair<Integer, UnsupervisedRule<Object>>(n2, unsupervisedRule));
    }

    private void backward(int n) {
        int n2 = this.prevIndex(n);
        if (n2 < 0) {
            return;
        }
        Object object = this.tag[n2];
        if (!this.handler.isAmbiguous(object)) {
            return;
        }
        UnsupervisedRule<Object> unsupervisedRule = this.rule(object, this.tag[n], this.text(n), 1);
        if (unsupervisedRule == null) {
            return;
        }
        this.queue.add(new Pair<Integer, UnsupervisedRule<Object>>(n2, unsupervisedRule));
    }
}

