/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.tagger.impl.MappingBook;
import com.ibm.dltj.tagger.impl.PretagBook;
import com.ibm.dltj.tagger.impl.StopWordBook;
import com.ibm.dltj.tagger.impl.UnsupervisedRule;
import com.ibm.dltj.tagger.impl.UnsupervisedRuleBasedAbstractTagger;
import com.ibm.dltj.tagger.impl.UnsupervisedRuleBook;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

class UnsupervisedRuleBasedTrainer<G, T>
extends UnsupervisedRuleBasedAbstractTagger<G, T> {
    private Map<UnsupervisedRule.Condition<?, T>, Integer> incontext;
    private Map<T, Integer> freq;
    private int MAX_NUMBER_OF_ITERATION = 1000;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    protected void open(URL uRL, int n) throws IOException {
        super.open(uRL, n);
        File file = new File(URI.create(this.url.toString()));
        if (file.exists()) {
            this.dictionary.open();
        }
        this.pretag = (PretagBook)this.dictionary.getResource("pretag.lst");
        if (this.pretag == null) {
            this.pretag = new PretagBook("pretag.lst");
            this.dictionary.addResource(this.pretag.getId(), this.pretag);
        }
        this.mapping = (MappingBook)this.dictionary.getResource("mapping.lst");
        if (this.mapping == null) {
            this.mapping = new MappingBook("mapping.lst");
            this.dictionary.addResource(this.mapping.getId(), this.mapping);
        }
        this.stopword = (StopWordBook)this.dictionary.getResource("stop-word.lst");
        if (this.stopword == null) {
            this.stopword = new StopWordBook("stop-word.lst");
            this.dictionary.addResource(this.stopword.getId(), this.stopword);
        }
        this.book = (UnsupervisedRuleBook)this.dictionary.getResource("rule-book.xml");
        if (this.book == null) {
            this.book = new UnsupervisedRuleBook("rule-book.xml");
            this.dictionary.addResource(this.book.getId(), this.book);
        } else {
            this.book.clear();
        }
        this.incontext = new HashMap();
        this.freq = new HashMap<T, Integer>();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.incontext = null;
        this.freq = null;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.book != null) {
            this.book.clear();
        }
        if (this.incontext != null) {
            this.incontext.clear();
        }
        if (this.freq != null) {
            this.freq.clear();
        }
    }

    @Override
    public void save() throws IOException {
        this.dictionary.getDescription().setAlgorithm("UNSUPERVISED_RULE_BASED");
        super.save();
    }

    @Override
    public <V> void setFeature(String string, V v) {
        super.setFeature(string, v);
        if (string.equals("com.ibm.dltj.tagger.properites.unsupervised-rule-based.max-number-of-iteration")) {
            this.MAX_NUMBER_OF_ITERATION = (Integer)v;
        } else if (string.equals("com.ibm.dltj.tagger.dictionary.name")) {
            this.dictionary.getDescription().setName((String)v);
        } else if (string.equals("com.ibm.dltj.tagger.dictionary.provider")) {
            this.dictionary.getDescription().setProvider((String)v);
        } else if (string.equals("com.ibm.dltj.tagger.dictionary.copyright")) {
            this.dictionary.getDescription().setCopyrightStatement((String)v);
        } else if (string.equals("com.ibm.dltj.tagger.dictionary.build-number")) {
            this.dictionary.getDescription().setBuildNumber((String)v);
        }
    }

    @Override
    public void process() throws DLTException {
        assert (this.handler != null);
        assert (this.book != null);
        System.arraycopy(this.gloss, 0, this.tag, 0, this.size);
        this.preprocess();
        int n = this.book.size() + 1;
        long l = 0L;
        UnsupervisedRule.Condition[] conditionArray = new UnsupervisedRule.Condition[4];
        for (int i = 0; i < this.MAX_NUMBER_OF_ITERATION; ++i) {
            int n2;
            UnsupervisedRule<Object> unsupervisedRule;
            Object object;
            long l2 = System.currentTimeMillis();
            this.freq.clear();
            this.incontext.clear();
            for (int j = 0; j < this.size; ++j) {
                if (this.skip.get(j) || this.handler.isAmbiguous(object = this.tag[j])) continue;
                UnsupervisedRuleBasedTrainer.increment(this.freq, object);
                this.context(j, conditionArray);
                for (int k = 0; k < conditionArray.length && conditionArray[k] != null; ++k) {
                    UnsupervisedRuleBasedTrainer.increment(this.incontext, UnsupervisedRule.Condition.fromContext(conditionArray[k], object));
                }
            }
            UnsupervisedRule.Condition condition = null;
            object = null;
            UnsupervisedRule<Object> unsupervisedRule2 = null;
            float f = 0.0f;
            for (int j = 0; j < this.size; ++j) {
                if (this.skip.get(j) || !this.handler.isAmbiguous(unsupervisedRule = this.tag[j])) continue;
                this.context(j, conditionArray);
                UnsupervisedRule<Object>[] unsupervisedRuleArray = this.handler.split(unsupervisedRule);
                for (int k = 0; k < unsupervisedRuleArray.length; ++k) {
                    UnsupervisedRule<Object> unsupervisedRule3 = unsupervisedRuleArray[k];
                    UnsupervisedRule.Condition condition2 = null;
                    UnsupervisedRule<Object> unsupervisedRule4 = null;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    for (int i2 = 0; i2 < unsupervisedRuleArray.length; ++i2) {
                        if (i2 == k) continue;
                        UnsupervisedRule<Object> unsupervisedRule5 = unsupervisedRuleArray[i2];
                        for (int i3 = 0; i3 < conditionArray.length && conditionArray[i3] != null; ++i3) {
                            float f4 = this.incontext(unsupervisedRule5, conditionArray[i3]) == 0 ? 0.0f : (float)(this.freq(unsupervisedRule3) / this.freq(unsupervisedRule5) * this.incontext(unsupervisedRule5, conditionArray[i3]));
                            float f5 = this.incontext(unsupervisedRule3, conditionArray[i3]);
                            if (!(f2 < f4) && (f2 != f4 || !(f3 < f5))) continue;
                            condition2 = conditionArray[i3];
                            unsupervisedRule4 = unsupervisedRule3;
                            f2 = f4;
                            f3 = f5;
                        }
                    }
                    float f6 = f3 - f2;
                    if (!(f < f6)) continue;
                    condition = condition2;
                    object = unsupervisedRule4;
                    f = f6;
                    unsupervisedRule2 = unsupervisedRule;
                }
            }
            if (f <= 0.0f) {
                long l3 = System.currentTimeMillis() - l2;
                l += l3;
                logger.log(Level.FINE, Messages.format("info.elapsed.time.itr", i, l3));
                break;
            }
            UnsupervisedRule.Condition condition3 = UnsupervisedRule.Condition.fromContext(condition, unsupervisedRule2);
            unsupervisedRule = new UnsupervisedRule<Object>(condition3, object, n++);
            this.book.add(unsupervisedRule);
            if (condition.location() < 0) {
                for (n2 = 0; n2 < this.size - 1; ++n2) {
                    this.forward(n2);
                }
            } else {
                for (n2 = this.size - 1; n2 >= 1; --n2) {
                    this.backward(n2);
                }
            }
            long l4 = System.currentTimeMillis() - l2;
            l += l4;
            logger.log(Level.FINE, Messages.format("info.elapsed.time.itr", i, l4));
        }
        logger.log(Level.FINE, Messages.format("info.elapsed.time", l));
    }

    private void context(int n, UnsupervisedRule.Condition<?, T>[] conditionArray) {
        int n2;
        int n3 = 0;
        int n4 = this.prevIndex(n);
        if (n4 >= 0) {
            if (!this.handler.isAmbiguous(this.tag[n4])) {
                conditionArray[n3++] = new UnsupervisedRule.Condition<Object, Object>(this.tag[n4], -1, null);
            }
            conditionArray[n3++] = new UnsupervisedRule.Condition<String, Object>(this.text(n4), -1, null);
        }
        if ((n2 = this.nextIndex(n)) < this.size) {
            if (!this.handler.isAmbiguous(this.tag[n2])) {
                conditionArray[n3++] = new UnsupervisedRule.Condition<Object, Object>(this.tag[n2], 1, null);
            }
            conditionArray[n3++] = new UnsupervisedRule.Condition<String, Object>(this.text(n2), 1, null);
        }
        Arrays.fill(conditionArray, n3, conditionArray.length, null);
    }

    private int incontext(T t, UnsupervisedRule.Condition<?, T> condition) {
        Integer n = this.incontext.get(UnsupervisedRule.Condition.fromContext(condition, t));
        return n == null ? 0 : n;
    }

    private int freq(T t) {
        Integer n = this.freq.get(t);
        return n == null ? 0 : n;
    }

    private static <T> void increment(Map<T, Integer> map, T t) {
        Integer n = map.get(t);
        if (n == null) {
            map.put(t, 1);
        } else {
            map.put(t, n + 1);
        }
    }

    private void forward(int n) {
        int n2 = this.nextIndex(n);
        if (n2 >= this.size) {
            return;
        }
        Object object = this.tag[n2];
        if (!this.handler.isAmbiguous(object)) {
            return;
        }
        UnsupervisedRule<Object> unsupervisedRule = this.rule(object, this.tag[n], this.text(n), -1);
        if (unsupervisedRule == null) {
            return;
        }
        this.tag[n2] = unsupervisedRule.predicate();
    }

    private void backward(int n) {
        int n2 = this.prevIndex(n);
        if (n2 < 0) {
            return;
        }
        Object object = this.tag[n2];
        if (!this.handler.isAmbiguous(object)) {
            return;
        }
        UnsupervisedRule<Object> unsupervisedRule = this.rule(object, this.tag[n], this.text(n), 1);
        if (unsupervisedRule == null) {
            return;
        }
        this.tag[n2] = unsupervisedRule.predicate();
    }
}

