/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.impl;

import com.ibm.dltj.DLT;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.tagger.TagHandler;
import com.ibm.dltj.tagger.feature.DefaultTagHandler;
import com.ibm.dltj.tagger.impl.DLTTagHandlerFactory;
import com.ibm.dltj.tagger.impl.DefaultResource;
import com.ibm.dltj.tagger.impl.UnsupervisedRule;
import com.ibm.dltj.util.XMLWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class UnsupervisedRuleBook<T>
extends DefaultResource {
    private final Map<UnsupervisedRule.Condition<?, T>, UnsupervisedRule<T>> book = new HashMap();
    private TagHandler<T> handler;
    public static final String ID = "rule-book.xml";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public UnsupervisedRuleBook() {
        this(ID);
    }

    public UnsupervisedRuleBook(String string) {
        super(string);
    }

    @Override
    public void load(DataInputStream dataInputStream) throws IOException {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse((InputStream)dataInputStream, new DefaultHandler(){

                @Override
                public void processingInstruction(String string, String string2) throws SAXException {
                }

                @Override
                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    String string4;
                    String string5;
                    if (string3.equals("rule-book")) {
                        string5 = null;
                        String string6 = null;
                        string4 = attributes.getValue("tag-set");
                        if (string4 != null) {
                            string5 = string4;
                        }
                        if ((string4 = attributes.getValue("tag-handler")) != null) {
                            string6 = string4;
                        }
                        try {
                            UnsupervisedRuleBook.this.setHandler(DLTTagHandlerFactory.createHandler(string5, string6));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new SAXException(illegalArgumentException);
                        }
                    }
                    if (string3.equals("rule")) {
                        int n = 0;
                        string5 = attributes.getValue("context-location");
                        if (string5 != null) {
                            n = "next".equals(string5) ? 1 : -1;
                        }
                        string4 = null;
                        string5 = attributes.getValue("context-tag");
                        if (string5 != null) {
                            string4 = UnsupervisedRuleBook.this.handler.parse(string5);
                        } else {
                            string5 = attributes.getValue("context-word");
                            if (string5 != null) {
                                string4 = string5;
                            }
                        }
                        Object t = null;
                        string5 = attributes.getValue("tag-candidate");
                        if (string5 != null) {
                            t = UnsupervisedRuleBook.this.handler.parse(string5);
                        }
                        Object t2 = null;
                        string5 = attributes.getValue("tag-assignment");
                        if (string5 != null) {
                            t2 = UnsupervisedRuleBook.this.handler.parse(string5);
                        }
                        int n2 = 1;
                        string5 = attributes.getValue("priority");
                        if (string5 != null) {
                            n2 = Integer.parseInt(string5);
                        }
                        UnsupervisedRule.Condition<String, Object> condition = new UnsupervisedRule.Condition<String, Object>(string4, n, t);
                        UnsupervisedRuleBook.this.add(new UnsupervisedRule<Object>(condition, t2, n2));
                        return;
                    }
                }
            });
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }

    @Override
    public void save(DataOutputStream dataOutputStream) throws IOException {
        assert (this.handler != null);
        try {
            XMLWriter xMLWriter = new XMLWriter(new PrintWriter(new OutputStreamWriter((OutputStream)dataOutputStream, "utf-8")));
            xMLWriter.writeStartDocument();
            xMLWriter.writeProcessingInstruction("languageware", "version=\"" + DLT.getStrVersion() + "\"");
            ArrayList<UnsupervisedRule<T>> arrayList = new ArrayList<UnsupervisedRule<T>>(this.book.values());
            Collections.sort(arrayList, new Comparator<UnsupervisedRule<T>>(){

                @Override
                public int compare(UnsupervisedRule<T> unsupervisedRule, UnsupervisedRule<T> unsupervisedRule2) {
                    return unsupervisedRule.priority() - unsupervisedRule2.priority();
                }
            });
            xMLWriter.writeStartElement("rule-book");
            xMLWriter.writeAttribute("tag-set", this.handler.getType().getName());
            if (this.handler.getClass() != DefaultTagHandler.class) {
                xMLWriter.writeAttribute("tag-handler", this.handler.getClass().getName());
            }
            for (UnsupervisedRule<T> unsupervisedRule : arrayList) {
                UnsupervisedRule.Condition<?, T> condition = unsupervisedRule.condition();
                xMLWriter.writeStartElement("rule");
                xMLWriter.writeAttribute("context-location", condition.location() == 1 ? "next" : "prev");
                if (condition.feature() instanceof String) {
                    xMLWriter.writeAttribute("context-word", (String)condition.feature());
                } else {
                    xMLWriter.writeAttribute("context-tag", this.handler.toString(condition.feature()));
                }
                xMLWriter.writeAttribute("tag-candidate", this.handler.toString(condition.chi()));
                xMLWriter.writeAttribute("tag-assignment", this.handler.toString(unsupervisedRule.predicate()));
                xMLWriter.writeAttribute("priority", Integer.toString(unsupervisedRule.priority()));
                xMLWriter.writeEndElement();
            }
            xMLWriter.writeEndElement();
            xMLWriter.writeEndDocument();
            xMLWriter.flush();
        }
        catch (DLTException dLTException) {
            throw new IOException(dLTException.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.book.clear();
        this.handler = null;
    }

    @Override
    public void clear() {
        this.book.clear();
    }

    public TagHandler<T> getHandler() {
        return this.handler;
    }

    public void setHandler(TagHandler<T> tagHandler) {
        this.handler = tagHandler;
    }

    public void add(UnsupervisedRule<T> unsupervisedRule) {
        UnsupervisedRule<T> unsupervisedRule2 = this.book.get(unsupervisedRule.condition());
        if (unsupervisedRule2 == null || unsupervisedRule2.priority() > unsupervisedRule.priority()) {
            this.book.put(unsupervisedRule.condition(), unsupervisedRule);
        }
    }

    public UnsupervisedRule<T> get(UnsupervisedRule.Condition<?, T> condition) {
        return this.book.get(condition);
    }

    public int size() {
        return this.book.size();
    }
}

