/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.interpreter;

import com.ibm.dltj.Messages;
import com.ibm.dltj.tagger.feature.ArabicTag;
import com.ibm.dltj.tagger.feature.PennTag;
import com.ibm.dltj.tagger.feature.SimplifiedTag;
import com.ibm.dltj.tagger.interpreter.TokenInterpreter;
import com.ibm.dltj.tagger.interpreter.TokenInterpreterAr;
import com.ibm.dltj.tagger.interpreter.TokenInterpreterCJ;
import com.ibm.dltj.tagger.interpreter.TokenInterpreterEs;
import com.ibm.dltj.tagger.interpreter.TokenInterpreterFr;
import com.ibm.dltj.tagger.interpreter.TokenInterpreterKo;
import com.ibm.dltj.tagger.interpreter.TokenInterpreterPenn;
import com.ibm.dltj.tagger.interpreter.TokenInterpreterSimplified;
import com.ibm.dltj.tagger.interpreter.TokenInterpreterType;

public class TokenInterpreterFactory {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected TokenInterpreterFactory() {
    }

    public static TokenInterpreterFactory newInstance() {
        return new TokenInterpreterFactory();
    }

    @Deprecated
    public <T> TokenInterpreter<T> createInterpreter(TokenInterpreterType tokenInterpreterType) {
        switch (tokenInterpreterType) {
            case AR: {
                return new TokenInterpreterAr();
            }
            case DA: {
                return new TokenInterpreterSimplified();
            }
            case DE: {
                return new TokenInterpreterSimplified();
            }
            case EN: {
                return new TokenInterpreterPenn();
            }
            case ES: {
                return new TokenInterpreterEs();
            }
            case FR: {
                return new TokenInterpreterFr();
            }
            case IT: {
                return new TokenInterpreterSimplified();
            }
            case JA: {
                return new TokenInterpreterCJ();
            }
            case KO: {
                return new TokenInterpreterKo();
            }
            case NL: {
                return new TokenInterpreterSimplified();
            }
            case PT: {
                return new TokenInterpreterSimplified();
            }
            case ZH: {
                return new TokenInterpreterCJ();
            }
        }
        throw new UnsupportedOperationException(Messages.format("error.tagger.factory.unsupported", new Object[]{tokenInterpreterType}));
    }

    public <T> TokenInterpreter<T> createInterpreter(String string, Class<?> clazz) {
        if ("ar".equals(string) && ArabicTag.class.equals(clazz)) {
            return new TokenInterpreterAr();
        }
        if ("en".equals(string) && PennTag.class.equals(clazz)) {
            return new TokenInterpreterPenn();
        }
        if ("es".equals(string) && SimplifiedTag.class.equals(clazz)) {
            return new TokenInterpreterEs();
        }
        if ("fr".equals(string) && SimplifiedTag.class.equals(clazz)) {
            return new TokenInterpreterFr();
        }
        if ("ja".equals(string) || "zh".equals(string)) {
            return new TokenInterpreterCJ();
        }
        if ("ko".equals(string)) {
            return new TokenInterpreterKo();
        }
        if (SimplifiedTag.class.equals(clazz)) {
            return new TokenInterpreterSimplified();
        }
        throw new UnsupportedOperationException(Messages.format("error.tagger.factory.unsupported", string));
    }
}

