/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.tagger.interpreter;

import com.ibm.dltj.tagger.feature.CompoundTagFactory;
import com.ibm.dltj.tagger.feature.PennTag;
import com.ibm.dltj.tagger.feature.Tag;
import com.ibm.dltj.tagger.interpreter.TokenInterpreter;
import com.ibm.dltj.token.TokenType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class TokenInterpreterPenn
implements TokenInterpreter<Tag> {
    private final CompoundTagFactory<PennTag> cFactory = CompoundTagFactory.newInstance(PennTag.class);
    private final Tag NNPScTag = this.cFactory.create(PennTag.NNP, PennTag.NNPS);
    private final Map<CharSequence, PennTag> symbols = new HashMap<CharSequence, PennTag>();

    private static boolean matchesNNPS(CharSequence charSequence, int n) {
        if (n <= 0) {
            return false;
        }
        char c = charSequence.charAt(n - 1);
        return c == 's' | c == 'S';
    }

    private static boolean matchesNNS(CharSequence charSequence, int n) {
        if (n <= 1) {
            return false;
        }
        return charSequence.charAt(n - 1) == 's' && charSequence.charAt(n - 2) != 's';
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public TokenInterpreterPenn() {
        this.symbols.put(".", PennTag.EOS);
        this.symbols.put("..", PennTag.EOS);
        this.symbols.put("...", PennTag.EOS);
        this.symbols.put("!", PennTag.EOS);
        this.symbols.put("!!", PennTag.EOS);
        this.symbols.put("!!!", PennTag.EOS);
        this.symbols.put("?", PennTag.EOS);
        this.symbols.put("??", PennTag.EOS);
        this.symbols.put("???", PennTag.EOS);
        this.symbols.put(",", PennTag.COMMA);
        this.symbols.put(",,", PennTag.COMMA);
        this.symbols.put(",,,", PennTag.COMMA);
        this.symbols.put("(", PennTag.LPAREN);
        this.symbols.put("[", PennTag.LPAREN);
        this.symbols.put("{", PennTag.LPAREN);
        this.symbols.put("<", PennTag.LPAREN);
        this.symbols.put(")", PennTag.RPAREN);
        this.symbols.put("]", PennTag.RPAREN);
        this.symbols.put("}", PennTag.RPAREN);
        this.symbols.put(">", PennTag.RPAREN);
        this.symbols.put("`", PennTag.QUOTE);
        this.symbols.put("``", PennTag.QUOTE);
        this.symbols.put("'", PennTag.QUOTE);
        this.symbols.put("''", PennTag.QUOTE);
        this.symbols.put("\u2019", PennTag.QUOTE);
        this.symbols.put("\u2019\u2019", PennTag.QUOTE);
        this.symbols.put("\"", PennTag.QUOTE);
        this.symbols.put("#", PennTag.SYM);
        this.symbols.put("$", PennTag.DOLLAR);
    }

    @Override
    public Tag toTag(CharSequence charSequence, int n, int n2) {
        TokenType tokenType = TokenType.valueOf(charSequence, n, n2);
        CharSequence charSequence2 = charSequence.subSequence(n, n2);
        if (tokenType.isSubType(TokenType.Alphabetic)) {
            if (tokenType.isSubType(TokenType.UppercaseAlphabetic) || tokenType.isSubType(TokenType.TitlecaseAlphabetic)) {
                if (TokenInterpreterPenn.matchesNNPS(charSequence, n2)) {
                    return this.NNPScTag;
                }
                return PennTag.NNP;
            }
            if (TokenInterpreterPenn.matchesNNS(charSequence, n2)) {
                return PennTag.NNS;
            }
            return PennTag.NN;
        }
        if (tokenType.isSubType(TokenType.Numeric)) {
            return PennTag.CD;
        }
        PennTag pennTag = this.symbols.get(charSequence2);
        if (pennTag != null) {
            return pennTag;
        }
        if (tokenType.isSubType(TokenType.Punctuation)) {
            return PennTag.PUNCT;
        }
        return PennTag.UNKNOWN;
    }

    @Override
    public Tag toTag(CharSequence charSequence, int n, int n2, int n3, int n4, int[] nArray, int n5, boolean bl) {
        switch (n3) {
            case 0: 
            case 3: {
                ArrayList<PennTag> arrayList = new ArrayList<PennTag>(n5);
                boolean bl2 = false;
                block37: for (int i = 0; i < n5; ++i) {
                    int n6 = nArray[i];
                    switch (n6) {
                        case 0x410000: {
                            arrayList.add(PennTag.NNPS);
                            continue block37;
                        }
                        case 0x810000: {
                            arrayList.add(PennTag.NNP);
                            continue block37;
                        }
                        case 0x400000: {
                            arrayList.add(PennTag.NNS);
                            continue block37;
                        }
                        case 0x800000: {
                            arrayList.add(PennTag.NN);
                            continue block37;
                        }
                        case 65536: {
                            bl2 = true;
                        }
                    }
                }
                if (arrayList.isEmpty()) {
                    if (TokenInterpreterPenn.matchesNNS(charSequence, n2)) {
                        return bl2 ? PennTag.NNPS : PennTag.NNS;
                    }
                    return bl2 ? PennTag.NNP : PennTag.NN;
                }
                return this.cFactory.create(arrayList);
            }
            case 1: {
                for (int i = 0; i < n5; ++i) {
                    int n7 = nArray[i];
                    if ((n7 & 0x40000) == 0) continue;
                    return PennTag.PRP$;
                }
                return PennTag.PRP;
            }
            case 2: {
                ArrayList<PennTag> arrayList = new ArrayList<PennTag>(n5);
                block39: for (int i = 0; i < n5; ++i) {
                    int n8 = nArray[i];
                    switch (n8) {
                        case 1115684864: 
                        case 0x44800000: {
                            arrayList.add(PennTag.VBP);
                            continue block39;
                        }
                        case 557842432: 
                        case 562036736: 
                        case 0x22400000: 
                        case 0x22800000: 
                        case 0x24400000: 
                        case 612368384: {
                            arrayList.add(PennTag.VBD);
                            continue block39;
                        }
                        case 0x1800000: 
                        case 1098907648: {
                            arrayList.add(PennTag.VBZ);
                            continue block39;
                        }
                        case 0x8000000: {
                            arrayList.add(PennTag.VBN);
                            continue block39;
                        }
                        case 0x10000000: {
                            arrayList.add(PennTag.VBG);
                            continue block39;
                        }
                        case -2147483648: 
                        case 0x41400000: 
                        case 0x42400000: 
                        case 0x44400000: {
                            arrayList.add(PennTag.VB);
                        }
                    }
                }
                if (arrayList.isEmpty()) {
                    CharSequence charSequence2 = charSequence.subSequence(n, n2);
                    if ("ca".equals(charSequence2) || "wo".equals(charSequence2)) {
                        return PennTag.MD;
                    }
                    return PennTag.VB;
                }
                return this.cFactory.create(arrayList);
            }
            case 5: {
                ArrayList<PennTag> arrayList = new ArrayList<PennTag>(n5);
                block40: for (int i = 0; i < n5; ++i) {
                    int n9 = nArray[i];
                    switch (n9) {
                        case 524288: {
                            arrayList.add(PennTag.RBS);
                            continue block40;
                        }
                        case 0x100000: {
                            arrayList.add(PennTag.RBR);
                            continue block40;
                        }
                        case 0x200000: {
                            arrayList.add(PennTag.RB);
                        }
                    }
                }
                if (arrayList.isEmpty()) {
                    return PennTag.RB;
                }
                return this.cFactory.create(arrayList);
            }
            case 4: {
                ArrayList<PennTag> arrayList = new ArrayList<PennTag>(n5);
                block41: for (int i = 0; i < n5; ++i) {
                    int n10 = nArray[i];
                    switch (n10) {
                        case 524288: {
                            arrayList.add(PennTag.JJS);
                            continue block41;
                        }
                        case 0x100000: {
                            arrayList.add(PennTag.JJR);
                            continue block41;
                        }
                        case 0x200000: {
                            arrayList.add(PennTag.JJ);
                        }
                    }
                }
                if (arrayList.isEmpty()) {
                    return PennTag.JJ;
                }
                return this.cFactory.create(arrayList);
            }
            case 7: {
                return PennTag.UH;
            }
            case 6: {
                return PennTag.IN;
            }
            case 8: {
                CharSequence charSequence3 = charSequence.subSequence(n, n2);
                if ("that".equals(charSequence3)) {
                    return PennTag.IN;
                }
                return PennTag.CC;
            }
            case 9: {
                return PennTag.DT;
            }
            case 10: {
                return PennTag.QT;
            }
        }
        return PennTag.UNKNOWN;
    }

    @Override
    public Tag toTag(CharSequence charSequence, int n, int n2, int n3) {
        return this.toTag(charSequence, n, n2);
    }
}

